/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.shell.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Optional;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Position;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import org.graalvm.visualizer.shell.ShellUtils;
import org.graalvm.visualizer.shell.impl.ScrapEditorController;
import org.netbeans.api.actions.Openable;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class ExecuteIGVShell
implements ActionListener {
    public ExecuteIGVShell(InputGraph context) {
    }

    private static FileObject getScriptFile(TopComponent tc) {
        if (tc == null) {
            return null;
        }
        FileObject f = (FileObject)tc.getLookup().lookup(FileObject.class);
        return ShellUtils.isScriptObject(f) ? f : null;
    }

    private static boolean containsEditor(TopComponent tc) {
        JEditorPane[] panes;
        if (tc == null) {
            return false;
        }
        EditorCookie cake = (EditorCookie)tc.getLookup().lookup(EditorCookie.class);
        return cake != null && (panes = cake.getOpenedPanes()) != null && SwingUtilities.isDescendingFrom(panes[0], (Component)tc);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Optional<TopComponent> existing = WindowManager.getDefault().getModes().stream().map(m -> m.getSelectedTopComponent()).filter(tc -> ExecuteIGVShell.containsEditor(tc) && ExecuteIGVShell.getScriptFile(tc) != null).findAny();
        if (existing.isPresent()) {
            TopComponent target = existing.get();
            target.requestActive();
            target.requestFocus();
            return;
        }
        try {
            DataFolder templates = ShellUtils.getTemplatesFolder();
            DataObject selected = null;
            for (DataObject tmpl : templates.getChildren()) {
                if (tmpl.getPrimaryFile().getAttribute("scrapTemplate") == null) continue;
                selected = tmpl;
                break;
            }
            if (selected == null) {
                return;
            }
            DataObject scrap = ShellUtils.createScrapScript(selected);
            Openable o = (Openable)scrap.getLookup().lookup(Openable.class);
            if (o != null) {
                ShellUtils.onScrapMaterialize(scrap.getPrimaryFile(), f -> {
                    TopComponent tc = WindowManager.getDefault().findTopComponent("ScriptNavigatorTopComponent");
                    if (tc != null) {
                        tc.open();
                    }
                });
                final EditorCookie.Observable ecake = (EditorCookie.Observable)scrap.getLookup().lookup(EditorCookie.Observable.class);
                ecake.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (!"openedPanes".equals(evt.getPropertyName())) {
                            return;
                        }
                        JEditorPane[] panes = ecake.getOpenedPanes();
                        if (panes != null) {
                            JEditorPane tPane = panes[0];
                            Position pos = tPane.getDocument().getEndPosition();
                            tPane.getCaret().setDot(Math.max(0, pos.getOffset() - 1));
                        }
                        ecake.removePropertyChangeListener((PropertyChangeListener)this);
                    }
                });
                o.open();
                new ScrapEditorController(scrap).attach();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

