/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.shell.actions;

import java.awt.event.ActionEvent;
import java.util.EventListener;
import java.util.Map;
import javax.swing.Action;
import org.graalvm.visualizer.filter.DiagramFilters;
import org.graalvm.visualizer.filter.FilterProvider;
import org.graalvm.visualizer.shell.actions.AbstractGraphShellAction;
import org.graalvm.visualizer.view.api.DiagramEvent;
import org.graalvm.visualizer.view.api.DiagramListener;
import org.graalvm.visualizer.view.api.DiagramModel;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public class ResetEditorDiagramAction
extends AbstractGraphShellAction
implements DiagramListener {
    private DiagramListener registeredL;

    public ResetEditorDiagramAction(Map<String, ?> attrs, Lookup lkp) {
        super(attrs, lkp);
    }

    public static ResetEditorDiagramAction create(Map<String, ?> params) {
        return new ResetEditorDiagramAction(params, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void diagramModelChanged(DiagramModel previous, DiagramModel current) {
        ResetEditorDiagramAction resetEditorDiagramAction = this;
        synchronized (resetEditorDiagramAction) {
            if (previous != null && this.registeredL != null) {
                previous.removeDiagramListener(this.registeredL);
                this.registeredL = null;
            }
            if (current != null) {
                this.registeredL = (DiagramListener)WeakListeners.create(DiagramListener.class, (EventListener)this, (Object)current);
                current.addDiagramListener(this.registeredL);
            }
        }
    }

    public void stateChanged(DiagramEvent ev) {
        this.refresh();
    }

    public void diagramChanged(DiagramEvent ev) {
        this.refresh();
    }

    public void diagramReady(DiagramEvent ev) {
        this.refresh();
    }

    @Override
    protected boolean computeEnabled(DiagramModel model, FilterProvider filterSource) {
        if (model == null) {
            return false;
        }
        DiagramFilters modelFilters = (DiagramFilters)model.getLookup().lookup(DiagramFilters.class);
        return modelFilters != null && !modelFilters.getScriptFilters().isEmpty();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DiagramModel mdl = this.findDiagramModel();
        if (mdl == null) {
            return;
        }
        DiagramFilters modelFilters = (DiagramFilters)mdl.getLookup().lookup(DiagramFilters.class);
        if (modelFilters == null) {
            return;
        }
        modelFilters.applyScriptFilter(null, null, false, null);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ResetEditorDiagramAction(this.attributes, actionContext);
    }
}

