/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.shell.impl;

import java.awt.Dialog;
import java.awt.GraphicsEnvironment;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.graalvm.visualizer.shell.impl.Bundle;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.autoupdate.ui.api.PluginManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class InstallJavascriptHelper
implements Runnable {
    private static final String PROP_JAVASCRIPT_WARNING = "javascriptDownloadWarning";
    private static final Logger LOG = Logger.getLogger(InstallJavascriptHelper.class.getName());
    final String install = Bundle.BTN_Install();
    final String defer = Bundle.BTN_Defer();
    final String proxy = Bundle.BTN_ProxySettings();

    boolean isWarned() {
        return NbPreferences.forModule(InstallJavascriptHelper.class).getBoolean(PROP_JAVASCRIPT_WARNING, false);
    }

    public void checkJavascript() {
        if (this.isWarned()) {
            return;
        }
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        ClassLoader ldr = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        try {
            ldr.loadClass("org.netbeans.modules.javascript2.editor.api.FrameworksUtils");
            return;
        }
        catch (ClassNotFoundException ex) {
            LOG.info("JavaScript support modules not installed.");
            Dialog[] d = new Dialog[1];
            DialogDescriptor nd = new DialogDescriptor((Object)Bundle.DESC_SourceFeaturesLimited(), Bundle.TITLE_SourceFeaturesLimited(), true, new Object[]{this.install, this.proxy, this.defer, DialogDescriptor.CANCEL_OPTION}, (Object)this.install, 0, HelpCtx.DEFAULT_HELP, ev -> this.perform(ev.getActionCommand(), d[0]));
            d[0] = DialogDisplayer.getDefault().createDialog(nd);
            d[0].setVisible(true);
            return;
        }
    }

    private void perform(String command, Dialog dlg) {
        Preferences prefs = NbPreferences.forModule(InstallJavascriptHelper.class);
        Boolean w = null;
        if (this.install.equals(command)) {
            dlg.setVisible(false);
            w = true;
            PluginManager.installSingle((String)"org.netbeans.modules.javascript2.kit", (String)Bundle.DESC_InstallJavascript(), (Object[])new Object[0]);
        } else if (this.defer.equals(command)) {
            dlg.setVisible(false);
        } else {
            if (this.proxy.equals(command)) {
                OptionsDisplayer.getDefault().open("General");
                return;
            }
            w = true;
            dlg.setVisible(false);
        }
        if (w != null) {
            try {
                prefs.putBoolean(PROP_JAVASCRIPT_WARNING, w);
                prefs.flush();
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    @Override
    public void run() {
        this.checkJavascript();
    }
}

