/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.shell.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import org.graalvm.visualizer.shell.ShellUtils;
import org.graalvm.visualizer.shell.impl.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class ScrapEditorController {
    private static final Logger LOG = Logger.getLogger(ScrapEditorController.class.getName());
    private static final Map<FileObject, Reference<ScrapEditorController>> scraps = new WeakHashMap<FileObject, Reference<ScrapEditorController>>();
    private final FileObject file;
    private final DataObject data;
    private final EditorCookie.Observable editor;
    private final FA listener = new FA();

    public ScrapEditorController(DataObject data) {
        this.data = data;
        this.file = data.getPrimaryFile();
        this.editor = (EditorCookie.Observable)data.getLookup().lookup(EditorCookie.Observable.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ScrapEditorController get(FileObject f) {
        Map<FileObject, Reference<ScrapEditorController>> map = scraps;
        synchronized (map) {
            Reference<ScrapEditorController> refScrap = scraps.get(f);
            return refScrap == null ? null : refScrap.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach() {
        Map<FileObject, Reference<ScrapEditorController>> map = scraps;
        synchronized (map) {
            Reference<ScrapEditorController> refScrap = scraps.get(this.file);
            if (refScrap != null && refScrap.get() != null) {
                return;
            }
            scraps.put(this.file, new WeakReference<ScrapEditorController>(this));
        }
        this.editor.addPropertyChangeListener((PropertyChangeListener)this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detach() {
        Map<FileObject, Reference<ScrapEditorController>> map = scraps;
        synchronized (map) {
            Reference<ScrapEditorController> refScrap = scraps.get(this.file);
            if (refScrap != null && refScrap.get() == this) {
                scraps.remove(this.file);
            }
        }
        this.editor.removePropertyChangeListener((PropertyChangeListener)this.listener);
    }

    private void discardFile() {
        this.editor.removePropertyChangeListener((PropertyChangeListener)this.listener);
        if (this.data.isValid() && !ShellUtils.visibleScriptObjects().test(this.data.getPrimaryFile())) {
            try {
                this.data.delete();
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Could not delete scrap file {0}: {1}", new Object[]{this.file.getPath(), ex.getMessage()});
            }
        }
    }

    private File getNewFileName() {
        NotifyDescriptor nd;
        File initialFolder;
        File newFile = null;
        FileObject currentFileObject = this.file;
        if (null != currentFileObject && null == (newFile = FileUtil.toFile((FileObject)currentFileObject))) {
            newFile = new File(currentFileObject.getNameExt());
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(NbBundle.getMessage(DataObject.class, (String)"LBL_SaveAsTitle"));
        chooser.setMultiSelectionEnabled(false);
        if (null != newFile) {
            chooser.setSelectedFile(newFile);
            chooser.setCurrentDirectory(newFile.getParentFile());
        }
        try {
            FileObject f = ShellUtils.ensureScriptRoot();
            initialFolder = FileUtil.toFile((FileObject)f);
        }
        catch (IOException ex) {
            return null;
        }
        if (null != initialFolder) {
            chooser.setCurrentDirectory(initialFolder);
        }
        File origFile = newFile;
        do {
            if (0 != chooser.showSaveDialog(WindowManager.getDefault().getMainWindow())) {
                return null;
            }
            newFile = chooser.getSelectedFile();
            if (null == newFile) break;
            if (newFile.equals(origFile)) {
                return newFile;
            }
            if (!newFile.exists()) break;
            nd = new NotifyDescriptor((Object)NbBundle.getMessage(DataObject.class, (String)"MSG_SaveAs_OverwriteQuestion", (Object)newFile.getName()), NbBundle.getMessage(DataObject.class, (String)"MSG_SaveAs_OverwriteQuestion_Title"), 0, 3, new Object[]{NotifyDescriptor.NO_OPTION, NotifyDescriptor.YES_OPTION}, NotifyDescriptor.NO_OPTION);
        } while (NotifyDescriptor.YES_OPTION != DialogDisplayer.getDefault().notify(nd));
        return newFile;
    }

    private boolean promptAndRename() {
        FileObject tf;
        Path cfgPath;
        FileObject scriptRoot;
        try {
            scriptRoot = ShellUtils.ensureScriptRoot();
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Could not obtain script root");
            return true;
        }
        final File ff = this.getNewFileName();
        if (ff == null) {
            return false;
        }
        Path dirPath = ff.getParentFile().toPath();
        if (dirPath.startsWith(cfgPath = FileUtil.toFile((FileObject)FileUtil.getConfigRoot()).toPath())) {
            String rel = cfgPath.relativize(dirPath).toString();
            tf = FileUtil.getConfigRoot().getFileObject(rel);
        } else {
            tf = FileUtil.toFileObject((File)ff.getParentFile());
        }
        FileObject newFileO = tf == null ? null : tf.getFileObject(ff.getName());
        URL u1 = URLMapper.findURL((FileObject)newFileO, (int)1);
        URL u2 = URLMapper.findURL((FileObject)this.file, (int)1);
        if (u1 != null && u2 != null && Objects.equals(u1.getPath(), u2.getPath())) {
            ShellUtils.materializeScrapFile(this.file);
            return true;
        }
        try {
            scriptRoot.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    if (tf == null) {
                        throw new FileNotFoundException(ff.getParentFile().getPath());
                    }
                    DataFolder target = DataFolder.findFolder((FileObject)tf);
                    if (target == null) {
                        throw new FileNotFoundException(ff.getParentFile().getPath());
                    }
                    String n = ff.getName();
                    int dotIndex = n.lastIndexOf(46);
                    if (dotIndex != -1) {
                        String suffix = n.substring(dotIndex + 1);
                        if (!suffix.equals(ScrapEditorController.this.file.getExt())) {
                            ScrapEditorController.this.data.setModified(true);
                            JEditorPane[] panes = ScrapEditorController.this.editor.getOpenedPanes();
                            if (panes == null) {
                                ScrapEditorController.this.editor.open();
                            }
                            throw new IOException("Extension change not permitted");
                        }
                        n = n.substring(0, dotIndex);
                    }
                    ScrapEditorController.this.data.rename(n);
                    if (tf != ScrapEditorController.this.data.getPrimaryFile().getParent()) {
                        ScrapEditorController.this.data.move(target);
                    }
                    ShellUtils.materializeScrapFile(ScrapEditorController.this.data.getPrimaryFile());
                    if (tf != scriptRoot && !FileUtil.isParentOf((FileObject)scriptRoot, (FileObject)tf)) {
                        DataShadow.create((DataFolder)DataFolder.findFolder((FileObject)scriptRoot), (DataObject)ScrapEditorController.this.data);
                    }
                }
            });
            return true;
        }
        catch (IOException ex) {
            NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)Bundle.ERR_SaveFile(ff.getName()), 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)d);
            return false;
        }
    }

    class FA
    extends FileChangeAdapter
    implements PropertyChangeListener {
        FA() {
        }

        public void fileChanged(FileEvent fe) {
            super.fileChanged(fe);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == ScrapEditorController.this.editor) {
                switch (evt.getPropertyName()) {
                    case "openedPanes": {
                        if (ScrapEditorController.this.editor.getOpenedPanes() != null) break;
                        ScrapEditorController.this.discardFile();
                        break;
                    }
                    case "modified": {
                        if (!Boolean.FALSE.equals(evt.getNewValue()) || !ScrapEditorController.this.promptAndRename()) break;
                        ScrapEditorController.this.editor.removePropertyChangeListener((PropertyChangeListener)this);
                    }
                }
            }
        }
    }

    public static class RegistryObserver
    implements PropertyChangeListener,
    Runnable {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("tcOpened".equals(evt.getPropertyName())) {
                ScrapEditorController ctrl;
                FileObject f;
                if (!(evt.getNewValue() instanceof TopComponent)) {
                    return;
                }
                TopComponent tc = (TopComponent)evt.getNewValue();
                if (tc != null && ShellUtils.isScriptObject(f = (FileObject)tc.getLookup().lookup(FileObject.class)) && !ShellUtils.visibleScriptObjects().test(f) && (ctrl = ScrapEditorController.get(f)) == null) {
                    try {
                        new ScrapEditorController(DataObject.find((FileObject)f)).attach();
                    }
                    catch (DataObjectNotFoundException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }

        @Override
        public void run() {
            TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        }
    }
}

