/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.shell.list;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Set;
import javax.swing.AbstractAction;
import org.graalvm.visualizer.shell.ShellUtils;
import org.graalvm.visualizer.shell.list.Bundle;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class NewScriptAction
extends AbstractAction {
    private final FileObject folder;

    public NewScriptAction(FileObject folder) {
        super(Bundle.LBL_NewScript());
        this.folder = folder;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FileObject scriptRoot;
        TemplateWizard wiz = new TemplateWizard();
        try {
            scriptRoot = ShellUtils.ensureScriptRoot();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)Bundle.ERR_CannotCreateScripts(ex.toString())));
            return;
        }
        DataFolder scriptFolder = DataFolder.findFolder((FileObject)this.folder);
        wiz.setTargetFolder(scriptFolder);
        try {
            wiz.setTemplate(ShellUtils.getLastScriptTemplate());
            wiz.setTemplatesFolder(ShellUtils.getTemplatesFolder());
            Set files = wiz.instantiate();
            if (files != null && !files.isEmpty()) {
                DataObject x = this.createScriptFolderShadow(((DataObject)files.iterator().next()).getPrimaryFile(), scriptRoot);
                ShellUtils.onScrapMaterialize(x.getPrimaryFile(), f -> {
                    TopComponent tc = WindowManager.getDefault().findTopComponent("ScriptNavigatorTopComponent");
                    if (tc != null) {
                        tc.open();
                    }
                });
                ShellUtils.setLastScriptTemplate(wiz.getTemplate());
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private DataObject createScriptFolderShadow(FileObject script, FileObject rootScriptFolder) throws IOException {
        if (FileUtil.isParentOf((FileObject)rootScriptFolder, (FileObject)script)) {
            return DataObject.find((FileObject)script);
        }
        return DataShadow.create((DataFolder)DataFolder.findFolder((FileObject)this.folder), (DataObject)DataObject.find((FileObject)script));
    }
}

