/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.shell.list;

import java.io.IOException;
import javax.swing.Action;
import org.graalvm.visualizer.shell.ShellUtils;
import org.graalvm.visualizer.shell.actions.CreateFilterAction;
import org.netbeans.api.actions.Editable;
import org.netbeans.api.actions.Openable;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class ScriptNode
extends FilterNode {
    private ScriptNode(Node original, Children children, Lookup lookup) {
        super(original, children, lookup);
    }

    static ScriptNode create(Node original, Children children) {
        Lookup lkp = ScriptNode.createLookup(original);
        return new ScriptNode(original, children, lkp);
    }

    public Action[] getActions(boolean context) {
        Action[] ac = super.getActions(context);
        Action cfa = CreateFilterAction.createContextAction(this.getLookup());
        if (cfa == null) {
            return ac;
        }
        Action[] nac = new Action[ac.length + 1];
        System.arraycopy(ac, 0, nac, 0, ac.length);
        nac[ac.length] = cfa;
        return nac;
    }

    private static Lookup createLookup(Node original) {
        FileObject f = (FileObject)original.getLookup().lookup(FileObject.class);
        if (f == null) {
            return original.getLookup();
        }
        final OC replaceCookie = new OC(f, original);
        Lookup myLkp = Lookups.fixed((Object[])new Class[]{OpenCookie.class, Openable.class, EditCookie.class, Editable.class}, (InstanceContent.Convertor)new InstanceContent.Convertor<Class, Object>(){

            public Object convert(Class obj) {
                return replaceCookie;
            }

            public Class<? extends Object> type(Class obj) {
                return obj;
            }

            public String id(Class obj) {
                return obj.getName();
            }

            public String displayName(Class obj) {
                return obj.getName();
            }
        });
        Lookup excl = Lookups.exclude((Lookup)original.getLookup(), (Class[])new Class[]{OpenCookie.class, Openable.class, EditCookie.class, Editable.class});
        return new ProxyLookup(new Lookup[]{myLkp, excl});
    }

    static class OC
    implements OpenCookie,
    EditCookie {
        private final FileObject file;
        private final Node original;
        private OpenCookie delOpenCookie;
        private EditCookie delEditCookie;

        public OC(FileObject file, Node original) {
            this.file = file;
            this.original = original;
        }

        private void markWrapper(Runnable r) {
            try {
                ShellUtils.markScriptObject(this.file, true);
                r.run();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private synchronized void initCookies() {
            if (this.delOpenCookie != null) {
                return;
            }
            this.delOpenCookie = (OpenCookie)this.original.getLookup().lookup(OpenCookie.class);
            this.delEditCookie = (EditCookie)this.original.getLookup().lookup(EditCookie.class);
        }

        public void open() {
            this.initCookies();
            this.markWrapper(() -> this.delOpenCookie.open());
        }

        public void edit() {
            this.initCookies();
            this.markWrapper(() -> this.delEditCookie.edit());
        }
    }
}

