/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.shell.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.util.Properties;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import org.graalvm.visualizer.shell.ShellUtils;
import org.graalvm.visualizer.shell.list.ScriptFolderNode;
import org.graalvm.visualizer.shell.ui.Bundle;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="ScriptNavigatorTopComponent", persistenceType=0)
public final class ScriptNavigatorTopComponent
extends TopComponent
implements ExplorerManager.Provider {
    public static final String ID = "ScriptNavigatorTopComponent";
    private final ExplorerManager listMan = new ExplorerManager();
    private final BeanTreeView contentView = new BeanTreeView();
    private JPanel contentPanel;

    public ScriptNavigatorTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_ScriptNavigatorTopComponent());
        this.setToolTipText(Bundle.HINT_ScriptNavigatorTopComponent());
        this.putClientProperty("netbeans.winsys.tc.keep_preferred_size_when_slided_in", Boolean.TRUE);
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.listMan));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.listMan));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.listMan));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.listMan, (boolean)true));
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.listMan, (ActionMap)map));
        ExplorerUtils.activateActions((ExplorerManager)this.listMan, (boolean)true);
        this.listMan.addPropertyChangeListener(e -> {
            String n = e.getPropertyName();
            if ("selectedNodes".equals(n)) {
                this.setActivatedNodes((Node[])e.getNewValue());
            }
        });
        this.contentView.setRootVisible(false);
        try {
            FileObject root = ShellUtils.getScriptRoot();
            DataObject droot = DataObject.find((FileObject)root);
            Node orig = droot.getNodeDelegate();
            ScriptFolderNode n = new ScriptFolderNode(orig);
            this.listMan.setRootContext((Node)n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.contentPanel.add((Component)this.contentView, "Center");
    }

    public ExplorerManager getExplorerManager() {
        return this.listMan;
    }

    private void initComponents() {
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.contentPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.contentPanel, -1, -1, Short.MAX_VALUE));
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

