/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public abstract class HintAction
extends TextAction
implements PropertyChangeListener {
    protected HintAction() {
        this(null);
    }

    protected HintAction(String key) {
        super(key);
        this.putValue("noIconInMenu", Boolean.TRUE);
        EditorRegistry.addPropertyChangeListener((PropertyChangeListener)WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
        this.setEnabled(false);
        this.updateEnabled();
    }

    private void updateEnabled() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HintAction.this.doUpdateEnabled();
                }
            });
        } else {
            this.doUpdateEnabled();
        }
    }

    private void doUpdateEnabled() {
        this.setEnabled(this.getCurrentFile(null) != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String error = this.doPerform();
        if (error != null) {
            String errorText = NbBundle.getMessage(HintAction.class, (String)error);
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)errorText, 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
        }
    }

    private String doPerform() {
        Document doc;
        int[] span = new int[2];
        JTextComponent pane = this.getCurrentFile(span);
        Document document = doc = pane != null ? pane.getDocument() : null;
        if (doc == null) {
            if (span[0] != span[1]) {
                return "ERR_Not_Selected";
            }
            return "ERR_No_Selection";
        }
        JavaSource js = JavaSource.forDocument((Document)doc);
        if (js == null) {
            return "ERR_Not_Supported";
        }
        this.perform(js, pane, span);
        return null;
    }

    protected abstract void perform(JavaSource var1, JTextComponent var2, int[] var3);

    private JTextComponent getCurrentFile(int[] span) {
        Container c;
        Object stream;
        JTextComponent pane = EditorRegistry.lastFocusedComponent();
        if (pane == null) {
            return null;
        }
        Document doc = pane.getDocument();
        Object object = stream = doc != null ? doc.getProperty("stream") : null;
        if (!(stream instanceof DataObject)) {
            return null;
        }
        if (!"text/x-java".equals(NbEditorUtilities.getMimeType((Document)doc))) {
            return null;
        }
        TopComponent tc = TopComponent.getRegistry().getActivated();
        for (c = pane; c != null && c != tc; c = c.getParent()) {
        }
        if (c == null) {
            return null;
        }
        if (span != null) {
            span[0] = pane.getSelectionStart();
            span[1] = pane.getSelectionEnd();
            if (span[0] == span[1] && this.requiresSelection()) {
                return null;
            }
        }
        return pane;
    }

    protected boolean requiresSelection() {
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateEnabled();
    }
}

