/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.updater;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.MultiBits;
import org.apache.lucene.util.Bits;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.IndexerField;
import org.apache.maven.index.context.IndexingContext;

public class IndexDataWriter {
    static final int VERSION = 1;
    static final int F_INDEXED = 1;
    static final int F_TOKENIZED = 2;
    static final int F_STORED = 4;
    static final int F_COMPRESSED = 8;
    private final DataOutputStream dos;
    private final GZIPOutputStream gos;
    private final BufferedOutputStream bos;
    private boolean descriptorWritten;

    public IndexDataWriter(OutputStream os) throws IOException {
        this.bos = new BufferedOutputStream(os, 8192);
        this.gos = new GZIPOutputStream((OutputStream)this.bos, 2048);
        this.dos = new DataOutputStream(this.gos);
        this.descriptorWritten = false;
    }

    public int write(IndexingContext context, IndexReader indexReader, List<Integer> docIndexes) throws IOException {
        this.writeHeader(context);
        int n = this.writeDocuments(indexReader, docIndexes);
        this.writeGroupFields(context);
        this.close();
        return n;
    }

    public void close() throws IOException {
        this.dos.flush();
        this.gos.flush();
        this.gos.finish();
        this.bos.flush();
    }

    public void writeHeader(IndexingContext context) throws IOException {
        this.dos.writeByte(1);
        Date timestamp = context.getTimestamp();
        this.dos.writeLong(timestamp == null ? -1L : timestamp.getTime());
    }

    public void writeGroupFields(IndexingContext context) throws IOException {
        ArrayList<IndexableField> allGroupsFields = new ArrayList<IndexableField>(2);
        allGroupsFields.add((IndexableField)new Field("allGroups", (CharSequence)"allGroups", (IndexableFieldType)IndexerField.KEYWORD_STORED));
        allGroupsFields.add((IndexableField)new StoredField("allGroupsList", ArtifactInfo.lst2str(context.getAllGroups()), IndexerField.KEYWORD_STORED));
        this.writeDocumentFields(allGroupsFields);
        ArrayList<IndexableField> rootGroupsFields = new ArrayList<IndexableField>(2);
        rootGroupsFields.add((IndexableField)new Field("rootGroups", (CharSequence)"rootGroups", (IndexableFieldType)IndexerField.KEYWORD_STORED));
        rootGroupsFields.add((IndexableField)new StoredField("rootGroupsList", ArtifactInfo.lst2str(context.getRootGroups()), IndexerField.KEYWORD_STORED));
        this.writeDocumentFields(rootGroupsFields);
    }

    public int writeDocuments(IndexReader r, List<Integer> docIndexes) throws IOException {
        int n = 0;
        Bits liveDocs = MultiBits.getLiveDocs((IndexReader)r);
        if (docIndexes == null) {
            for (int i = 0; i < r.maxDoc(); ++i) {
                if (liveDocs != null && !liveDocs.get(i) || !this.writeDocument(r.document(i))) continue;
                ++n;
            }
        } else {
            for (int i : docIndexes) {
                if (liveDocs != null && !liveDocs.get(i) || !this.writeDocument(r.document(i))) continue;
                ++n;
            }
        }
        return n;
    }

    public boolean writeDocument(Document document) throws IOException {
        List fields = document.getFields();
        ArrayList<IndexableField> storedFields = new ArrayList<IndexableField>(fields.size());
        for (IndexableField field : fields) {
            if ("DESCRIPTOR".equals(field.name())) {
                if (this.descriptorWritten) {
                    return false;
                }
                this.descriptorWritten = true;
            }
            if (!field.fieldType().stored()) continue;
            storedFields.add(field);
        }
        this.writeDocumentFields(storedFields);
        return true;
    }

    public void writeDocumentFields(List<IndexableField> fields) throws IOException {
        this.dos.writeInt(fields.size());
        for (IndexableField field : fields) {
            this.writeField(field);
        }
    }

    public void writeField(IndexableField field) throws IOException {
        int flags = (field.fieldType().indexOptions() != IndexOptions.NONE ? 1 : 0) + (field.fieldType().tokenized() ? 2 : 0) + (field.fieldType().stored() ? 4 : 0);
        String name = field.name();
        String value = field.stringValue();
        this.dos.write(flags);
        this.dos.writeUTF(name);
        IndexDataWriter.writeUTF(value, this.dos);
    }

    private static void writeUTF(String str, DataOutput out) throws IOException {
        int i;
        char c;
        int strlen = str.length();
        int utflen = 0;
        for (int i2 = 0; i2 < strlen; ++i2) {
            c = str.charAt(i2);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        out.writeInt(utflen);
        byte[] bytearr = new byte[utflen];
        int count = 0;
        for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c & 0x3F);
            }
            ++i;
        }
        out.write(bytearr, 0, utflen);
    }
}

