/*
 * Decompiled with CFR 0.152.
 */
package net.vieiro.toml;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.vieiro.toml.TOMLVisitor;
import net.vieiro.toml.antlr4.TOMLAntlrParser;
import org.antlr.v4.runtime.ParserRuleContext;

final class TOMLStringVisitor {
    private static final Pattern HAS_CONTROL_CHARS = Pattern.compile(".*([\\u0000-\\u0008\\u000B\\u000e\\u0010-\\u001F\\u007F]).*");

    TOMLStringVisitor() {
    }

    static boolean isUnicodeScalar(int codePoint) {
        return 0 <= codePoint && codePoint <= 14155542 || 14680086 <= codePoint && codePoint <= 285212438;
    }

    static boolean isSurrogatePair(int codepoint) {
        return Character.isSurrogate((char)codepoint);
    }

    static String unescapeTOMLString(String st) throws Exception {
        if (st.indexOf(92) == -1) {
            return st;
        }
        StringBuilder sb = new StringBuilder(st.length());
        block13: for (int i = 0; i < st.length(); ++i) {
            int ch = st.charAt(i);
            if (ch == 92) {
                char nextChar;
                char c = nextChar = i == st.length() - 1 ? (char)'\\' : (char)st.charAt(i + 1);
                if (nextChar >= '0' && nextChar <= '7') {
                    String code = "" + nextChar;
                    if (++i < st.length() - 1 && st.charAt(i + 1) >= '0' && st.charAt(i + 1) <= '7') {
                        code = code + st.charAt(i + 1);
                        if (++i < st.length() - 1 && st.charAt(i + 1) >= '0' && st.charAt(i + 1) <= '7') {
                            code = code + st.charAt(i + 1);
                            ++i;
                        }
                    }
                    sb.append((char)Integer.parseInt(code, 8));
                    continue;
                }
                if (Character.isWhitespace(nextChar)) {
                    char c2;
                    boolean newLineFound = nextChar == '\n';
                    int newi = i + 1;
                    int j = i + 2;
                    while (j < st.length() && Character.isWhitespace((int)(c2 = st.charAt(j)))) {
                        newLineFound = newLineFound || c2 == '\n';
                        newi = j++;
                    }
                    if (newLineFound) {
                        i = newi;
                        continue;
                    }
                }
                switch (nextChar) {
                    case '\\': {
                        ch = 92;
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        continue block13;
                    }
                    case 'b': {
                        ch = 8;
                        break;
                    }
                    case 'f': {
                        ch = 12;
                        break;
                    }
                    case 'n': {
                        ch = 10;
                        break;
                    }
                    case 'r': {
                        ch = 13;
                        break;
                    }
                    case 't': {
                        ch = 9;
                        break;
                    }
                    case '\"': {
                        ch = 34;
                        break;
                    }
                    case '\'': {
                        ch = 39;
                        break;
                    }
                    case 'u': {
                        if (i >= st.length() - 5) {
                            ch = 117;
                            break;
                        }
                        int code = Integer.parseInt("" + st.charAt(i + 2) + st.charAt(i + 3) + st.charAt(i + 4) + st.charAt(i + 5), 16);
                        if (!TOMLStringVisitor.isUnicodeScalar(code)) {
                            throw new Exception(String.format("Unicode point \\u%X is not a Unicode scalar", code));
                        }
                        if (TOMLStringVisitor.isSurrogatePair(code)) {
                            throw new Exception(String.format("Unicode point \\u%X is an Unicode surrogate pair", code));
                        }
                        sb.append(Character.toChars(code));
                        i += 5;
                        continue block13;
                    }
                    case 'U': {
                        if (i >= st.length() - 9) {
                            ch = 85;
                            break;
                        }
                        int code = Integer.parseInt("" + st.charAt(i + 2) + st.charAt(i + 3) + st.charAt(i + 4) + st.charAt(i + 5) + st.charAt(i + 6) + st.charAt(i + 7) + st.charAt(i + 8) + st.charAt(i + 9), 16);
                        if (!TOMLStringVisitor.isUnicodeScalar(code)) {
                            throw new Exception(String.format("Unicode point \\u%X is not a Unicode scalar", code));
                        }
                        sb.append(Character.toChars(code));
                        i += 9;
                        continue block13;
                    }
                    default: {
                        throw new Exception("Bad escape sequence '\\" + nextChar + "'");
                    }
                }
                ++i;
            }
            sb.append((char)ch);
        }
        return sb.toString();
    }

    private static final void detectUnquotedControlChars(ParserRuleContext ctx, String value) {
        Matcher matcher = HAS_CONTROL_CHARS.matcher(value);
        if (matcher.matches()) {
            ArrayList<String> chars = new ArrayList<String>();
            while (matcher.find()) {
                chars.add(String.format("0x%02x", Character.valueOf(matcher.group(1).charAt(0))));
                if (chars.size() <= 10) continue;
                chars.add("...");
                break;
            }
            String offending = String.join((CharSequence)",", chars);
            throw TOMLVisitor.newPCException(ctx, String.format("String value contains illegal Unicode control characters (%s)", offending));
        }
    }

    static Object visitString(TOMLAntlrParser.StringContext ctx) {
        try {
            String value = null;
            if (ctx.BASIC_STRING() != null) {
                String BASIC_STRING = ctx.BASIC_STRING().getText();
                BASIC_STRING = BASIC_STRING.substring(1, BASIC_STRING.length() - 1);
                TOMLStringVisitor.detectUnquotedControlChars(ctx, BASIC_STRING);
                value = TOMLStringVisitor.unescapeTOMLString(BASIC_STRING);
            } else if (ctx.ML_BASIC_STRING() != null) {
                String ML_BASIC_STRING = ctx.ML_BASIC_STRING().getText();
                if ((ML_BASIC_STRING = ML_BASIC_STRING.substring(3, ML_BASIC_STRING.length() - 3)).endsWith("\"\"\"") && !ML_BASIC_STRING.endsWith("\\\"\"\"")) {
                    throw TOMLVisitor.newPCException((ParserRuleContext)ctx, "Illegal basic multiline string");
                }
                TOMLStringVisitor.detectUnquotedControlChars(ctx, ML_BASIC_STRING);
                ML_BASIC_STRING = TOMLStringVisitor.unescapeTOMLString(ML_BASIC_STRING);
                value = ML_BASIC_STRING = ML_BASIC_STRING.replaceAll("^\r?\n", "");
            } else if (ctx.LITERAL_STRING() != null) {
                String LITERAL_STRING = ctx.LITERAL_STRING().getText();
                LITERAL_STRING = LITERAL_STRING.substring(1, LITERAL_STRING.length() - 1);
                TOMLStringVisitor.detectUnquotedControlChars(ctx, LITERAL_STRING);
                value = LITERAL_STRING = LITERAL_STRING.replaceAll("^\r?\n", "");
            } else if (ctx.ML_LITERAL_STRING() != null) {
                String ML_LITERAL_STRING = ctx.ML_LITERAL_STRING().getText();
                if ((ML_LITERAL_STRING = ML_LITERAL_STRING.substring(3, ML_LITERAL_STRING.length() - 3)).endsWith("'''") && !ML_LITERAL_STRING.endsWith("\\'''")) {
                    throw TOMLVisitor.newPCException((ParserRuleContext)ctx, "Illegal literal string");
                }
                TOMLStringVisitor.detectUnquotedControlChars(ctx, ML_LITERAL_STRING);
                value = ML_LITERAL_STRING = ML_LITERAL_STRING.replaceAll("^\r?\n", "");
            } else {
                throw TOMLVisitor.newPCException((ParserRuleContext)ctx, "Unsupported TOML string type.");
            }
            return value;
        }
        catch (Exception e) {
            throw TOMLVisitor.newPCException((ParserRuleContext)ctx, e);
        }
    }

    static Object visitQuoted_key(TOMLAntlrParser.Quoted_keyContext ctx) {
        try {
            String value = null;
            if (ctx.BASIC_STRING() != null) {
                String BASIC_STRING = ctx.BASIC_STRING().getText();
                TOMLStringVisitor.detectUnquotedControlChars(ctx, BASIC_STRING);
                BASIC_STRING = BASIC_STRING.substring(1, BASIC_STRING.length() - 1);
                value = TOMLStringVisitor.unescapeTOMLString(BASIC_STRING);
            } else if (ctx.LITERAL_STRING() != null) {
                String LITERAL_STRING = ctx.LITERAL_STRING().getText();
                TOMLStringVisitor.detectUnquotedControlChars(ctx, LITERAL_STRING);
                value = LITERAL_STRING = LITERAL_STRING.substring(1, LITERAL_STRING.length() - 1);
            } else {
                throw TOMLVisitor.newPCException((ParserRuleContext)ctx, "Unsupported quoted key value type");
            }
            return value;
        }
        catch (Exception e) {
            throw TOMLVisitor.newPCException((ParserRuleContext)ctx, e);
        }
    }

    static Object visitUnquoted_key(TOMLAntlrParser.Unquoted_keyContext ctx) {
        String UNQUOTED_KEY = ctx.UNQUOTED_KEY().getText();
        if (UNQUOTED_KEY.indexOf(46) != -1) {
            throw new IllegalStateException("Grammar shouldn't allow dots in UNQUOTED_KEY.");
        }
        return UNQUOTED_KEY.trim();
    }
}

