/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.notifications;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.notifications.BalloonManager;
import org.netbeans.modules.notifications.NotificationImpl;
import org.netbeans.modules.notifications.center.NotificationCenterManager;
import org.openide.awt.GraphicsUtils;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

class FlashingIcon
extends JLabel
implements MouseListener,
PropertyChangeListener {
    protected int STOP_FLASHING_DELAY = 5000;
    protected int DISAPPEAR_DELAY_MILLIS = this.STOP_FLASHING_DELAY + 50000;
    protected int FLASHING_FREQUENCY = 500;
    private NotificationImpl currentNotification;
    private final NotificationCenterManager manager;

    protected FlashingIcon() {
        this.addMouseListener(this);
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.manager = NotificationCenterManager.getInstance();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        int unreadCount = this.manager.getUnreadCount();
        this.currentNotification = this.manager.getLastUnreadNotification();
        this.setIcon(this.getNotificationsIcon(unreadCount, this.currentNotification != null ? this.currentNotification.getCategory() == NotificationDisplayer.Category.ERROR : false));
        this.setToolTipText(this.getToolTip(unreadCount, this.currentNotification));
        this.setVisible(unreadCount > 0);
        this.manager.addPropertyChangeListener(this);
    }

    @Override
    public void removeNotify() {
        NotificationCenterManager manager = NotificationCenterManager.getInstance();
        if (manager != null) {
            manager.removePropertyChangeListener(this);
        }
        this.currentNotification = null;
        super.removeNotify();
    }

    @Override
    public void setIcon(Icon icon) {
        if (null != icon) {
            icon = new MyIcon(icon);
        }
        super.setIcon(icon);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.onMouseClick();
    }

    protected void onMouseClick() {
        TopComponent tc = WindowManager.getDefault().findTopComponent("NotificationCenterTopComponent");
        tc.open();
        tc.requestActive();
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        JToolTip tip = this.createToolTip();
        tip.setTipText(this.getToolTipText());
        Dimension d = tip.getPreferredSize();
        Point retValue = new Point(this.getWidth() - d.width, -d.height);
        return retValue;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("notificationAdded".equals(evt.getPropertyName())) {
            NotificationImpl ni = (NotificationImpl)evt.getNewValue();
            this.setNotification(ni, ni.showBallon());
        } else if ("notificationRead".equals(evt.getPropertyName())) {
            NotificationImpl top = this.manager.getLastUnreadNotification();
            this.setNotification(top, false);
            BalloonManager.dismiss();
        } else if ("notificationsChanged".equals(evt.getPropertyName())) {
            NotificationImpl top = this.manager.getLastUnreadNotification();
            this.setNotification(top, false);
        }
    }

    private boolean canShowBalloon() {
        return !Boolean.getBoolean("nb.notification.balloon.disable");
    }

    private void setNotification(final NotificationImpl n, boolean showBalloon) {
        int notificationCount = this.manager.getUnreadCount();
        this.setToolTipText(this.getToolTip(notificationCount, n));
        this.setIcon(this.getNotificationsIcon(notificationCount, n != null ? n.getCategory() == NotificationDisplayer.Category.ERROR : false));
        this.setVisible(notificationCount > 0);
        this.currentNotification = n;
        if (null != this.currentNotification) {
            if (showBalloon && this.canShowBalloon()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (null == FlashingIcon.this.currentNotification || null == FlashingIcon.this.currentNotification.getBalloonComp()) {
                            return;
                        }
                        BalloonManager.show(FlashingIcon.this, FlashingIcon.this.currentNotification.getBalloonComp(), null, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                n.markAsRead(true);
                            }
                        }, 3000);
                    }
                });
            }
        } else {
            BalloonManager.dismiss();
        }
    }

    private String getToolTip(int unread, NotificationImpl n) {
        if (unread < 1) {
            return null;
        }
        String tooltip = "<b>" + NbBundle.getMessage(FlashingIcon.class, (String)(unread == 1 ? "LBL_UnreadNotification" : "LBL_UnreadNotifications"), (Object)unread) + "</b>";
        if (n != null) {
            tooltip = tooltip + "<br>" + NbBundle.getMessage(FlashingIcon.class, (String)"LBL_LastNotification") + " " + n.getTitle();
        }
        tooltip = "<html>" + tooltip + "</html>";
        return tooltip;
    }

    private Icon getNotificationsIcon(int unread, boolean isError) {
        ImageIcon icon = isError ? ImageUtilities.loadImageIcon((String)"org/netbeans/modules/notifications/resources/notificationsError.png", (boolean)true) : ImageUtilities.loadImageIcon((String)"org/netbeans/modules/notifications/resources/notifications.png", (boolean)true);
        Font font = this.getFont().deriveFont(10.0f);
        Color color = "Nimbus".equals(UIManager.getLookAndFeel().getID()) ? (isError ? Color.RED : Color.BLACK) : (isError ? UIManager.getColor("nb.errorForeground") : UIManager.getColor("Label.foreground"));
        return new CountIcon(icon, font, color, unread);
    }

    private class MyIcon
    implements Icon {
        private Icon orig;

        public MyIcon(Icon orig) {
            this.orig = orig;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.orig.paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.orig.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.orig.getIconHeight();
        }
    }

    private static final class CountIcon
    implements Icon {
        private final Icon baseIcon;
        private final Font font;
        private final Color color;
        private final int unread;

        public CountIcon(Icon baseIcon, Font font, Color color, int unread) {
            this.baseIcon = baseIcon;
            this.font = font;
            this.color = color;
            this.unread = unread;
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            GraphicsUtils.configureDefaultRenderingHints((Graphics)g);
            this.baseIcon.paintIcon(c, g, x, y);
            g.setFont(this.font);
            g.setColor(this.color);
            if (this.unread < 10) {
                g.setFont(this.font.deriveFont(1));
                g.drawString(Integer.toString(this.unread), x + 5, y + 10);
            } else if (this.unread < 100) {
                g.drawString(Integer.toString(this.unread), x + 3, y + 10);
            } else {
                g.drawString("...", x + 2, y + 10);
            }
        }
    }
}

