/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graphio.parsing;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import jdk.graal.compiler.graphio.parsing.DataSource;
import jdk.graal.compiler.graphio.parsing.VersionMismatchException;

public final class StreamSource
implements DataSource {
    static final byte[] MAGIC_BYTES = new byte[]{66, 73, 71, 86};
    static final int CURRENT_MAJOR_VERSION = 8;
    static final int CURRENT_MINOR_VERSION = 0;
    static final String CURRENT_VERSION = StreamSource.versionPair(8, 0);
    private final DataInputStream in;
    private int majorVersion;
    private int minorVersion;

    public StreamSource(InputStream is) {
        this.in = new DataInputStream(is);
    }

    @Override
    public int readByte() throws IOException {
        return this.in.readByte();
    }

    @Override
    public char readShort() throws IOException {
        return (char)this.in.readShort();
    }

    @Override
    public int readInt() throws IOException {
        return this.in.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.in.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    @Override
    public boolean readHeader() throws IOException {
        this.in.mark(MAGIC_BYTES.length);
        byte[] magic = this.readBytes(MAGIC_BYTES.length);
        if (Arrays.equals(MAGIC_BYTES, magic)) {
            this.setVersion(this.readByte(), this.readByte());
            return true;
        }
        this.in.reset();
        return false;
    }

    @Override
    public double[] readDoubles() throws IOException {
        int len = this.readInt();
        if (len < 0) {
            return null;
        }
        double[] props = new double[len];
        for (int i = 0; i < len; ++i) {
            props[i] = this.in.readDouble();
        }
        return props;
    }

    @Override
    public int[] readInts() throws IOException {
        int len = this.readInt();
        if (len < 0) {
            return null;
        }
        int[] props = new int[len];
        for (int i = 0; i < len; ++i) {
            props[i] = this.in.readInt();
        }
        return props;
    }

    @Override
    public String readString() throws IOException {
        return new String(this.readBytes(), StandardCharsets.UTF_8);
    }

    @Override
    public byte[] readBytes() throws IOException {
        int len = this.readInt();
        if (len < 0) {
            return null;
        }
        return this.readBytes(len);
    }

    @Override
    public byte[] readBytes(int len) throws IOException {
        return this.readBytes(new byte[len], len);
    }

    @Override
    public byte[] readBytes(byte[] b, int len) throws IOException {
        this.in.readFully(b, 0, len);
        return b;
    }

    @Override
    public long getMark() {
        throw new UnsupportedOperationException("getMark");
    }

    private void setVersion(int newMajorVersion, int newMinorVersion) throws IOException {
        if (newMajorVersion > 8 || newMajorVersion == 8 && newMinorVersion > 0) {
            throw new VersionMismatchException("File format version " + StreamSource.versionPair(newMajorVersion, newMinorVersion) + " unsupported.  Current version is " + CURRENT_VERSION);
        }
        this.majorVersion = newMajorVersion;
        this.minorVersion = newMinorVersion;
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public void startDigest() {
    }

    @Override
    public byte[] finishDigest() {
        return null;
    }

    static String versionPair(int major, int minor) {
        return major + "." + minor;
    }
}

