/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graphio.parsing.model;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jdk.graal.compiler.graphio.parsing.model.ChangedEvent;
import jdk.graal.compiler.graphio.parsing.model.Property;

public abstract class Properties
implements Iterable<Property<Object>> {
    public static Properties immutableEmpty() {
        return SharedProperties.EMPTY;
    }

    public static Properties newProperties() {
        return new LinkedHashMapProperties();
    }

    public static Properties newProperties(Properties p) {
        return new LinkedHashMapProperties(p);
    }

    public static Properties newProperties(String name, Object value) {
        LinkedHashMapProperties p = new LinkedHashMapProperties(1);
        p.setProperty(name, value);
        return p;
    }

    public static Properties newProperties(String name, Object value, String name1, Object value1) {
        LinkedHashMapProperties p = new LinkedHashMapProperties(2);
        p.setProperty(name, value);
        p.setProperty(name1, value1);
        return p;
    }

    public static Properties newProperties(String name, Object value, String name1, Object value1, String name2, Object value2) {
        LinkedHashMapProperties p = new LinkedHashMapProperties(3);
        p.setProperty(name, value);
        p.setProperty(name1, value1);
        p.setProperty(name2, value2);
        return p;
    }

    public abstract int size();

    public abstract Property<?> atIndex(int var1);

    public abstract void reserve(int var1);

    public boolean equals(Object o) {
        if (!(o instanceof Properties)) {
            return false;
        }
        Properties p = (Properties)o;
        if (this.size() != p.size()) {
            return false;
        }
        for (Property prop : this) {
            Object value = p.get(prop.getName());
            if (Objects.deepEquals(value, prop.getValue())) continue;
            return false;
        }
        return true;
    }

    protected final int makeHash() {
        int hash = 5;
        for (Property prop : this) {
            hash ^= Property.makeHash(prop.getName(), prop.getValue());
        }
        return hash;
    }

    public int hashCode() {
        return this.makeHash();
    }

    public abstract Map<String, Object> toMap(Map<String, Object> var1, Set<String> var2, String ... var3);

    public Map<String, Object> toMap() {
        return this.toMap(null);
    }

    public Map<String, Object> toMap(Map<String, Object> props) {
        return this.toMap(props, null, new String[0]);
    }

    public Map<String, Object> toMap(Set<String> excludes, String ... excludePrefixes) {
        return this.toMap(new LinkedHashMap<String, Object>(), excludes, excludePrefixes);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public abstract boolean containsName(String var1);

    public boolean containsValue(Object value) {
        for (Property prop : this) {
            if (!Objects.deepEquals(prop.getValue(), value)) continue;
            return true;
        }
        return false;
    }

    public abstract Object remove(String var1);

    protected Object removeAt(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return this.remove(this.atIndex(index).getName());
    }

    public abstract void clear();

    public Property<?> selectSingle(PropertyMatcher matcher) {
        return matcher.matchProperties(this);
    }

    public String toString() {
        Integer[] indexes = new Integer[this.size()];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = i;
        }
        Arrays.sort(indexes, (v1, v2) -> this.atIndex((int)v1).getName().compareTo(this.atIndex((int)v2).getName()));
        StringBuilder sb = new StringBuilder("[");
        for (Integer i : indexes) {
            Property<?> p = this.atIndex(i);
            sb.append(p.toString()).append(", ");
        }
        sb.setLength(sb.length() == 1 ? 1 : sb.length() - 2);
        return sb.append("]").toString();
    }

    public abstract Object get(String var1);

    public <T> T get(String key, Class<T> clazz) {
        Object tmp = this.get(key);
        assert (tmp == null || clazz.isInstance(tmp)) : "Property value is of different class: " + tmp.getClass().getName();
        return clazz.cast(tmp);
    }

    public String getString(String key, String defValue) {
        Object val = this.get(key);
        return val == null ? defValue : Objects.toString(val);
    }

    public void setProperty(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Name can't be null.");
        }
        this.setPropertyInternal(name, value);
    }

    protected abstract void setPropertyInternal(String var1, Object var2);

    public void putAll(Map<String, ?> map) {
        this.addFrom(map.entrySet(), Map.Entry::getKey, Map.Entry::getValue);
    }

    public void add(Properties properties) {
        this.addFrom(properties, Property::getName, Property::getValue);
    }

    abstract <TSource extends Iterable<? extends TProp>, TProp> void addFrom(TSource var1, Function<? super TProp, String> var2, Function<? super TProp, ?> var3);

    public abstract <T> Iterable<Property<T>> typedIter(Class<T> var1);

    static class SharedProperties
    extends ArrayProperties {
        static final Properties EMPTY = new SharedProperties(new ArrayProperties());
        final int hashCode;

        SharedProperties(Properties p) {
            super(p.size());
            for (Property prop : p) {
                super.setPropertyInternal(prop.getName(), prop.getValue());
            }
            this.hashCode = this.makeHash();
        }

        @Override
        protected void setPropertyInternal(String name, Object value) {
            throw new UnsupportedOperationException("SharedProperties are immutable.");
        }

        @Override
        protected Object removeAt(int index) {
            throw new UnsupportedOperationException("SharedProperties are immutable.");
        }

        @Override
        public void add(Properties properties) {
            throw new UnsupportedOperationException("SharedProperties are immutable.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("SharedProperties are immutable.");
        }

        @Override
        public void putAll(Map<String, ?> m) {
            throw new UnsupportedOperationException("SharedProperties are immutable.");
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return super.equals(other);
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }
    }

    public static class LinkedHashMapProperties
    extends Properties {
        protected LinkedHashMap<String, Object> map;

        public LinkedHashMapProperties() {
            this(0);
        }

        public LinkedHashMapProperties(Properties p) {
            this(p.size());
            for (Property prop : p) {
                this.map.put(prop.getName(), prop.getValue());
            }
        }

        public LinkedHashMapProperties(int expectedSize) {
            this.map = new LinkedHashMap(expectedSize);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public Property<?> atIndex(int index) {
            if (index >= this.size() || index < 0) {
                throw new IndexOutOfBoundsException();
            }
            int i = 0;
            for (Map.Entry<String, Object> entry : this.map.entrySet()) {
                if (i == index) {
                    return new Property<Object>(entry.getKey(), entry.getValue());
                }
                ++i;
            }
            return null;
        }

        @Override
        public void reserve(int size) {
        }

        @Override
        public Map<String, Object> toMap(Map<String, Object> props, Set<String> excludeNames, String ... excludePrefixes) {
            Set<String> excludes = excludeNames;
            if (excludes == null) {
                excludes = Collections.emptySet();
            }
            if (excludes.isEmpty() && excludePrefixes.length == 0) {
                props.putAll(this.map);
            } else {
                block0: for (Map.Entry<String, Object> entry : this.map.entrySet()) {
                    String n = entry.getKey();
                    if (excludes.contains(n)) continue;
                    for (String p : excludePrefixes) {
                        if (n.startsWith(p)) continue block0;
                    }
                    props.put(entry.getKey(), entry.getValue());
                }
            }
            return props;
        }

        @Override
        public boolean containsName(String name) {
            return this.map.containsKey(name);
        }

        @Override
        public Object remove(String name) {
            return this.map.remove(name);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Object get(String name) {
            return this.map.get(name);
        }

        @Override
        protected void setPropertyInternal(String name, Object value) {
            this.map.put(name, value);
        }

        @Override
        <TSource extends Iterable<? extends TProp>, TProp> void addFrom(TSource source, Function<? super TProp, String> getNameFunc, Function<? super TProp, ?> getValueFunc) {
            for (TProp p : source) {
                String name = getNameFunc.apply(p);
                Object value = getValueFunc.apply(p);
                this.map.put(name, value);
            }
        }

        @Override
        public <T> Iterable<Property<T>> typedIter(Class<T> clazz) {
            if (clazz == null) {
                throw new IllegalArgumentException("Class<T> can't be null.");
            }
            return () -> this.map.entrySet().stream().filter(entry -> clazz.isInstance(entry.getValue())).map(entry -> new Property((String)entry.getKey(), clazz.cast(entry.getValue()))).iterator();
        }

        @Override
        public Iterator<Property<Object>> iterator() {
            return this.map.entrySet().stream().map(entry -> new Property((String)entry.getKey(), entry.getValue())).iterator();
        }
    }

    public static interface PropertyMatcher {
        public static final PropertyMatcher ALL = new PropertyMatcher(){

            @Override
            public String getName() {
                return "ALL";
            }

            @Override
            public boolean match(Object value) {
                return true;
            }

            @Override
            public Property<?> matchProperties(Properties p) {
                Iterator i = p.iterator();
                return i.hasNext() ? (Property)i.next() : null;
            }
        };

        public String getName();

        public boolean match(Object var1);

        default public Property<?> matchProperties(Properties p) {
            String name = this.getName();
            Object value = p.get(name);
            if (this.match(value)) {
                return new Property<Object>(name, value);
            }
            return null;
        }
    }

    public static class PropertySelector<T extends Provider> {
        private final Collection<T> objects;

        public PropertySelector(Collection<T> objects) {
            this.objects = objects;
        }

        public T selectSingle(PropertyMatcher matcher) {
            for (Provider t : this.objects) {
                Property<?> p = t.getProperties().selectSingle(matcher);
                if (p == null) continue;
                return (T)t;
            }
            return null;
        }

        public List<T> selectMultiple(PropertyMatcher matcher) {
            ArrayList<Provider> result = new ArrayList<Provider>();
            for (Provider t : this.objects) {
                Property<?> p = t.getProperties().selectSingle(matcher);
                if (p == null) continue;
                result.add(t);
            }
            return result;
        }
    }

    public static interface Provider {
        public Properties getProperties();
    }

    public static class RegexpPropertyMatcher
    implements PropertyMatcher {
        private final String name;
        private final Pattern valuePattern;
        private final boolean entireMatch;

        public RegexpPropertyMatcher(String name, String value) {
            this(name, value, true, 0);
        }

        public RegexpPropertyMatcher(String name, String value, boolean entireMatch, int flags) {
            if (name == null) {
                throw new IllegalArgumentException("Property name must not be null!");
            }
            if (value == null) {
                throw new IllegalArgumentException("Property value pattern must not be null!");
            }
            this.name = name;
            this.entireMatch = entireMatch;
            try {
                this.valuePattern = Pattern.compile(value, flags);
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Bad pattern: " + value);
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean match(Object p) {
            if (p == null) {
                return false;
            }
            String s = p.toString();
            Matcher m = this.valuePattern.matcher(s);
            return this.entireMatch ? m.matches() : m.find();
        }

        public String getRegexpValue() {
            return this.valuePattern.pattern();
        }
    }

    public static class EqualityPropertyMatcher
    implements PropertyMatcher {
        private final String name;
        private final Object value;

        public EqualityPropertyMatcher(String name, Object value) {
            if (name == null) {
                throw new IllegalArgumentException("Property name must not be null!");
            }
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean match(Object p) {
            return Objects.deepEquals(p, this.value);
        }
    }

    public static class InvertPropertyMatcher
    implements PropertyMatcher {
        private final PropertyMatcher matcher;

        public InvertPropertyMatcher(PropertyMatcher matcher) {
            this.matcher = matcher;
        }

        @Override
        public String getName() {
            return this.matcher.getName();
        }

        @Override
        public boolean match(Object p) {
            return !this.matcher.match(p);
        }
    }

    public static class Entity
    implements Provider {
        private Properties properties;

        public Entity() {
            this.properties = Properties.newProperties();
        }

        public Entity(Entity object) {
            this(object.getProperties());
        }

        public Entity(Properties newProperties) {
            this.properties = Properties.newProperties(newProperties);
        }

        @Override
        public synchronized Properties getProperties() {
            return this.properties;
        }

        public void internProperties() {
            this.properties = PropertyCache.intern(this.properties);
        }

        protected final void freezeProperties() {
            this.properties = new SharedProperties(this.properties);
        }

        public boolean isMutable() {
            return !(this.properties instanceof SharedProperties);
        }

        protected synchronized void replaceProperties(Properties props) {
            this.properties = props;
        }
    }

    public static interface MutableOwner<T>
    extends Provider {
        public ChangedEvent<T> getPropertyChangedEvent();

        public Properties writableProperties();

        public void updateProperties(Properties var1);
    }

    private static final class PropertyCache {
        static final WeakHashMap<Properties, WeakReference<SharedProperties>> immutableCache = new WeakHashMap();

        private PropertyCache() {
        }

        static synchronized SharedProperties intern(Properties properties) {
            SharedProperties props;
            WeakReference<SharedProperties> entry = immutableCache.get(properties);
            if (entry != null && (props = (SharedProperties)entry.get()) != null) {
                return props;
            }
            SharedProperties key = new SharedProperties(properties);
            immutableCache.put(key, new WeakReference<SharedProperties>(key));
            return key;
        }
    }

    public static class ArrayProperties
    extends Properties {
        protected String[] names;
        protected Object[] values;
        protected int size = 0;

        public ArrayProperties(int expectedSize) {
            this.names = new String[expectedSize];
            this.values = new Object[expectedSize];
        }

        public ArrayProperties() {
            this(0);
        }

        protected ArrayProperties(String[] names, Object[] values) {
            assert (values.length == names.length);
            this.values = values;
            this.names = names;
            this.size = names.length;
        }

        @Override
        public void reserve(int capacity) {
            if (capacity > this.names.length) {
                this.names = Arrays.copyOf(this.names, capacity);
                this.values = Arrays.copyOf(this.values, capacity);
            }
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean containsName(String name) {
            return this.getKeyIndex(name) != -1;
        }

        @Override
        public Object get(String name) {
            int i = this.getKeyIndex(name);
            return i == -1 ? null : this.values[i];
        }

        private int getKeyIndex(String name) {
            for (int i = 0; i < this.size; ++i) {
                if (!this.names[i].equals(name)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Map<String, Object> toMap(Map<String, Object> props, Set<String> excludeNames, String ... excludePrefixes) {
            Set<String> excludes = excludeNames;
            if (excludes == null) {
                excludes = Collections.emptySet();
            }
            if (excludes.isEmpty() && excludePrefixes.length == 0) {
                for (int i = 0; i < this.size; ++i) {
                    props.put(this.names[i], this.values[i]);
                }
            } else {
                block1: for (int i = 0; i < this.size; ++i) {
                    String n = this.names[i];
                    if (excludes.contains(n)) continue;
                    for (String p : excludePrefixes) {
                        if (n.startsWith(p)) continue block1;
                    }
                    props.put(this.names[i], this.values[i]);
                }
            }
            return props;
        }

        @Override
        public Object remove(String name) {
            return this.removeAt(this.getKeyIndex(name));
        }

        @Override
        protected Object removeAt(int index) {
            if (index < 0 || index >= this.size) {
                return null;
            }
            Object obj = this.values[index];
            Object[] newVals = new Object[this.size - 1];
            String[] newKeys = new String[this.size - 1];
            System.arraycopy(this.names, 0, newKeys, 0, index);
            System.arraycopy(this.values, 0, newVals, 0, index);
            int remIndex = index + 1;
            System.arraycopy(this.names, remIndex, newKeys, remIndex - 1, this.size - remIndex);
            System.arraycopy(this.values, remIndex, newVals, remIndex - 1, this.size - remIndex);
            this.names = newKeys;
            this.values = newVals;
            --this.size;
            return obj;
        }

        @Override
        public void clear() {
            this.values = new Object[0];
            this.names = new String[0];
            this.size = 0;
        }

        public Property<Object> atIndex(int index) {
            if (index >= this.size || index < 0) {
                throw new IndexOutOfBoundsException();
            }
            return new Property<Object>(this.names[index], this.values[index]);
        }

        @Override
        protected void setPropertyInternal(String name, Object value) {
            assert (name != null);
            int i = this.getKeyIndex(name);
            if (i != -1) {
                this.values[i] = value;
                return;
            }
            if (this.names.length == this.size) {
                this.names = Arrays.copyOf(this.names, this.size + 1);
                this.values = Arrays.copyOf(this.values, this.size + 1);
            }
            this.names[this.size] = name;
            this.values[this.size] = value;
            ++this.size;
        }

        @Override
        <TSource extends Iterable<? extends TProp>, TProp> void addFrom(TSource source, Function<? super TProp, String> getNameFunc, Function<? super TProp, ?> getValueFunc) {
            ArrayList<TProp> rest = new ArrayList<TProp>();
            for (Object p : source) {
                int index = this.getKeyIndex(getNameFunc.apply(p));
                if (index == -1) {
                    rest.add(p);
                    continue;
                }
                this.values[index] = getValueFunc.apply(p);
            }
            if (!rest.isEmpty()) {
                this.names = Arrays.copyOf(this.names, this.size + rest.size());
                this.values = Arrays.copyOf(this.values, this.size + rest.size());
                for (Object p : rest) {
                    this.names[this.size] = getNameFunc.apply(p);
                    this.values[this.size] = getValueFunc.apply(p);
                    ++this.size;
                }
            }
        }

        @Override
        public Iterator<Property<Object>> iterator() {
            return new ArrayPropertiesIterator();
        }

        @Override
        public <T> Iterable<Property<T>> typedIter(Class<T> clazz) {
            if (clazz == null) {
                throw new IllegalArgumentException("Class<T> can't be null.");
            }
            return () -> new ArrayPropertiesTypedIterator(clazz);
        }

        private final class ArrayPropertiesIterator
        implements Iterator<Property<Object>> {
            int index;

            private ArrayPropertiesIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.index < ArrayProperties.this.size();
            }

            @Override
            public Property<Object> next() {
                if (this.index < ArrayProperties.this.size()) {
                    ++this.index;
                    return ArrayProperties.this.atIndex(this.index - 1);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported.");
            }
        }

        private class ArrayPropertiesTypedIterator<T>
        implements Iterator<Property<T>> {
            int index;
            Class<T> clazz;

            ArrayPropertiesTypedIterator(Class<T> clazz) {
                this.clazz = clazz;
            }

            @Override
            public boolean hasNext() {
                while (this.index < ArrayProperties.this.size && !this.clazz.isInstance(ArrayProperties.this.values[this.index])) {
                    ++this.index;
                }
                return this.index < ArrayProperties.this.size;
            }

            @Override
            public Property<T> next() {
                if (this.hasNext()) {
                    ++this.index;
                    return new Property<T>(ArrayProperties.this.names[this.index - 1], this.clazz.cast(ArrayProperties.this.values[this.index - 1]));
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported.");
            }
        }
    }
}

