/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.data.serialization.lazy;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import jdk.graal.compiler.graphio.parsing.BinaryReader;
import jdk.graal.compiler.graphio.parsing.BinarySource;
import jdk.graal.compiler.graphio.parsing.model.ChangedEventProvider;
import jdk.graal.compiler.graphio.parsing.model.ChangedListener;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.Group;
import org.graalvm.visualizer.data.serialization.lazy.BaseCompleter;
import org.graalvm.visualizer.data.serialization.lazy.Env;
import org.graalvm.visualizer.data.serialization.lazy.LazyGroup;
import org.graalvm.visualizer.data.serialization.lazy.SingleGroupBuilder;
import org.graalvm.visualizer.data.serialization.lazy.StreamEntry;
import org.graalvm.visualizer.data.serialization.lazy.StreamIndex;

final class GroupCompleter
extends BaseCompleter<List<? extends FolderElement>, LazyGroup> {
    private final StreamIndex streamIndex;
    private boolean firstExpand = true;
    private volatile Reference<List<? extends FolderElement>> refData = new WeakReference<Object>(null);

    public GroupCompleter(Env env, StreamIndex index, StreamEntry groupEntry) {
        super(env, groupEntry);
        this.streamIndex = index;
    }

    public void removeData(FolderElement fe) {
        List<? extends FolderElement> d = this.refData.get();
        if (d != null) {
            d.remove(fe);
        }
    }

    @Override
    protected List<? extends FolderElement> createEmpty() {
        return new ArrayList();
    }

    @Override
    protected List<? extends FolderElement> filter(List<? extends FolderElement> data) {
        Set<String> names = ((LazyGroup)this.getModel()).getExcludedNames();
        if (names.isEmpty()) {
            return data;
        }
        Iterator<? extends FolderElement> it = data.iterator();
        while (it.hasNext()) {
            FolderElement el = it.next();
            if (!names.contains(el.getName())) continue;
            it.remove();
        }
        return data;
    }

    @Override
    protected List<? extends FolderElement> hookData(List<? extends FolderElement> data) {
        final Future keepalive = this.future();
        ChangedListener l = keepalive instanceof ChangedListener ? (ChangedListener)((Object)keepalive) : new ChangedListener(){
            final Object dataHook;
            {
                this.dataHook = keepalive;
            }

            public void changed(Object source) {
            }
        };
        if (data != null) {
            for (FolderElement folderElement : data) {
                if (!(folderElement instanceof ChangedEventProvider)) continue;
                ((ChangedEventProvider)((Object)folderElement)).getChangedEvent().addListener(l);
            }
        }
        this.refData = new WeakReference<List<? extends FolderElement>>(data);
        return data;
    }

    @Override
    protected void setPartialData(List<? extends FolderElement> partialData) {
        super.setPartialData(partialData);
        ((LazyGroup)this.toComplete).dataReceived();
    }

    @Override
    protected List<? extends FolderElement> load(ReadableByteChannel channel, int majorVersion, int minorVersion, Group.Feedback feedback) throws IOException {
        BinarySource bs = new BinarySource(channel, majorVersion, minorVersion, this.entry.getStart());
        SingleGroupBuilder builder = new SingleGroupBuilder((Group)((Object)this.toComplete), this.env(), bs, this.streamIndex, this.entry, feedback, this.firstExpand, this::setPartialData);
        this.firstExpand = false;
        new BinaryReader(bs, builder).parse();
        List<? extends FolderElement> els = builder.getItems();
        return els;
    }
}

