/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.data.serialization.lazy;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import jdk.graal.compiler.graphio.parsing.model.ChangedEvent;
import jdk.graal.compiler.graphio.parsing.model.ChangedEventProvider;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.graalvm.visualizer.data.serialization.lazy.Completer;
import org.graalvm.visualizer.data.serialization.lazy.GraphCompleter;
import org.graalvm.visualizer.data.serialization.lazy.GraphMetadata;
import org.graalvm.visualizer.data.serialization.lazy.LoadSupport;
import org.graalvm.visualizer.data.serialization.lazy.StreamEntry;

class LazyGraph
extends InputGraph
implements Group.LazyContent<Collection<InputNode>>,
ChangedEventProvider<InputGraph> {
    private final ChangedEvent<InputGraph> changedEvent = new ChangedEvent<LazyGraph>(this);
    private final LoadSupport<InputGraph.GraphData> cSupport;
    private final GraphMetadata meta;

    public LazyGraph(StreamEntry entry, GraphMetadata meta, Completer<InputGraph.GraphData> completer, int dumpId, String format, Object[] args) {
        super(entry, dumpId, format, args);
        this.cSupport = new LoadSupport<InputGraph.GraphData>(completer);
        this.meta = meta;
        this.cSupport.setName(this.getName());
    }

    @Override
    protected InputGraph.GraphData data() {
        return this.cSupport.getContents();
    }

    @Override
    public Collection<InputNode> partialData() {
        return new ArrayList<InputNode>();
    }

    @Override
    public ChangedEvent<InputGraph> getChangedEvent() {
        return this.changedEvent;
    }

    @Override
    public boolean isComplete() {
        return this.cSupport.isComplete();
    }

    @Override
    public int getEdgeCount() {
        return this.meta.getEdgeCount();
    }

    @Override
    public int getNodeCount() {
        return this.meta.getNodeCount();
    }

    @Override
    public int getHighestNodeId() {
        return this.meta.getHighestNodeId();
    }

    @Override
    public Future<Collection<InputNode>> completeContents(Group.Feedback feedback) {
        return new F(this.cSupport.completeContents(feedback));
    }

    @Override
    public boolean isDuplicate() {
        return this.meta.isDuplicate();
    }

    @Override
    public Set<Integer> getNodeIds() {
        return new IdSet();
    }

    @Override
    public String toString() {
        if (this.isComplete()) {
            return super.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Graph ").append(this.getName()).append(" ").append(this.getProperties().toString()).append("\n");
        sb.append("<incomplete>");
        return sb.toString();
    }

    @Override
    public boolean containsNode(int id) {
        return this.meta.nodeIds.get(id);
    }

    @Override
    public boolean isNodeChanged(int nodeId) {
        return this.meta.changedNodeIds.get(nodeId);
    }

    static StreamEntry lazyGraphEntry(LazyGraph g) {
        return ((GraphCompleter)g.cSupport.completer).entry;
    }

    private final class F
    implements Future<Collection<InputNode>> {
        private final Future<InputGraph.GraphData> delegate;

        public F(Future<InputGraph.GraphData> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.delegate.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.delegate.isDone();
        }

        @Override
        public Collection<InputNode> get() throws InterruptedException, ExecutionException {
            return this.delegate.get().getNodes();
        }

        @Override
        public Collection<InputNode> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.delegate.get(timeout, unit).getNodes();
        }
    }

    private class IdSet
    implements Set<Integer> {
        @Override
        public int size() {
            return LazyGraph.this.meta.getNodeCount();
        }

        @Override
        public boolean isEmpty() {
            return LazyGraph.this.meta.getNodeIds().isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            assert (o instanceof Integer);
            return LazyGraph.this.meta.getNodeIds().get((Integer)o);
        }

        @Override
        public Iterator<Integer> iterator() {
            return new It(LazyGraph.this.meta.getNodeIds());
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Integer[this.size()]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            BitSet ids = LazyGraph.this.meta.getNodeIds();
            int sz = this.size();
            Integer[] arr = a != null && a.length >= sz ? (Integer[])a : new Integer[this.size()];
            int pos = 0;
            int v = 0;
            while (pos < sz && (v = ids.nextSetBit(v)) != -1) {
                arr[pos++] = v;
                ++v;
            }
            return arr;
        }

        @Override
        public boolean add(Integer e) {
            throw new UnsupportedOperationException("Readonly set");
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Readonly set");
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Integer u : c) {
                if (LazyGraph.this.meta.getNodeIds().get(u)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Integer> c) {
            throw new UnsupportedOperationException("Readonly set");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("Readonly set");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("Readonly set");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Readonly set");
        }
    }

    static final class It
    implements Iterator<Integer> {
        private final BitSet set;
        private int index;

        public It(BitSet set) {
            this.set = set;
            this.index = set.nextSetBit(0);
        }

        @Override
        public boolean hasNext() {
            return this.index != -1;
        }

        @Override
        public Integer next() {
            if (this.index == -1) {
                throw new NoSuchElementException();
            }
            int n = this.index;
            this.index = this.set.nextSetBit(this.index + 1);
            return n;
        }
    }
}

