/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.data.serialization.lazy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import jdk.graal.compiler.graphio.parsing.model.ChangedEventProvider;
import jdk.graal.compiler.graphio.parsing.model.Folder;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;

public final class ReaderErrors {
    private static final ReaderErrors INSTANCE = new ReaderErrors();
    private static final Map<FolderElement, ElementData> errorList = new WeakHashMap<FolderElement, ElementData>();

    private static List<String> pathFromRoot(FolderElement el, List storage) {
        if (el == null) {
            return storage;
        }
        Folder parent = el.getParent();
        List<String> ret = ReaderErrors.pathFromRoot(parent, storage);
        ret.add(el.getName());
        return ret;
    }

    static void addError(Object el, Folder folder, String error) {
        if (el instanceof FolderElement) {
            ReaderErrors.addError((FolderElement)el, folder, error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addError(FolderElement el, Folder folder, String error) {
        Folder f;
        Map<FolderElement, ElementData> map = errorList;
        synchronized (map) {
            ElementData data = errorList.computeIfAbsent(el, e -> {
                ElementData ne = new ElementData((FolderElement)e, folder);
                if (e instanceof InputGraph) {
                    Folder f = el.getParent();
                    if (f == null) {
                        f = folder;
                    }
                    if (f != null) {
                        Folder fe = f;
                        ElementData fed = errorList.computeIfAbsent(fe, e2 -> new ElementData(fe, null));
                        fed.addGraphError(ne);
                    }
                }
                return ne;
            });
            data.addError(error);
        }
        if (el instanceof ChangedEventProvider) {
            ((ChangedEventProvider)((Object)el)).getChangedEvent().fire();
        }
        Folder folder2 = f = el.getParent() == null ? folder : el.getParent();
        if (f instanceof ChangedEventProvider) {
            ((ChangedEventProvider)((Object)f)).getChangedEvent().fire();
        } else {
            GraphDocument doc = el.getOwner();
            if (doc == null) {
                doc = folder.getOwner();
            }
            if (doc != null) {
                doc.getChangedEvent().fire();
            }
        }
    }

    public static boolean containsError(FolderElement fe, boolean childrenToo) {
        ElementData ed = errorList.get(fe);
        return ed != null && (!ed.messages.isEmpty() || childrenToo && ed.graphErrors != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getReaderErrors(FolderElement fe, boolean childrenToo) {
        Map<FolderElement, ElementData> map = errorList;
        synchronized (map) {
            ElementData e = errorList.get(fe);
            if (e == null) {
                return Collections.emptyList();
            }
            ArrayList<String> msg = new ArrayList<String>(e.messages);
            if (childrenToo && e.graphErrors != null) {
                for (ElementData nested : e.graphErrors.values()) {
                    msg.addAll(nested.messages);
                }
            }
            return msg;
        }
    }

    static class ElementData {
        final List<String> messages = new ArrayList<String>(2);
        final List<String> pathFromRoot;
        Map<String, ElementData> graphErrors;

        public ElementData(FolderElement el, Folder folder) {
            this.pathFromRoot = ReaderErrors.pathFromRoot(el, new ArrayList());
        }

        void addGraphError(ElementData e) {
            if (this.graphErrors == null) {
                this.graphErrors = new HashMap<String, ElementData>();
            } else {
                int i = e.pathFromRoot.size();
                this.graphErrors.put(e.pathFromRoot.get(i - 1), e);
            }
        }

        void addError(String s) {
            this.messages.add(s);
        }
    }
}

