/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.data.serialization.lazy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.graal.compiler.graphio.parsing.BinaryReader;
import jdk.graal.compiler.graphio.parsing.BinarySource;
import jdk.graal.compiler.graphio.parsing.Builder;
import jdk.graal.compiler.graphio.parsing.ConstantPool;
import jdk.graal.compiler.graphio.parsing.ModelBuilder;
import jdk.graal.compiler.graphio.parsing.NameTranslator;
import jdk.graal.compiler.graphio.parsing.ParseMonitor;
import jdk.graal.compiler.graphio.parsing.SkipRootException;
import jdk.graal.compiler.graphio.parsing.model.Folder;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputBlock;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.data.serialization.lazy.DelegatingBuilder;
import org.graalvm.visualizer.data.serialization.lazy.Env;
import org.graalvm.visualizer.data.serialization.lazy.GraphBuilder;
import org.graalvm.visualizer.data.serialization.lazy.GraphCompleter;
import org.graalvm.visualizer.data.serialization.lazy.GraphMetadata;
import org.graalvm.visualizer.data.serialization.lazy.GroupCompleter;
import org.graalvm.visualizer.data.serialization.lazy.LazyGraph;
import org.graalvm.visualizer.data.serialization.lazy.LazyGroup;
import org.graalvm.visualizer.data.serialization.lazy.LazyModelBuilder;
import org.graalvm.visualizer.data.serialization.lazy.ParseMonitorBridge;
import org.graalvm.visualizer.data.serialization.lazy.StreamEntry;
import org.graalvm.visualizer.data.serialization.lazy.StreamIndex;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;

public class SingleGroupBuilder
extends DelegatingBuilder {
    private static final Logger LOG = Logger.getLogger(SingleGroupBuilder.class.getName());
    private static int largeGraphThreshold = StreamEntry.LARGE_ENTRY_THRESHOLD;
    private final List<FolderElement> items = new ArrayList<FolderElement>();
    private final Group toComplete;
    private ConstantPool pool;
    private final Env env;
    private final GraphDocument rootDocument;
    private final StreamIndex streamIndex;
    private final BinarySource dataSource;
    private final long startOffset;
    private final boolean firstExpand;
    private final Root rootBuilder;
    private final StreamEntry rootEntry;
    private final Group.Feedback feedback;
    private GroupCompleter completer;
    private GraphMetadata gInfo;
    private long rootStartOffset;
    private int graphIndex = -1;
    private int graphLevel;
    private int groupLevel;
    private ModelBuilder rootGraphBuilder;
    private Map<Integer, Properties> nodeProperties = new HashMap<Integer, Properties>();
    private final Map<Integer, List<ModelBuilder.EdgeInfo>> nodeEdges = new HashMap<Integer, List<ModelBuilder.EdgeInfo>>();
    private Map<String, byte[]> lastDigests = new HashMap<String, byte[]>();
    private Map<String, Map<Integer, Properties>> lastTypeProperties = new HashMap<String, Map<Integer, Properties>>();
    private final Deque<NestedData> levels = new LinkedList<NestedData>();
    private boolean collectCounts;
    private boolean collectChanges;
    private StreamEntry entry;
    private final Consumer<List<? extends FolderElement>> partialCallback;
    private final Logger instLog;

    private void registerNodeEdges(int nodeId, List<ModelBuilder.EdgeInfo> props) {
        List<ModelBuilder.EdgeInfo> oldProps = this.nodeEdges.get(nodeId);
        if (oldProps != null && !oldProps.equals(props)) {
            this.gInfo.nodeChanged(nodeId);
        }
        this.nodeEdges.put(nodeId, props);
    }

    public SingleGroupBuilder(Group toComplete, Env env, BinarySource dataSource, StreamIndex streamIndex, StreamEntry entry, Group.Feedback feedback, boolean firstExpand, Consumer<List<? extends FolderElement>> partialCallback) {
        this.env = env;
        this.toComplete = toComplete;
        this.pool = entry.getInitialPool().copy();
        this.rootDocument = new GraphDocument();
        this.streamIndex = streamIndex;
        this.dataSource = dataSource;
        this.startOffset = entry.getStart();
        this.firstExpand = firstExpand;
        this.feedback = feedback;
        this.rootEntry = entry;
        this.partialCallback = partialCallback;
        this.entry = this.rootEntry;
        this.instLog = Logger.getLogger(LOG.getName() + "." + Integer.toHexString(System.identityHashCode(this)));
        this.instLog.log(Level.FINE, "Reading group {0}, entry {1}, dataSource {2}", new Object[]{toComplete.getName(), entry, dataSource});
        this.rootBuilder = new Root();
        this.delegateTo(this.rootBuilder);
    }

    static void setLargeEntryThreshold(int size) {
        largeGraphThreshold = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends FolderElement> getItems() {
        List<FolderElement> list = this.items;
        synchronized (list) {
            return new ArrayList<FolderElement>(this.items);
        }
    }

    @Override
    public void endGroup() {
        super.endGroup();
        this.levels.pop().restore();
        --this.groupLevel;
    }

    @Override
    @CheckForNull
    public Group startGroup() {
        this.levels.push(new NestedData());
        ++this.groupLevel;
        return super.startGroup();
    }

    @Override
    public void graphContentDigest(byte[] digest) {
        byte[] prevDigest;
        InputGraph g = this.rootGraphBuilder == null ? null : this.rootGraphBuilder.graph();
        if (g == null) {
            return;
        }
        String t = g.getGraphType();
        if (t == null) {
            t = "";
        }
        if (Arrays.equals(prevDigest = this.lastDigests.put(t, digest), digest)) {
            this.markGraphDuplicate();
        }
    }

    boolean isRootChildGraph() {
        return this.groupLevel == 1 && this.graphLevel == 1;
    }

    @Override
    public void startGraphContents(InputGraph g) {
        if (g == null) {
            super.startGraphContents(g);
            return;
        }
        super.startGraphContents(g);
        this.nodeProperties = this.lastTypeProperties.computeIfAbsent(g.getGraphType(), gt -> new HashMap());
    }

    @Override
    @CheckForNull
    public InputGraph startGraph(int dumpId, String format, Object[] args) {
        ++this.graphIndex;
        this.levels.push(new NestedData());
        ++this.graphLevel;
        return super.startGraph(dumpId, format, args);
    }

    private void registerNodeProperties(int nodeId, Properties props) {
        Properties oldProps = this.nodeProperties.get(nodeId);
        if (oldProps != null && !oldProps.equals(props)) {
            this.gInfo.nodeChanged(nodeId);
        }
        this.nodeProperties.put(nodeId, props);
    }

    @Override
    @CheckForNull
    public InputGraph endGraph() {
        if (this.instLog.isLoggable(Level.FINE)) {
            if (this.entry == null) {
                this.instLog.log(Level.FINE, "endSubGraph, level = {0}", this.graphLevel);
            } else {
                this.instLog.log(Level.FINE, "endGraph, range = {0}-{1}", new Object[]{this.entry.getStart(), this.entry.getEnd()});
            }
        }
        switch (this.graphLevel) {
            case 1: {
                this.instLog.log(Level.FINER, "Switch to root builder");
                this.delegateTo(this.rootBuilder);
                break;
            }
            case 2: {
                this.instLog.log(Level.FINER, "Switch to lazy builder");
                this.delegateTo(this.rootGraphBuilder);
            }
        }
        this.levels.pop().restore();
        --this.graphLevel;
        return super.endGraph();
    }

    @Override
    public void startRoot() {
        this.rootStartOffset = this.dataSource.getMark();
        this.streamIndex.waitOffset(this.rootStartOffset);
        long end = this.rootEntry.getEnd();
        if (end > -1L && this.rootStartOffset > end) {
            this.instLog.log(Level.FINER, "Encountered root after rootEntry {0} at {1}, skip rest of stream", new Object[]{this.rootEntry, this.rootStartOffset});
            throw new SkipRootException(this.entry.getStart(), -1L, null);
        }
        super.startRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitEntryFinished() {
        StreamEntry streamEntry = this.entry;
        synchronized (streamEntry) {
            while (!this.entry.isFinished()) {
                try {
                    this.instLog.log(Level.FINER, "Waiting for entry {0}", this.entry);
                    this.entry.beforeWait();
                    this.entry.wait();
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(SingleGroupBuilder.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    class Root
    extends LazyModelBuilder {
        private final Properties trash;

        public Root() {
            super(SingleGroupBuilder.this.rootDocument, (ParseMonitor)new ParseMonitorBridge(SingleGroupBuilder.this.entry, SingleGroupBuilder.this.feedback, SingleGroupBuilder.this.dataSource));
            this.trash = new Properties.ArrayProperties();
        }

        @Override
        public ParseMonitor getMonitor() {
            return super.getMonitor();
        }

        @Override
        public void startRoot() {
            super.startRoot();
        }

        @Override
        public void startGroupContent() {
            if (SingleGroupBuilder.this.groupLevel > 1) {
                SingleGroupBuilder.this.instLog.log(Level.FINE, "Starting group {0}, ", this.folder().getName());
            }
            super.startGroupContent();
            if (SingleGroupBuilder.this.groupLevel > 1 && this.folder() instanceof LazyGroup) {
                this.skipRoot();
            }
        }

        @Override
        protected Properties getProperties() {
            if (this.getEntity() == SingleGroupBuilder.this.toComplete) {
                return this.trash;
            }
            return super.getProperties();
        }

        @Override
        protected Group createGroup(Folder parent) {
            GroupCompleter grc;
            if (parent == SingleGroupBuilder.this.rootDocument) {
                SingleGroupBuilder.this.entry = SingleGroupBuilder.this.rootEntry;
                return SingleGroupBuilder.this.toComplete;
            }
            SingleGroupBuilder.this.entry = SingleGroupBuilder.this.streamIndex.get(SingleGroupBuilder.this.rootStartOffset);
            SingleGroupBuilder.this.instLog.log(Level.FINER, "Create group entry {0}", SingleGroupBuilder.this.entry);
            if (SingleGroupBuilder.this.entry.size() < (long)largeGraphThreshold) {
                return super.createGroup(parent);
            }
            assert (SingleGroupBuilder.this.completer == null);
            SingleGroupBuilder.this.completer = grc = new GroupCompleter(SingleGroupBuilder.this.env, SingleGroupBuilder.this.streamIndex, SingleGroupBuilder.this.entry);
            LazyGroup g = new LazyGroup(this.folder(), grc, SingleGroupBuilder.this.entry);
            SingleGroupBuilder.this.completer.attachTo(g, null);
            return g;
        }

        @Override
        public void endGroup() {
            SingleGroupBuilder.this.waitEntryFinished();
            super.endGroup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void registerToParent(Folder parent, FolderElement item) {
            if (item == SingleGroupBuilder.this.toComplete) {
                return;
            }
            if (parent == SingleGroupBuilder.this.toComplete) {
                item.setParent(parent);
                List<FolderElement> list = SingleGroupBuilder.this.items;
                synchronized (list) {
                    SingleGroupBuilder.this.items.add(item);
                }
                if (SingleGroupBuilder.this.partialCallback != null) {
                    SingleGroupBuilder.this.partialCallback.accept(SingleGroupBuilder.this.getItems());
                }
            } else {
                parent.addElement(item);
            }
        }

        @Override
        protected InputGraph createGraph(Properties.Entity parent, int dumpId, String format, Object[] args) {
            if (SingleGroupBuilder.this.rootEntry.size() < (long)largeGraphThreshold && (SingleGroupBuilder.this.entry == null || SingleGroupBuilder.this.entry.size() < (long)largeGraphThreshold)) {
                LazyGroup.LoadedGraph g = new LazyGroup.LoadedGraph(SingleGroupBuilder.this.rootEntry, SingleGroupBuilder.this.graphLevel == 1 ? SingleGroupBuilder.this.gInfo : null, dumpId, format, args);
                SingleGroupBuilder.this.instLog.log(Level.FINE, "Create full graph {0}, entry {1}", new Object[]{g.getName(), SingleGroupBuilder.this.entry});
                SingleGroupBuilder.this.rootGraphBuilder = new FullGraphBuilder(this.node(), g, this.folder());
                SingleGroupBuilder.this.delegateTo(SingleGroupBuilder.this.rootGraphBuilder);
                return g;
            }
            GraphCompleter completer = new GraphCompleter(SingleGroupBuilder.this.env, SingleGroupBuilder.this.entry);
            LazyGraph g = new LazyGraph(SingleGroupBuilder.this.entry, SingleGroupBuilder.this.gInfo, completer, dumpId, format, args);
            completer.attachTo(g, g.getName());
            SingleGroupBuilder.this.instLog.log(Level.FINE, "Create lazy graph {0}, positions {1}-{2}", new Object[]{g.getName(), SingleGroupBuilder.this.entry.getStart(), SingleGroupBuilder.this.entry.getEnd()});
            ChildGraphBuilder gb = new ChildGraphBuilder(g, this.folder());
            SingleGroupBuilder.this.rootGraphBuilder = gb;
            SingleGroupBuilder.this.delegateTo(gb);
            return g;
        }

        @Override
        public void startGraphContents(InputGraph g) {
            if (SingleGroupBuilder.this.graphLevel == 1 && !SingleGroupBuilder.this.collectChanges && !(g instanceof LazyGroup.LoadedGraph)) {
                this.skipRoot();
            }
            super.startGraphContents(g);
        }

        @Override
        @CheckForNull
        public InputGraph startGraph(int dumpId, String format, Object[] args) {
            long pos = SingleGroupBuilder.this.rootStartOffset;
            SingleGroupBuilder.this.entry = SingleGroupBuilder.this.streamIndex.get(pos);
            SingleGroupBuilder.this.instLog.log(Level.FINER, "Start contents graph entry {0}", SingleGroupBuilder.this.entry);
            SingleGroupBuilder.this.waitEntryFinished();
            if (SingleGroupBuilder.this.entry.size() > 0x100000L) {
                this.reportState(ModelBuilder.makeGraphName(dumpId, format, args));
            }
            SingleGroupBuilder.this.gInfo = SingleGroupBuilder.this.entry.getGraphMeta();
            SingleGroupBuilder.this.collectCounts = false;
            SingleGroupBuilder.this.collectChanges = SingleGroupBuilder.this.firstExpand;
            return super.startGraph(dumpId, format, args);
        }

        @Override
        @CheckForNull
        public InputGraph endGraph() {
            InputGraph g = this.graph();
            if (g instanceof LazyGraph) {
                this.popContext();
                this.registerToParent(this.folder(), g);
            } else {
                g = super.endGraph();
            }
            SingleGroupBuilder.this.rootGraphBuilder = null;
            return g;
        }

        @Override
        protected void replacePool(ConstantPool newPool) {
            SingleGroupBuilder.this.pool = newPool;
            super.replacePool(newPool);
        }

        @Override
        @NonNull
        public ConstantPool getConstantPool() {
            return SingleGroupBuilder.this.pool;
        }

        @Override
        public void markGraphDuplicate() {
            SingleGroupBuilder.this.gInfo.markDuplicate();
        }

        @Override
        public void makeBlockEdges() {
            super.makeBlockEdges();
            if (SingleGroupBuilder.this.collectChanges) {
                InputGraph g = this.graph();
                assert (!(g instanceof Group.LazyContent));
                for (InputNode n : g.getNodes()) {
                    int nodeId = n.getId();
                    SingleGroupBuilder.this.gInfo.addNode(nodeId);
                    SingleGroupBuilder.this.registerNodeProperties(nodeId, n.getProperties());
                }
            }
        }

        private void skipRoot() {
            SingleGroupBuilder.this.waitEntryFinished();
            ConstantPool nextPool = SingleGroupBuilder.this.entry.getSkipPool().copy();
            this.replacePool(nextPool);
            SingleGroupBuilder.this.instLog.log(Level.FINER, "Skipping entry {0}, restart from pool {1}", new Object[]{SingleGroupBuilder.this.entry, Integer.toHexString(System.identityHashCode(nextPool))});
            throw new SkipRootException(SingleGroupBuilder.this.entry.getStart(), SingleGroupBuilder.this.entry.getEnd(), nextPool);
        }
    }

    class NestedData {
        Map<Integer, Properties> props;
        Map<String, Map<Integer, Properties>> typeProps;
        Map<String, byte[]> dgs;
        GraphMetadata meta;
        StreamEntry e;
        GroupCompleter c;
        boolean changes;
        boolean counts;
        int gIndex;

        public NestedData() {
            this.props = SingleGroupBuilder.this.nodeProperties;
            this.typeProps = SingleGroupBuilder.this.lastTypeProperties;
            this.meta = SingleGroupBuilder.this.gInfo;
            this.e = SingleGroupBuilder.this.entry;
            this.changes = SingleGroupBuilder.this.collectChanges;
            this.counts = SingleGroupBuilder.this.collectCounts;
            this.gIndex = SingleGroupBuilder.this.graphIndex;
            this.c = SingleGroupBuilder.this.completer;
            this.dgs = SingleGroupBuilder.this.lastDigests;
            if (SingleGroupBuilder.this.graphLevel > 1) {
                SingleGroupBuilder.this.nodeProperties = new HashMap<Integer, Properties>();
                SingleGroupBuilder.this.lastTypeProperties = new HashMap<String, Map<Integer, Properties>>();
                SingleGroupBuilder.this.lastDigests = new HashMap<String, byte[]>();
            }
            SingleGroupBuilder.this.gInfo = null;
            SingleGroupBuilder.this.entry = null;
            SingleGroupBuilder.this.completer = null;
        }

        void restore() {
            SingleGroupBuilder.this.lastDigests = this.dgs;
            SingleGroupBuilder.this.completer = this.c;
            SingleGroupBuilder.this.nodeProperties = this.props;
            SingleGroupBuilder.this.lastTypeProperties = this.typeProps;
            SingleGroupBuilder.this.gInfo = this.meta;
            SingleGroupBuilder.this.entry = this.e;
            SingleGroupBuilder.this.collectChanges = this.changes;
            SingleGroupBuilder.this.collectCounts = this.counts;
            SingleGroupBuilder.this.graphIndex = this.gIndex;
        }
    }

    static class Ignore
    implements Builder {
        final ModelBuilder delegate;
        ConstantPool pool;
        final GraphDocument rootDocument;

        public Ignore(GraphDocument rootDocument, ModelBuilder delegate) {
            this.rootDocument = rootDocument;
            this.delegate = delegate;
        }

        @Override
        public void startDocumentHeader() {
        }

        @Override
        public void endDocumentHeader() {
        }

        @Override
        public void graphContentDigest(byte[] dg) {
        }

        @Override
        public void addBlockEdge(int from, int to) {
        }

        @Override
        public void addNodeToBlock(int nodeId) {
        }

        @Override
        public void end() {
        }

        @Override
        public void endBlock(int id) {
        }

        @Override
        public InputGraph endGraph() {
            return null;
        }

        @Override
        public void endGroup() {
        }

        @Override
        public void endNode(int nodeId) {
        }

        @Override
        @NonNull
        public ConstantPool getConstantPool() {
            return this.pool;
        }

        @Override
        @CheckForNull
        public Properties getNodeProperties(int nodeId) {
            return null;
        }

        @Override
        public void setPropertySize(int size) {
        }

        @Override
        public void inputEdge(Builder.Port p, int from, int to, char num, int index) {
        }

        @Override
        public void makeBlockEdges() {
        }

        @Override
        public void makeGraphEdges() {
        }

        @Override
        public void markGraphDuplicate() {
        }

        @Override
        public void resetStreamData() {
        }

        @Override
        public GraphDocument rootDocument() {
            return this.rootDocument;
        }

        @Override
        public void setGroupName(String name, String shortName) {
        }

        @Override
        public void setMethod(String name, String shortName, int bci, BinaryReader.Method method) {
        }

        @Override
        public void setNodeName(Builder.NodeClass nodeClass) {
        }

        @Override
        public void setNodeProperty(String key, Object value) {
        }

        @Override
        public void setProperty(String key, Object value) {
        }

        @Override
        public void start() {
        }

        @Override
        @CheckForNull
        public InputBlock startBlock(int id) {
            return null;
        }

        @Override
        @CheckForNull
        public InputBlock startBlock(String name) {
            return null;
        }

        @Override
        @CheckForNull
        public InputGraph startGraph(int dumpId, String format, Object[] args) {
            return null;
        }

        @Override
        public void startGraphContents(InputGraph g) {
        }

        @Override
        @CheckForNull
        public Group startGroup() {
            return null;
        }

        @Override
        public void startGroupContent() {
        }

        @Override
        public void startNestedProperty(String propertyKey) {
        }

        @Override
        public void startNode(int nodeId, boolean hasPredecessors, Builder.NodeClass nodeClass) {
        }

        @Override
        public void startRoot() {
        }

        @Override
        public void successorEdge(Builder.Port p, int from, int to, char num, int index) {
        }

        @Override
        public void setModelControl(Builder.ModelControl exchg) {
            this.pool = exchg.getConstantPool();
        }

        @Override
        public NameTranslator prepareNameTranslator() {
            return null;
        }

        @Override
        public void reportLoadingError(String logMessage, List<String> parentNames) {
            if (this.delegate != null) {
                this.delegate.reportLoadingError(logMessage, parentNames);
            }
        }
    }

    class ChildGraphBuilder
    extends LazyModelBuilder {
        private InputGraph nested;
        private final LazyGraph g;
        private final Map<Integer, Properties> stageProperties;
        private String blockName;
        private List<InputGraph> nestedStack;

        public ChildGraphBuilder(LazyGraph g, Folder folder) {
            super(SingleGroupBuilder.this.rootDocument, SingleGroupBuilder.this.rootBuilder.getMonitor());
            this.stageProperties = new HashMap<Integer, Properties>();
            this.g = g;
            this.pushGroup(SingleGroupBuilder.this.toComplete, false);
            if (folder instanceof Group) {
                this.pushGroup((Group)folder, false);
            }
            this.pushGraph(g);
            this.replacePool(SingleGroupBuilder.this.getConstantPool());
        }

        @Override
        @CheckForNull
        public Properties getNodeProperties(int nodeId) {
            return this.stageProperties.get(nodeId);
        }

        @Override
        protected void registerToParent(InputGraph g, InputNode n) {
            this.stageProperties.put(n.getId(), n.getProperties());
        }

        @Override
        public void addNodeToBlock(int nodeId) {
            this.updateNodeBlock(nodeId, this.blockName);
        }

        @Override
        public void addBlockEdge(int from, int to) {
        }

        @Override
        public void startRoot() {
            throw new IllegalStateException();
        }

        @Override
        protected void replacePool(ConstantPool newPool) {
            SingleGroupBuilder.this.pool = newPool;
            super.replacePool(newPool);
        }

        @Override
        @NonNull
        public ConstantPool getConstantPool() {
            return SingleGroupBuilder.this.pool;
        }

        @Override
        @CheckForNull
        public Group startGroup() {
            throw new IllegalStateException("Unexpected group inside graph");
        }

        @Override
        public void makeBlockEdges() {
            if (SingleGroupBuilder.this.collectChanges) {
                ArrayList edges;
                for (Map.Entry<Integer, Properties> en : this.stageProperties.entrySet()) {
                    int nodeId = en.getKey();
                    Properties props = en.getValue();
                    SingleGroupBuilder.this.registerNodeProperties(nodeId, props);
                }
                HashMap<Integer, ArrayList<ModelBuilder.EdgeInfo>> newNodeEdges = new HashMap<Integer, ArrayList<ModelBuilder.EdgeInfo>>();
                if (this.getInputEdges() != null) {
                    for (ModelBuilder.EdgeInfo edge : this.getInputEdges()) {
                        edges = (ArrayList)newNodeEdges.get(edge.getFrom());
                        if (edges == null) {
                            edges = new ArrayList();
                            newNodeEdges.put(edge.getFrom(), edges);
                        }
                        edges.add(edge);
                    }
                }
                if (this.getSuccessorEdges() != null) {
                    for (ModelBuilder.EdgeInfo edge : this.getSuccessorEdges()) {
                        edges = (ArrayList)newNodeEdges.get(edge.getFrom());
                        if (edges == null) {
                            edges = new ArrayList();
                            newNodeEdges.put(edge.getFrom(), edges);
                        }
                        edges.add(edge);
                    }
                }
                for (Integer nodeId : SingleGroupBuilder.this.nodeProperties.keySet()) {
                    edges = (ArrayList)newNodeEdges.get(nodeId);
                    SingleGroupBuilder.this.registerNodeEdges(nodeId, edges);
                }
            }
        }

        @Override
        public void endBlock(int id) {
        }

        @Override
        @CheckForNull
        public InputBlock startBlock(String name) {
            this.blockName = name;
            return null;
        }

        @Override
        public void makeGraphEdges() {
        }

        @Override
        public void startNode(int nodeId, boolean hasPredecessors, Builder.NodeClass nodeClass) {
            if (SingleGroupBuilder.this.collectCounts) {
                SingleGroupBuilder.this.gInfo.addNode(nodeId);
            }
            super.startNode(nodeId, hasPredecessors, nodeClass);
        }

        @Override
        public void markGraphDuplicate() {
            SingleGroupBuilder.this.gInfo.markDuplicate();
        }

        @Override
        @CheckForNull
        public InputGraph endGraph() {
            assert (this.nested != null);
            InputGraph n = this.nested;
            this.nested = this.nestedStack == null || this.nestedStack.isEmpty() ? null : this.nestedStack.remove(this.nestedStack.size() - 1);
            SingleGroupBuilder.this.instLog.log(Level.FINE, "Resuming operation after property {0}", this.getNestedProperty());
            this.popContext();
            return n;
        }

        @Override
        @CheckForNull
        public InputGraph startGraph(int dumpId, String format, Object[] args) {
            assert (this.getNestedProperty() != null);
            SingleGroupBuilder.this.instLog.log(Level.FINE, "Ignoring nested graph in property {0}", this.getNestedProperty());
            if (this.nested != null) {
                this.nestedStack = new ArrayList<InputGraph>();
                this.nestedStack.add(this.nested);
            }
            this.nested = super.startGraph(dumpId, format, args);
            Ignore sub = new Ignore(this.rootDocument(), SingleGroupBuilder.this.rootBuilder);
            SingleGroupBuilder.this.delegateTo(sub);
            return this.nested;
        }
    }

    class FullGraphBuilder
    extends LazyModelBuilder {
        private final InputGraph parentGraph;
        private final InputNode parent;

        public FullGraphBuilder(InputNode parent, InputGraph parentGraph, Folder folder) {
            super(SingleGroupBuilder.this.rootDocument, SingleGroupBuilder.this.rootBuilder.getMonitor());
            this.parent = parent;
            this.parentGraph = parentGraph;
            if (folder instanceof Group) {
                this.pushGroup(SingleGroupBuilder.this.toComplete, false);
            }
            if (parent != null) {
                this.pushNode(parent);
            }
            this.pushGraph(parentGraph);
            this.replacePool(SingleGroupBuilder.this.getConstantPool());
        }

        @Override
        protected InputGraph createGraph(Properties.Entity parent, int dumpId, String format, Object[] args) {
            if (SingleGroupBuilder.this.instLog.isLoggable(Level.FINE)) {
                SingleGroupBuilder.this.instLog.log(Level.FINE, "Create subgraph {0}:{1}, parent {2}, pos {3}", new Object[]{SingleGroupBuilder.this.graphLevel, ModelBuilder.makeGraphName(dumpId, format, args), this.node().getId(), SingleGroupBuilder.this.dataSource.getMark()});
            }
            if (parent instanceof InputNode) {
                return super.doCreateGraph(parent, new GraphBuilder.NestedGraphId(SingleGroupBuilder.this.entry, dumpId, format), dumpId, format, args);
            }
            long pos = SingleGroupBuilder.this.rootStartOffset;
            StreamEntry graphEntry = SingleGroupBuilder.this.streamIndex.get(pos);
            if (graphEntry == null) {
                throw new IllegalStateException();
            }
            return super.doCreateGraph(parent, graphEntry, dumpId, format, args);
        }

        @Override
        @CheckForNull
        public InputGraph endGraph() {
            if (SingleGroupBuilder.this.instLog.isLoggable(Level.FINE)) {
                SingleGroupBuilder.this.instLog.log(Level.FINE, "End subgraph {0}:{1}, pos {2}", new Object[]{SingleGroupBuilder.this.graphLevel + 1, this.graph().getName(), SingleGroupBuilder.this.dataSource.getMark()});
            }
            return super.endGraph();
        }

        @Override
        public void makeBlockEdges() {
            super.makeBlockEdges();
            InputGraph g = this.parentGraph;
            if (this.parent != null || g == null) {
                return;
            }
            if (SingleGroupBuilder.this.collectChanges && SingleGroupBuilder.this.gInfo != null) {
                assert (!(g instanceof Group.LazyContent));
                for (InputNode n : g.getNodes()) {
                    int nodeId = n.getId();
                    SingleGroupBuilder.this.gInfo.addNode(nodeId);
                    SingleGroupBuilder.this.registerNodeProperties(nodeId, n.getProperties());
                }
            }
        }
    }
}

