/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.data.serialization.lazy;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualizer.data.serialization.lazy.StreamEntry;

final class StreamIndex {
    private static final Logger LOG = Logger.getLogger(StreamIndex.class.getName());
    private final Map<Long, StreamEntry> map = new LinkedHashMap<Long, StreamEntry>();
    private long largestOffset = -1L;

    StreamIndex() {
    }

    public synchronized StreamEntry addEntry(StreamEntry en) {
        StreamEntry res = this.map.putIfAbsent(en.getStart(), en);
        this.largestOffset = Math.max(en.getStart(), this.largestOffset);
        this.notifyAll();
        return res == null ? en : res;
    }

    public synchronized StreamEntry get(long position) {
        this.waitOffset(position);
        return this.map.get(position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitOffset(long offset) {
        StreamIndex streamIndex = this;
        synchronized (streamIndex) {
            while (offset > this.largestOffset) {
                try {
                    LOG.log(Level.FINER, "Waiting for indexer to reach offset {0}", offset);
                    this.wait();
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public synchronized void close() {
        LOG.log(Level.FINER, "Index closing, largest entry offset: {0}", this.largestOffset);
        this.largestOffset = Long.MAX_VALUE;
        this.notifyAll();
    }

    public Iterator<StreamEntry> iterator() {
        return Collections.unmodifiableMap(this.map).values().iterator();
    }
}

