/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.layout;

import java.awt.Dimension;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.graalvm.visualizer.layout.Cluster;
import org.graalvm.visualizer.layout.Link;
import org.graalvm.visualizer.layout.Port;
import org.graalvm.visualizer.layout.Vertex;

public final class LayoutGraph {
    private Set<? extends Link> links;
    private SortedSet<Vertex> vertices;
    private HashMap<Vertex, Set<Port>> inputPorts;
    private HashMap<Vertex, Set<Port>> outputPorts;
    private HashMap<Port, Set<Link>> portLinks;
    private Dimension size;

    public LayoutGraph(Set<? extends Link> links) {
        this(links, new HashSet());
    }

    public LayoutGraph(Set<? extends Link> links, Set<? extends Vertex> additionalVertices) {
        this.links = links;
        assert (this.verify());
        this.vertices = new TreeSet<Vertex>();
        this.portLinks = new HashMap(links.size());
        this.inputPorts = new HashMap(links.size());
        this.outputPorts = new HashMap(links.size());
        for (Link link : links) {
            Port p = link.getFrom();
            Port p2 = link.getTo();
            Vertex v1 = p.getVertex();
            Vertex v2 = p2.getVertex();
            if (!this.vertices.contains(v1)) {
                this.outputPorts.put(v1, new HashSet(1));
                this.inputPorts.put(v1, new HashSet(3));
                this.vertices.add(v1);
                assert (this.vertices.contains(v1));
            }
            if (!this.vertices.contains(v2)) {
                this.vertices.add(v2);
                assert (this.vertices.contains(v2));
                this.outputPorts.put(v2, new HashSet(1));
                this.inputPorts.put(v2, new HashSet(3));
            }
            if (!this.portLinks.containsKey(p)) {
                HashSet hashSet = new HashSet(3);
                this.portLinks.put(p, hashSet);
            }
            if (!this.portLinks.containsKey(p2)) {
                this.portLinks.put(p2, new HashSet(3));
            }
            this.outputPorts.get(v1).add(p);
            this.inputPorts.get(v2).add(p2);
            this.portLinks.get(p).add(link);
            this.portLinks.get(p2).add(link);
        }
        for (Vertex vertex : additionalVertices) {
            if (this.vertices.contains(vertex)) continue;
            this.outputPorts.put(vertex, new HashSet(1));
            this.inputPorts.put(vertex, new HashSet(3));
            this.vertices.add(vertex);
            this.vertices.contains(vertex);
        }
    }

    public Set<Port> getInputPorts(Vertex v) {
        return this.inputPorts.get(v);
    }

    public Set<Port> getOutputPorts(Vertex v) {
        return this.outputPorts.get(v);
    }

    public Set<Link> getPortLinks(Port p) {
        return this.portLinks.get(p);
    }

    public Set<? extends Link> getLinks() {
        return this.links;
    }

    public boolean verify() {
        return true;
    }

    public SortedSet<Vertex> getVertices() {
        return this.vertices;
    }

    private void markNotRoot(Set<Vertex> notRootSet, Vertex v, Vertex startingVertex) {
        if (notRootSet.contains(v)) {
            return;
        }
        if (v != startingVertex) {
            notRootSet.add(v);
        }
        Set<Port> outPorts = this.getOutputPorts(v);
        for (Port p : outPorts) {
            Set<Link> curPortLinks = this.getPortLinks(p);
            for (Link l : curPortLinks) {
                Port other = l.getTo();
                Vertex otherVertex = other.getVertex();
                if (otherVertex == startingVertex) continue;
                this.markNotRoot(notRootSet, otherVertex, startingVertex);
            }
        }
    }

    public Set<Vertex> findRootVertices(Set<Vertex> startingRoots) {
        HashSet<Vertex> notRootSet = new HashSet<Vertex>();
        for (Vertex vertex : startingRoots) {
            if (notRootSet.contains(vertex)) continue;
            this.markNotRoot(notRootSet, vertex, vertex);
        }
        SortedSet<Vertex> tmpVertices = this.getVertices();
        for (Vertex v : tmpVertices) {
            if (notRootSet.contains(v) || !this.getInputPorts(v).isEmpty()) continue;
            this.markNotRoot(notRootSet, v, v);
        }
        for (Vertex v : tmpVertices) {
            if (notRootSet.contains(v)) continue;
            this.markNotRoot(notRootSet, v, v);
        }
        HashSet<Vertex> hashSet = new HashSet<Vertex>();
        for (Vertex v : tmpVertices) {
            if (notRootSet.contains(v)) continue;
            hashSet.add(v);
        }
        assert (tmpVertices.isEmpty() || hashSet.size() > 0);
        return hashSet;
    }

    public Set<Vertex> findRootVertices() {
        return this.findRootVertices(new HashSet<Vertex>());
    }

    public SortedSet<Cluster> getClusters() {
        TreeSet<Cluster> clusters = new TreeSet<Cluster>();
        for (Vertex v : this.getVertices()) {
            Cluster c = v.getCluster();
            if (c == null) continue;
            clusters.add(c);
        }
        return clusters;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension size) {
        assert (this.size == null);
        this.size = size;
    }
}

