/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filter;

import jdk.graal.compiler.graphio.parsing.model.ChangedEvent;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.filter.Filter;
import org.graalvm.visualizer.filter.FilterCanceledException;
import org.graalvm.visualizer.filter.FilterExecution;
import org.openide.cookies.OpenCookie;
import org.openide.util.Lookup;

public abstract class AbstractFilter
implements Filter {
    private final ChangedEvent<Filter> changedEvent;
    private final Properties properties;
    private final Lookup lkp;

    protected AbstractFilter() {
        this(Lookup.EMPTY);
    }

    public AbstractFilter(Lookup lkp) {
        this.lkp = lkp == null ? Lookup.EMPTY : lkp;
        this.changedEvent = new ChangedEvent((Object)this);
        this.properties = Properties.newProperties();
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public OpenCookie getEditor() {
        return null;
    }

    @Override
    public ChangedEvent<Filter> getChangedEvent() {
        return this.changedEvent;
    }

    protected void fireChangedEvent() {
        this.changedEvent.fire();
    }

    protected void checkCancelled() {
        FilterExecution ex = FilterExecution.get();
        if (ex != null && ex.isCancelled()) {
            throw new FilterCanceledException(ex.getEnvironment());
        }
    }

    @Override
    public Lookup getLookup() {
        return this.lkp;
    }
}

