/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filter;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.visualizer.filter.AbstractFilter;
import org.graalvm.visualizer.graph.Connection;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.graph.OutputSlot;
import org.graalvm.visualizer.graph.Selector;

public class ColorFilter
extends AbstractFilter {
    private List<ColorRule> colorRules;
    private String name;

    public ColorFilter(String name) {
        this.name = name;
        this.colorRules = new ArrayList<ColorRule>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void apply(Diagram diagram) {
        for (ColorRule rule : this.colorRules) {
            if (rule.getSelector() != null) {
                List figures = rule.getSelector().selected(diagram);
                for (Figure f : figures) {
                    this.applyRule(rule, f);
                    if (rule.getColor() == null) continue;
                    f.setColor(rule.getColor());
                }
                continue;
            }
            for (Figure f : diagram.getFigures()) {
                this.applyRule(rule, f);
            }
        }
    }

    private void applyRule(ColorRule rule, Figure f) {
        this.checkCancelled();
        if (rule.getColor() != null) {
            f.setColor(rule.getColor());
        }
        Color color = rule.getLineColor();
        Connection.ConnectionStyle style = rule.getLineStyle();
        for (OutputSlot s : f.getOutputSlots()) {
            for (Connection c : s.getConnections()) {
                if (color != null) {
                    c.setColor(color);
                }
                if (style == null) continue;
                c.setStyle(style);
            }
        }
    }

    public void addRule(ColorRule r) {
        this.colorRules.add(r);
    }

    public static class ColorRule {
        private Color color;
        private Color lineColor;
        private Connection.ConnectionStyle lineStyle;
        private Selector selector;

        public ColorRule(Selector selector, Color c) {
            this(selector, c, null, null);
        }

        public ColorRule(Selector selector, Color c, Color lineColor, Connection.ConnectionStyle lineStyle) {
            this.selector = selector;
            this.color = c;
            this.lineColor = lineColor;
            this.lineStyle = lineStyle;
        }

        public ColorRule(Color c) {
            this(null, c);
        }

        public Color getColor() {
            return this.color;
        }

        public Selector getSelector() {
            return this.selector;
        }

        public Color getLineColor() {
            return this.lineColor;
        }

        public Connection.ConnectionStyle getLineStyle() {
            return this.lineStyle;
        }
    }
}

