/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filter;

import java.util.EventObject;
import java.util.concurrent.CancellationException;
import org.graalvm.visualizer.filter.Filter;
import org.graalvm.visualizer.filter.FilterCanceledException;
import org.graalvm.visualizer.filter.FilterExecution;
import org.graalvm.visualizer.filter.FilterSequence;
import org.graalvm.visualizer.graph.Diagram;

public final class FilterEvent
extends EventObject {
    private final Filter filter;
    private final Throwable executionError;
    private final Diagram filteredDiagram;
    private final FilterExecution execution;

    public FilterEvent(FilterExecution exec, FilterSequence source, Filter filter, Diagram filteredDiagram) {
        this(exec, source, filter, filteredDiagram, null);
    }

    public FilterEvent(FilterExecution exec, FilterSequence source, Filter filter, Diagram filteredDiagram, Throwable error) {
        super(source);
        this.filter = filter;
        this.executionError = error;
        this.filteredDiagram = filteredDiagram;
        this.execution = exec;
    }

    public FilterExecution getExecution() {
        return this.execution;
    }

    @Override
    public FilterSequence getSource() {
        return (FilterSequence)super.getSource();
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Throwable getExecutionError() {
        return this.executionError;
    }

    public Diagram getFilteredDiagram() {
        return this.filteredDiagram;
    }

    public boolean wasInterrupted() {
        return this.executionError instanceof FilterCanceledException || this.executionError instanceof CancellationException;
    }
}

