/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualizer.data.SuppressFBWarnings;
import org.graalvm.visualizer.filter.Filter;
import org.graalvm.visualizer.filter.FilterCanceledException;
import org.graalvm.visualizer.filter.FilterChain;
import org.graalvm.visualizer.filter.FilterEnvironment;
import org.graalvm.visualizer.filter.FilterEvent;
import org.graalvm.visualizer.filter.FilterExecutionService;
import org.graalvm.visualizer.filter.FilterListener;
import org.graalvm.visualizer.filter.impl.FilterExecutionServiceImpl;
import org.graalvm.visualizer.graph.Diagram;

public class FilterExecution {
    private static final Logger LOG = Logger.getLogger(FilterExecution.class.getName());
    private final List<Filter> orderedFilters;
    private final Diagram dg;
    private final FilterChain chain;
    private volatile int state;
    private static final int INIT = 0;
    private static final int RUN = 1;
    private static final int CANCEL = 2;
    private final FilterEnvironment env;
    private FilterExecution nested;
    private static final ThreadLocal<FilterExecution> current = new ThreadLocal();
    private final boolean closeEnvironment;
    private final List<FilterListener> listeners = new ArrayList<FilterListener>();
    private FilterEvent errorFilterEvent;

    public FilterExecution(List<Filter> orderedFilters, Diagram dg, FilterChain chain, FilterEnvironment env) {
        this.orderedFilters = new ArrayList<Filter>(orderedFilters);
        this.dg = dg;
        this.chain = chain;
        this.env = env;
        this.closeEnvironment = false;
    }

    public FilterExecution(List<Filter> orderedFilters, Diagram dg, FilterChain chain) {
        this.orderedFilters = new ArrayList<Filter>(orderedFilters);
        this.dg = dg;
        this.chain = chain;
        this.env = new FilterChain.FEImpl(dg, null);
        this.closeEnvironment = true;
    }

    public List<Filter> getFilters() {
        return Collections.unmodifiableList(this.orderedFilters);
    }

    void addListeners(List<FilterListener> ll) {
        this.listeners.addAll(ll);
    }

    void removeListeners(List<FilterListener> ll) {
        this.listeners.removeAll(ll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilterListener(FilterListener l) {
        List<FilterListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilterListener(FilterListener l) {
        List<FilterListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    static FilterExecution get() {
        FilterExecution exec = current.get();
        if (exec == null) {
            throw new IllegalStateException();
        }
        return exec;
    }

    static FilterExecution getOrCreate(Diagram d, Filter f) {
        FilterExecution e = FilterExecution.get();
        if (e != null && e.getDiagram() == d) {
            return e;
        }
        return new FilterExecution((List)Collections.singletonList(f), d, null, (FilterEnvironment)FilterChain.createStub(d)){

            @Override
            protected void applyFilter(Filter f) {
                f.applyWith(this.getEnvironment());
            }
        };
    }

    private synchronized void setChild(FilterExecution ex) {
        this.nested = ex;
    }

    protected void applyFilter(Filter f) {
        this.applyFilter(f, this.chain);
    }

    public void process() throws FilterCanceledException {
        this.doProcess(() -> {
            FilterExecutionServiceImpl serviceImpl = FilterExecutionServiceImpl.get();
            serviceImpl.runWith(this.chain, this, () -> {
                List<FilterListener> ll = this.snapshotListeners();
                FilterEvent e = null;
                if (!ll.isEmpty()) {
                    e = new FilterEvent(this, this.chain, null, this.dg);
                    for (FilterListener l : ll) {
                        l.executionStart(e);
                    }
                }
                for (Filter f : this.orderedFilters) {
                    if (this.state != 1) break;
                    this.applyFilter(f);
                }
                if (!ll.isEmpty()) {
                    if (this.errorFilterEvent != null) {
                        e = this.errorFilterEvent;
                    }
                    for (FilterListener l : ll) {
                        l.executionEnd(e);
                    }
                }
            });
        });
    }

    public FilterEvent getErrorFilterEvent() {
        return this.errorFilterEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FilterListener> snapshotListeners() {
        List<FilterListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList<FilterListener>(this.listeners);
        }
    }

    void processSingle(Filter f) {
        this.doProcess(() -> this.applyFilter(f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcess(Runnable toInvoke) throws FilterCanceledException {
        FilterExecution filterExecution = this;
        synchronized (filterExecution) {
            if (this.state > 1) {
                throw new FilterCanceledException(this.getEnvironment());
            }
            this.state = 1;
        }
        FilterExecution parent = current.get();
        try {
            if (parent != null) {
                parent.setChild(this);
            }
            current.set(this);
            toInvoke.run();
            FilterExecution filterExecution2 = this;
            synchronized (filterExecution2) {
                if (this.state > 1) {
                    throw new FilterCanceledException(this.getEnvironment());
                }
            }
            if (parent != null && parent != this) {
                parent.setChild(null);
            }
        }
        catch (FilterCanceledException ex) {
            FilterExecution filterExecution3 = this;
            synchronized (filterExecution3) {
                this.state = 2;
                throw ex;
            }
        }
        finally {
            current.set(parent);
            if (this.closeEnvironment) {
                try {
                    this.env.close();
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, "Error closing scripting environment: ", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        FilterExecution child;
        FilterExecution filterExecution = this;
        synchronized (filterExecution) {
            int s = this.state;
            this.state = 2;
            if (s != 1) {
                return;
            }
            child = this.nested;
        }
        if (child != null) {
            child.cancel();
        }
        for (Filter f : this.orderedFilters) {
            f.cancel(this.getEnvironment());
        }
    }

    public boolean isCancelled() {
        return this.state >= 2;
    }

    public Diagram getDiagram() {
        return this.dg;
    }

    public FilterEnvironment getEnvironment() {
        return this.env;
    }

    public static FilterExecutionService getExecutionService() {
        return FilterExecutionServiceImpl.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"UCF_USELESS_CONTROL_FLOW_NEXT_LINE"}, justification="Throws exception when asserts are enabled")
    void applyFilter(Filter f, FilterChain chain) {
        FilterEvent initEv;
        FilterEnvironment env = this.getEnvironment();
        FilterExecution exec = this;
        Diagram d = this.getDiagram();
        List<FilterListener> ll = this.snapshotListeners();
        FilterEvent ev = initEv = new FilterEvent(this, chain, f, d);
        try {
            LOG.log(Level.FINE, "Applying filter: {0} ", f);
            for (FilterListener l : ll) {
                l.filterStart(ev);
            }
            chain.fireFilterEvent(ev, true);
            f.applyWith(env);
        }
        catch (ThreadDeath ex) {
            ev = null;
            throw ex;
        }
        catch (CancellationException ex) {
            LOG.log(Level.FINE, "Filter was cancelled: " + f, ex);
            FilterCanceledException ee = new FilterCanceledException(env, (Throwable)ex);
            ev = new FilterEvent(this, chain, f, d, ee);
            throw ee;
        }
        catch (FilterCanceledException ex) {
            LOG.log(Level.FINE, "Filter was cancelled: " + f, ex);
            ev = new FilterEvent(this, chain, f, d, ex);
            throw ex;
        }
        catch (Throwable ex) {
            LOG.log(Level.FINE, "Filter terminated abruptly: " + f, ex);
            boolean throwError = false;
            if ($assertionsDisabled || !(throwError = ex instanceof Error && ex.getClass().getName().startsWith("org.junit"))) {
                // empty if block
            }
            if (throwError) {
                ev = null;
                throw (Error)ex;
            }
            ev = new FilterEvent(this, chain, f, d, ex);
        }
        finally {
            if (ev != null) {
                for (FilterListener l : ll) {
                    l.filterEnd(ev);
                }
                chain.fireFilterEvent(ev, false);
                if (ev.getExecutionError() != null) {
                    this.errorFilterEvent = ev;
                }
            }
        }
    }

    public boolean isRunning() {
        return this.state == 1;
    }
}

