/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filter;

import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.Raster;
import java.util.Collection;
import org.graalvm.visualizer.filter.AbstractFilter;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.graph.Figure;
import org.openide.util.Exceptions;

public class GradientColorFilter
extends AbstractFilter {
    public static final String LINEAR = "LINEAR";
    public static final String LOGARITHMIC = "LOGARITHMIC";
    private String propertyName = "probability";
    private float minValue = 0.0f;
    private float maxValue = 500.0f;
    private float[] fractions = new float[]{0.0f, 0.5f, 1.0f};
    private Color[] colors = new Color[]{Color.BLUE, Color.YELLOW, Color.RED};
    private int shadeCount = 8;
    private String mode = "LINEAR";

    @Override
    public String getName() {
        return "Gradient Color Filter";
    }

    @Override
    public void apply(Diagram d) {
        boolean logarithmic = this.mode.equalsIgnoreCase(LOGARITHMIC);
        if (!logarithmic && !this.mode.equalsIgnoreCase(LINEAR)) {
            throw new RuntimeException("Unknown mode: " + this.mode);
        }
        Rectangle bounds = new Rectangle(this.shadeCount, 1);
        LinearGradientPaint lgp = new LinearGradientPaint(bounds.x, bounds.y, bounds.width, bounds.y, this.fractions, this.colors);
        PaintContext context = lgp.createContext(null, bounds, bounds.getBounds2D(), AffineTransform.getTranslateInstance(0.0, 0.0), new RenderingHints(null));
        Raster raster = context.getRaster(bounds.x, bounds.y, bounds.width, bounds.height);
        int[] rgb = raster.getPixels(bounds.x, bounds.y, bounds.width, bounds.height, (int[])null);
        Color[] shades = new Color[rgb.length / 3];
        for (int i = 0; i < shades.length; ++i) {
            shades[i] = new Color(rgb[i * 3], rgb[i * 3 + 1], rgb[i * 3 + 2]);
        }
        Collection figures = d.getFigures();
        for (Figure f : figures) {
            this.checkCancelled();
            String property = f.getProperties().getString(this.propertyName, null);
            if (property == null) continue;
            try {
                Color nodeColor;
                float value = Float.parseFloat(property);
                if (value <= this.minValue) {
                    nodeColor = this.colors[0];
                } else if (value >= this.maxValue) {
                    nodeColor = this.colors[this.colors.length - 1];
                } else {
                    double normalized = value - this.minValue;
                    double interval = this.maxValue - this.minValue;
                    int index = logarithmic ? (int)Math.ceil((double)shades.length * Math.log(1.0 + normalized) / Math.log(1.0 + interval)) : (int)Math.ceil((double)shades.length * normalized / interval);
                    nodeColor = shades[index];
                }
                f.setColor(nodeColor);
            }
            catch (NumberFormatException value) {
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public void setMinValue(float minValue) {
        this.minValue = minValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(float maxValue) {
        this.maxValue = maxValue;
    }

    public float[] getFractions() {
        return this.fractions;
    }

    public void setFractions(float[] fractions) {
        this.fractions = fractions;
    }

    public Color[] getColors() {
        return this.colors;
    }

    public void setColors(Color[] colors) {
        this.colors = colors;
    }

    public int getShadeCount() {
        return this.shadeCount;
    }

    public void setShadeCount(int shadeCount) {
        this.shadeCount = shadeCount;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }
}

