/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filter;

import java.util.List;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.filter.AbstractFilter;
import org.graalvm.visualizer.graph.Connection;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.graph.InputSlot;
import org.graalvm.visualizer.graph.OutputSlot;
import org.graalvm.visualizer.graph.Selector;

public class SplitFilter
extends AbstractFilter {
    private final String name;
    private final Selector selector;
    private final String propertyName;

    public SplitFilter(String name, Selector selector, String propertyName) {
        this.name = name;
        this.selector = selector;
        this.propertyName = propertyName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void apply(Diagram d) {
        List list = this.selector.selected(d);
        for (Figure f : list) {
            String s;
            InputNode n;
            this.checkCancelled();
            for (InputSlot is : f.getInputSlots()) {
                for (Connection c : is.getConnections()) {
                    OutputSlot os = c.getOutputSlot();
                    n = f.getSource().first();
                    if (n != null) {
                        os.getSource().addSourceNodes(f.getSource());
                        os.setAssociatedNode(n);
                        os.setColor(f.getColor());
                    }
                    if ((s = Figure.resolveString((String)this.propertyName, (Properties)f.getProperties())) == null) continue;
                    os.setShortName(s);
                }
            }
            for (OutputSlot os : f.getOutputSlots()) {
                for (Connection c : os.getConnections()) {
                    InputSlot is = c.getInputSlot();
                    n = f.getSource().first();
                    if (n != null) {
                        is.getSource().addSourceNodes(f.getSource());
                        is.setAssociatedNode(n);
                        is.setColor(f.getColor());
                    }
                    if ((s = Figure.resolveString((String)this.propertyName, (Properties)f.getProperties())) == null) continue;
                    is.setShortName(s);
                }
            }
            d.removeFigure(f);
        }
    }
}

