/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filter.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.graalvm.visualizer.filter.Filter;
import org.graalvm.visualizer.filter.FilterChain;
import org.graalvm.visualizer.filter.FilterEnvironment;
import org.graalvm.visualizer.filter.FilterEvent;
import org.graalvm.visualizer.filter.FilterExecution;
import org.graalvm.visualizer.filter.FilterExecutionService;
import org.graalvm.visualizer.filter.FilterListener;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.script.ScriptEnvironment;

public class FilterExecutionServiceImpl
implements FilterExecutionService {
    private static final Logger LOG = Logger.getLogger(FilterExecutionServiceImpl.class.getName());
    private final List<FilterListener> listeners = new ArrayList<FilterListener>();
    private static FilterExecutionServiceImpl INSTANCE = new FilterExecutionServiceImpl();

    public static synchronized FilterExecutionServiceImpl get() {
        return INSTANCE;
    }

    @Override
    public FilterExecution createExecution(FilterChain sequence, ScriptEnvironment e, Diagram d) {
        List<Filter> orderedFilters = sequence.getFilters();
        if (e != null) {
            return new FilterExecution(orderedFilters, d, sequence, new FEImpl(d, e));
        }
        return new FilterExecution(orderedFilters, d, sequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWith(FilterChain chain, FilterExecution exec, Runnable r) {
        RunListener rl = new RunListener(chain);
        exec.addFilterListener(rl);
        try {
            r.run();
        }
        finally {
            exec.removeFilterListener(rl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardExecutionEvent(FilterEvent ev, boolean start) {
        FilterListener[] filterListenerArray = this.listeners;
        synchronized (this.listeners) {
            if (this.listeners.isEmpty()) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
            FilterListener[] ll = this.listeners.toArray(new FilterListener[this.listeners.size()]);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (FilterListener l : ll) {
                if (start) {
                    l.executionStart(ev);
                    continue;
                }
                l.executionEnd(ev);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardEvent(FilterEvent ev, boolean start) {
        FilterListener[] filterListenerArray = this.listeners;
        synchronized (this.listeners) {
            if (this.listeners.isEmpty()) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
            FilterListener[] ll = this.listeners.toArray(new FilterListener[this.listeners.size()]);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (FilterListener l : ll) {
                if (start) {
                    l.filterStart(ev);
                    continue;
                }
                l.filterEnd(ev);
            }
            return;
        }
    }

    @Override
    public void addFilterListener(FilterListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeFilterListener(FilterListener l) {
        this.listeners.remove(l);
    }

    static class FEImpl
    extends FilterEnvironment {
        private final boolean closeScript;

        public FEImpl(Diagram d, ScriptEnvironment e) {
            super(d, e == null ? new ScriptEnvImpl() : e);
            this.closeScript = e == null;
        }

        @Override
        public void close() throws IOException {
            if (this.closeScript) {
                this.getScriptEnvironment().close();
            }
        }
    }

    class RunListener
    implements FilterListener {
        private final FilterChain currentChain;

        public RunListener(FilterChain currentChain) {
            this.currentChain = currentChain;
        }

        @Override
        public void filterStart(FilterEvent e) {
            FilterExecutionServiceImpl.this.forwardEvent(e, true);
        }

        @Override
        public void filterEnd(FilterEvent e) {
            FilterExecutionServiceImpl.this.forwardEvent(e, false);
        }

        @Override
        public void executionStart(FilterEvent e) {
            FilterExecutionServiceImpl.this.forwardExecutionEvent(e, true);
        }

        @Override
        public void executionEnd(FilterEvent e) {
            FilterExecutionServiceImpl.this.forwardExecutionEvent(e, false);
        }
    }

    static class ScriptEnvImpl
    extends ScriptEnvironment {
        Map<Object, Object> vals = new HashMap<Object, Object>();

        ScriptEnvImpl() {
        }

        public <T> T setValue(Object key, T val) {
            return (T)this.vals.put(key, val);
        }

        public <T> T getValue(Object key) {
            return (T)this.vals.get(key);
        }

        public Set keys() {
            return this.vals.keySet();
        }

        public Iterable values() {
            return this.vals.values();
        }
    }
}

