/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ModuleElement;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.AccessibilityQuery;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.impl.MultiModule;
import org.netbeans.spi.java.queries.AccessibilityQueryImplementation2;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

final class ModuleInfoAccessibilityQueryImpl
implements AccessibilityQueryImplementation2,
PropertyChangeListener,
FileChangeListener {
    private static final String MODULE_INFO_JAVA = "module-info.java";
    private final SourceRoots sourceModules;
    private final SourceRoots sources;
    private final SourceRoots testModules;
    private final SourceRoots tests;
    private final ChangeSupport listeners;
    private final Set<File> moduleInfoListeners;
    private ExportsCache exportsCache;
    private boolean listensOnRoots;

    ModuleInfoAccessibilityQueryImpl(@NullAllowed SourceRoots sourceModules, @NonNull SourceRoots sources, @NullAllowed SourceRoots testModules, @NonNull SourceRoots tests) {
        Parameters.notNull((CharSequence)"sources", (Object)sources);
        Parameters.notNull((CharSequence)"tests", (Object)tests);
        this.sourceModules = sourceModules;
        this.sources = sources;
        this.testModules = testModules;
        this.tests = tests;
        this.moduleInfoListeners = new HashSet<File>();
        this.listeners = new ChangeSupport((Object)this);
    }

    @CheckForNull
    public AccessibilityQueryImplementation2.Result isPubliclyAccessible(FileObject pkg) {
        ExportsCache cache = this.getCache();
        if (!cache.isKnown(pkg)) {
            return null;
        }
        return new ResultImpl(pkg, this);
    }

    @Override
    public void propertyChange(@NonNull PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (SourceRoots.PROP_ROOTS.equals(propName)) {
            this.reset();
        }
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.reset();
    }

    public void fileDataCreated(FileEvent fe) {
        this.reset();
    }

    public void fileChanged(FileEvent fe) {
        this.reset();
    }

    public void fileDeleted(FileEvent fe) {
        this.reset();
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    private void addChangeListener(@NonNull ChangeListener listener) {
        this.listeners.addChangeListener(listener);
    }

    private void removeChangeListener(@NonNull ChangeListener listener) {
        this.listeners.removeChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        ModuleInfoAccessibilityQueryImpl moduleInfoAccessibilityQueryImpl = this;
        synchronized (moduleInfoAccessibilityQueryImpl) {
            this.exportsCache = null;
        }
        this.listeners.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private ExportsCache getCache() {
        ExportsCache ec;
        ModuleInfoAccessibilityQueryImpl moduleInfoAccessibilityQueryImpl = this;
        synchronized (moduleInfoAccessibilityQueryImpl) {
            ec = this.exportsCache;
        }
        if (ec == null) {
            HashSet<FileObject> rootsCollector = new HashSet<FileObject>();
            ArrayList<Pair<Set<FileObject>, Set<FileObject>>> data = new ArrayList<Pair<Set<FileObject>, Set<FileObject>>>(2);
            ArrayDeque<FileObject[]> todo = new ArrayDeque<FileObject[]>();
            if (this.sourceModules != null) {
                todo.addAll(this.collectModuleRoots(this.sourceModules, this.sources));
            } else {
                todo.offer(this.sources.getRoots());
            }
            if (this.testModules != null) {
                todo.addAll(this.collectModuleRoots(this.testModules, this.tests));
            } else {
                todo.offer(this.tests.getRoots());
            }
            for (FileObject[] work : todo) {
                ModuleInfoAccessibilityQueryImpl.readExports(work, rootsCollector).ifPresent(data::add);
            }
            ec = new ExportsCache(rootsCollector, data);
            ModuleInfoAccessibilityQueryImpl moduleInfoAccessibilityQueryImpl2 = this;
            synchronized (moduleInfoAccessibilityQueryImpl2) {
                if (this.exportsCache == null) {
                    this.exportsCache = ec;
                } else {
                    ec = this.exportsCache;
                }
                if (!this.listensOnRoots) {
                    this.listensOnRoots = true;
                    if (this.sourceModules != null) {
                        this.sourceModules.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.sourceModules));
                    }
                    if (this.testModules != null) {
                        this.testModules.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.testModules));
                    }
                    this.sources.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.sources));
                    this.tests.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.tests));
                }
                Set allRoots = rootsCollector.stream().map(fo -> FileUtil.toFile((FileObject)fo)).filter(f -> f != null).collect(Collectors.toSet());
                HashSet<File> toRemove = new HashSet<File>(this.moduleInfoListeners);
                toRemove.removeAll(allRoots);
                allRoots.removeAll(this.moduleInfoListeners);
                for (File f2 : toRemove) {
                    FileUtil.removeFileChangeListener((FileChangeListener)this, (File)new File(f2, MODULE_INFO_JAVA));
                    this.moduleInfoListeners.remove(f2);
                }
                for (File f2 : allRoots) {
                    FileUtil.addFileChangeListener((FileChangeListener)this, (File)new File(f2, MODULE_INFO_JAVA));
                    this.moduleInfoListeners.add(f2);
                }
            }
        }
        return ec;
    }

    @NonNull
    private Collection<FileObject[]> collectModuleRoots(@NonNull SourceRoots mods, @NonNull SourceRoots src) {
        ArrayDeque<FileObject[]> res = new ArrayDeque<FileObject[]>();
        MultiModule model = MultiModule.getOrCreate(mods, src);
        for (String string : model.getModuleNames()) {
            ClassPath cp = model.getModuleSources(string);
            res.add(cp.getRoots());
        }
        return res;
    }

    @NonNull
    private static Optional<Pair<Set<FileObject>, Set<FileObject>>> readExports(@NonNull FileObject[] roots, @NonNull Set<? super FileObject> rootsCollector) {
        Collections.addAll(rootsCollector, roots);
        Optional<FileObject> moduleInfo = Arrays.stream(roots).map(root -> root.getFileObject(MODULE_INFO_JAVA)).filter(mi -> mi != null).findFirst();
        if (!moduleInfo.isPresent()) {
            return Optional.empty();
        }
        HashSet<FileObject> rootsSet = new HashSet<FileObject>();
        Collections.addAll(rootsSet, roots);
        Set<FileObject> exportsSet = ModuleInfoAccessibilityQueryImpl.readExports(moduleInfo.get(), rootsSet);
        return Optional.of(Pair.of(rootsSet, exportsSet));
    }

    @NonNull
    private static Set<FileObject> readExports(@NonNull FileObject moduleInfo, @NonNull Set<FileObject> roots) {
        HashSet<FileObject> exports = new HashSet<FileObject>();
        JavaSource src = JavaSource.forFileObject((FileObject)moduleInfo);
        if (src != null) {
            try {
                src.runUserActionTask(cc -> {
                    cc.toPhase(JavaSource.Phase.RESOLVED);
                    CompilationUnitTree cu = cc.getCompilationUnit();
                    if (cu.getTypeDecls().size() == 1 && cu.getTypeDecls().get(0) instanceof ModuleTree) {
                        ModuleTree mt = (ModuleTree)cu.getTypeDecls().get(0);
                        ModuleElement me = (ModuleElement)cc.getTrees().getElement(TreePath.getPath(cu, (Tree)mt));
                        if (me != null) {
                            for (ModuleElement.Directive directive : me.getDirectives()) {
                                if (directive.getKind() != ModuleElement.DirectiveKind.EXPORTS) continue;
                                ModuleElement.ExportsDirective export = (ModuleElement.ExportsDirective)directive;
                                String pkgName = export.getPackage().getQualifiedName().toString();
                                exports.addAll(ModuleInfoAccessibilityQueryImpl.findPackage(pkgName, roots));
                            }
                        }
                    }
                }, true);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        return exports;
    }

    @NonNull
    private static Set<FileObject> findPackage(@NonNull String pkgName, @NonNull Collection<? extends FileObject> roots) {
        String path = pkgName.replace('.', '/');
        HashSet<FileObject> res = new HashSet<FileObject>();
        for (FileObject fileObject : roots) {
            FileObject pkg = fileObject.getFileObject(path);
            if (pkg == null) continue;
            res.add(pkg);
        }
        return res;
    }

    private static final class ExportsCache {
        private final Set<FileObject> roots;
        private final List<Pair<Set<FileObject>, Set<FileObject>>> data;

        ExportsCache(@NonNull Set<FileObject> roots, @NonNull List<Pair<Set<FileObject>, Set<FileObject>>> data) {
            this.roots = roots;
            this.data = data;
        }

        boolean isKnown(@NonNull FileObject pkg) {
            return this.roots.stream().anyMatch(root -> root.equals(pkg) || FileUtil.isParentOf((FileObject)root, (FileObject)pkg));
        }

        boolean isInModule(@NonNull FileObject pkg) {
            return this.data.stream().flatMap(p -> ((Set)p.first()).stream()).anyMatch(root -> root.equals(pkg) || FileUtil.isParentOf((FileObject)root, (FileObject)pkg));
        }

        boolean isExported(@NonNull FileObject pkg) {
            return this.data.stream().flatMap(p -> ((Set)p.second()).stream()).anyMatch(exported -> exported.equals(pkg));
        }
    }

    private static class ResultImpl
    implements AccessibilityQueryImplementation2.Result {
        private final FileObject pkg;
        private final ModuleInfoAccessibilityQueryImpl owner;

        public ResultImpl(@NonNull FileObject pkg, @NonNull ModuleInfoAccessibilityQueryImpl owner) {
            this.pkg = pkg;
            this.owner = owner;
        }

        public AccessibilityQuery.Accessibility getAccessibility() {
            ExportsCache cache = this.owner.getCache();
            if (!cache.isInModule(this.pkg)) {
                return AccessibilityQuery.Accessibility.UNKNOWN;
            }
            if (cache.isExported(this.pkg)) {
                return AccessibilityQuery.Accessibility.EXPORTED;
            }
            return AccessibilityQuery.Accessibility.PRIVATE;
        }

        public void addChangeListener(@NonNull ChangeListener listener) {
            this.owner.addChangeListener(listener);
        }

        public void removeChangeListener(@NonNull ChangeListener listener) {
            this.owner.removeChangeListener(listener);
        }
    }
}

