/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.java.api.common.impl.MultiModule;
import org.netbeans.modules.java.api.common.queries.EvaluatorPropertyProvider;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.util.Parameters;

final class MultiModuleAntArtifactProvider
implements AntArtifactProvider {
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final MultiModule srcModules;
    private final String buildTarget;
    private final String cleanTarget;

    MultiModuleAntArtifactProvider(@NonNull AntProjectHelper helper, @NonNull PropertyEvaluator eval, @NonNull MultiModule model, @NonNull String buildTarget, @NonNull String cleanTarget) {
        Parameters.notNull((CharSequence)"helper", (Object)helper);
        Parameters.notNull((CharSequence)"eval", (Object)eval);
        Parameters.notNull((CharSequence)"model", (Object)model);
        Parameters.notNull((CharSequence)"buildTarget", (Object)buildTarget);
        Parameters.notNull((CharSequence)"cleanTarget", (Object)cleanTarget);
        this.helper = helper;
        this.eval = eval;
        this.srcModules = model;
        this.buildTarget = buildTarget;
        this.cleanTarget = cleanTarget;
    }

    public AntArtifact[] getBuildArtifacts() {
        ArrayList<ModuleIdDecorator> artifacts = new ArrayList<ModuleIdDecorator>();
        EvaluatorPropertyProvider pp = new EvaluatorPropertyProvider(this.eval);
        for (String string : this.srcModules.getModuleNames()) {
            String moduleDistJarKey = String.format("module.%s.dist.jar", string);
            String moduleDistJarVal = String.format("${%s}/%s.jar", "dist.dir", string);
            PropertyEvaluator extEval = PropertyUtils.sequentialPropertyEvaluator(null, (PropertyProvider[])new PropertyProvider[]{pp, PropertyUtils.fixedPropertyProvider(Collections.singletonMap(moduleDistJarKey, moduleDistJarVal))});
            AntArtifact artifact = this.helper.createSimpleAntArtifact("jar", moduleDistJarKey, extEval, this.buildTarget, this.cleanTarget, "buildfile");
            artifacts.add(new ModuleIdDecorator(string, artifact));
        }
        return artifacts.toArray(new AntArtifact[artifacts.size()]);
    }

    private static final class ModuleIdDecorator
    extends AntArtifact {
        private final String moduleName;
        private final AntArtifact delegate;

        ModuleIdDecorator(String moduleName, AntArtifact delegate) {
            Parameters.notNull((CharSequence)"moduleName", (Object)moduleName);
            Parameters.notNull((CharSequence)"delegate", (Object)delegate);
            this.moduleName = moduleName;
            this.delegate = delegate;
        }

        public String getType() {
            return this.delegate.getType();
        }

        public File getScriptLocation() {
            return this.delegate.getScriptLocation();
        }

        public String getTargetName() {
            return this.delegate.getTargetName();
        }

        public String getCleanTargetName() {
            return this.delegate.getCleanTargetName();
        }

        public URI[] getArtifactLocations() {
            return this.delegate.getArtifactLocations();
        }

        public URI getArtifactLocation() {
            return this.delegate.getArtifactLocation();
        }

        public Project getProject() {
            return this.delegate.getProject();
        }

        public Properties getProperties() {
            return this.delegate.getProperties();
        }

        public String getID() {
            return String.format("%s.%s", this.moduleName, super.getID());
        }
    }
}

