/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.document;

import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.editor.lib2.document.EditorPosition;
import org.netbeans.modules.editor.lib2.document.MarkVector;
import org.openide.util.BaseUtilities;

final class Mark
extends WeakReference<EditorPosition>
implements Runnable {
    static final Logger LOG = Logger.getLogger(Mark.class.getName());
    int rawOffset;
    private MarkVector markVector;

    Mark(MarkVector markVector, int rawOffset, EditorPosition pos) {
        super(pos, BaseUtilities.activeReferenceQueue());
        this.markVector = markVector;
        this.rawOffset = rawOffset;
        pos.initMark(this);
    }

    public int getOffset() {
        MarkVector lMarkVector = this.markVector;
        int offset = lMarkVector != null ? lMarkVector.offset(this.rawOffset) : this.rawOffset;
        return offset;
    }

    public boolean isBackwardBias() {
        MarkVector lMarkVector = this.markVector;
        return lMarkVector != null ? lMarkVector.isBackwardBiasMarks() : false;
    }

    public int rawOffset() {
        return this.rawOffset;
    }

    @Override
    public void run() {
        MarkVector lMarkVector = this.markVector;
        if (lMarkVector != null) {
            lMarkVector.notifyMarkDisposed();
        }
    }

    void clearMarkVector() {
        this.markVector = null;
    }

    boolean isActive() {
        return this.markVector != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(8);
        sb.append(this.getOffset());
        if (LOG.isLoggable(Level.FINE)) {
            EditorPosition pos = (EditorPosition)this.get();
            if (this.isBackwardBias()) {
                sb.append("B");
            }
            if (pos == null) {
                sb.append('D');
            }
            if (LOG.isLoggable(Level.FINER)) {
                sb.append(";M@").append(Integer.toHexString(System.identityHashCode(this)));
            }
        }
        return sb.toString();
    }

    public String toStringDetail() {
        return this.toString() + ";R:" + this.rawOffset;
    }
}

