/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.hierarchicallayout;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.visualizer.hierarchicallayout.ClusterSlotNode;
import org.graalvm.visualizer.layout.Link;
import org.graalvm.visualizer.layout.Port;

public class ClusterConnection
implements Link {
    private List<Point> controlPoints;
    private final Link connection;
    private final Port inputSlot;
    private final Port outputSlot;

    private ClusterConnection(Port inputSlot, Port outputSlot, Link c) {
        this.connection = c;
        this.controlPoints = new ArrayList<Point>();
        this.inputSlot = inputSlot;
        this.outputSlot = outputSlot;
    }

    public static ClusterConnection makeOutputConnection(ClusterSlotNode outputSlotNode, Link connection) {
        assert (!outputSlotNode.isInputSlot());
        return new ClusterConnection(outputSlotNode.getInputSlot(), connection.getFrom(), connection);
    }

    public static ClusterConnection makeInputConnection(ClusterSlotNode inputSlotNode, Link connection) {
        assert (inputSlotNode.isInputSlot());
        return new ClusterConnection(connection.getTo(), inputSlotNode.getOutputSlot(), connection);
    }

    public static ClusterConnection makeInnerConnection(ClusterSlotNode inputSlotNode, ClusterSlotNode outputSlotNode, Link connection) {
        assert (!outputSlotNode.isInputSlot() && inputSlotNode.isInputSlot());
        return new ClusterConnection(inputSlotNode.getInputSlot(), outputSlotNode.getOutputSlot(), connection);
    }

    public Port getTo() {
        return this.inputSlot;
    }

    public Port getFrom() {
        return this.outputSlot;
    }

    public void setControlPoints(List<Point> p) {
        this.controlPoints = p;
    }

    public List<Point> getControlPoints() {
        return this.controlPoints;
    }

    public boolean isVIP() {
        return this.connection.isVIP();
    }
}

