/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.hierarchicallayout;

import java.awt.Dimension;
import java.awt.Point;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.graalvm.visualizer.layout.Cluster;
import org.graalvm.visualizer.layout.Link;
import org.graalvm.visualizer.layout.Port;
import org.graalvm.visualizer.layout.Vertex;

public class ClusterNode
implements Vertex {
    public static final int BORDER = 20;
    private Cluster cluster;
    private Port inputSlot;
    private Port outputSlot;
    private final Set<Vertex> subNodes = new HashSet<Vertex>();
    private Dimension size;
    private Point position;
    private final Set<Link> subEdges = new HashSet<Link>();
    private boolean root;
    private final String name;
    boolean visible;

    public ClusterNode(Cluster cluster, String name) {
        this.cluster = cluster;
        this.position = new Point(-20, -20);
        this.name = name;
        this.visible = cluster.isVisible();
    }

    public void addSubNode(Vertex v) {
        this.subNodes.add(v);
        this.visible = this.visible || v.isVisible();
    }

    public void addSubEdge(Link l) {
        this.subEdges.add(l);
    }

    public Set<Link> getSubEdges() {
        return Collections.unmodifiableSet(this.subEdges);
    }

    public void updateSize(Dimension graphSize) {
        if (this.visible && graphSize.width > 0 && graphSize.height > 0) {
            this.size = new Dimension(graphSize.width + 40, graphSize.height + 40);
        } else {
            assert ((this.subNodes.isEmpty() || this.subNodes.stream().allMatch(n -> !n.isVisible())) && !this.visible);
            this.size = new Dimension(60, 60);
        }
        final ClusterNode widget = this;
        this.inputSlot = new Port(){

            public Point getRelativePosition() {
                return new Point(ClusterNode.this.size.width / 2, 0);
            }

            public Vertex getVertex() {
                return widget;
            }
        };
        this.outputSlot = new Port(){

            public Point getRelativePosition() {
                return new Point(ClusterNode.this.size.width / 2, 0);
            }

            public Vertex getVertex() {
                return widget;
            }
        };
    }

    public Port getInputSlot() {
        return this.inputSlot;
    }

    public Port getOutputSlot() {
        return this.outputSlot;
    }

    public Dimension getSize() {
        return this.size;
    }

    public Point getPosition() {
        return this.position;
    }

    public void setPosition(Point pos) {
        int dx = pos.x - this.position.x;
        int dy = pos.y - this.position.y;
        this.position = pos;
        for (Vertex n : this.subNodes) {
            n.getPosition().translate(dx, dy);
        }
        HashSet edgesPoints = new HashSet();
        for (Link e : this.subEdges) {
            edgesPoints.addAll(e.getControlPoints());
        }
        for (Point p : edgesPoints) {
            if (p == null) continue;
            p.translate(dx, dy);
        }
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster c) {
        this.cluster = c;
    }

    public void setRoot(boolean b) {
        this.root = b;
    }

    public boolean isRoot() {
        return this.root;
    }

    public int compareTo(Vertex o) {
        return this.toString().compareTo(o.toString());
    }

    public String toString() {
        return this.name;
    }

    public Set<? extends Vertex> getSubNodes() {
        return this.subNodes;
    }

    public boolean isVisible() {
        return this.visible;
    }
}

