/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.hierarchicallayout;

import java.awt.Dimension;
import java.awt.Point;
import org.graalvm.visualizer.hierarchicallayout.ClusterConnection;
import org.graalvm.visualizer.hierarchicallayout.ClusterNode;
import org.graalvm.visualizer.layout.Cluster;
import org.graalvm.visualizer.layout.Port;
import org.graalvm.visualizer.layout.Vertex;

public class ClusterSlotNode
implements Vertex {
    private static final Dimension ZERO_DIMENSION = new Dimension();
    private Point position;
    private final Port inputSlot = new ClusterSlotNodePort();
    private final Port outputSlot = new ClusterSlotNodePort();
    private final ClusterNode blockNode;
    private final String id;
    private final boolean isInputPort;
    private ClusterConnection conn;

    private ClusterSlotNode(boolean isInputSlot, ClusterNode n, String id) {
        this.blockNode = n;
        this.id = id;
        this.isInputPort = isInputSlot;
        n.addSubNode(this);
    }

    public static ClusterSlotNode makeInputSlotNode(ClusterNode n, String id) {
        assert (n != null);
        return new ClusterSlotNode(true, n, id);
    }

    public static ClusterSlotNode makeOutputSlotNode(ClusterNode n, String id) {
        assert (n != null);
        return new ClusterSlotNode(false, n, id);
    }

    public boolean isInputSlot() {
        return this.isInputPort;
    }

    public void setConnection(ClusterConnection c) {
        this.conn = c;
    }

    public ClusterConnection getConnection() {
        return this.conn;
    }

    public boolean isRoot() {
        return this.isInputPort;
    }

    public String toString() {
        return this.id;
    }

    public Dimension getSize() {
        return ZERO_DIMENSION;
    }

    public void setPosition(Point p) {
        this.position = p;
    }

    public Point getPosition() {
        return this.position;
    }

    public Port getInputSlot() {
        return this.inputSlot;
    }

    public Port getOutputSlot() {
        return this.outputSlot;
    }

    public Cluster getCluster() {
        return this.blockNode.getCluster();
    }

    public int compareTo(Vertex o) {
        return this.toString().compareTo(o.toString());
    }

    public boolean isVisible() {
        return this.blockNode.isVisible();
    }

    private class ClusterSlotNodePort
    implements Port {
        public Vertex getVertex() {
            return this == ClusterSlotNode.this.inputSlot == ClusterSlotNode.this.isInputPort ? ClusterSlotNode.this.blockNode : ClusterSlotNode.this;
        }

        public Point getRelativePosition() {
            return this == ClusterSlotNode.this.inputSlot == ClusterSlotNode.this.isInputPort ? new Point(ClusterSlotNode.this.getPosition().x - ClusterSlotNode.this.blockNode.getPosition().x, 0) : new Point();
        }

        public String toString() {
            return (this == ClusterSlotNode.this.inputSlot ? "InPort of " : "OutPort of ") + ClusterSlotNode.this.id;
        }
    }
}

