/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.hierarchicallayout;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntUnaryOperator;
import java.util.logging.Logger;
import org.graalvm.visualizer.hierarchicallayout.ClusterNode;
import org.graalvm.visualizer.hierarchicallayout.ClusterSlotNode;
import org.graalvm.visualizer.layout.LayoutGraph;
import org.graalvm.visualizer.layout.LayoutManager;
import org.graalvm.visualizer.layout.Link;
import org.graalvm.visualizer.layout.Port;
import org.graalvm.visualizer.layout.Vertex;
import org.graalvm.visualizer.settings.layout.LayoutSettings;

public class HierarchicalLayoutManager
implements LayoutManager {
    private static final Logger LOG = Logger.getLogger(HierarchicalLayoutManager.class.getName());
    public static final boolean TRACE_DEFAULT = false;
    public static final boolean CHECK = false;
    public static final int SWEEP_ITERATIONS = 1;
    public static final int CROSSING_ITERATIONS = 2;
    public static final int DUMMY_HEIGHT = 1;
    public static final int DUMMY_WIDTH = 1;
    public static final int X_OFFSET = 8;
    public static final int LAYER_OFFSET = 8;
    public static final int MAX_LAYER_LENGTH = -1;
    public static final int VIP_BONUS = 10;
    private final AtomicBoolean cancelled;
    private final LayoutSettings.LayoutSettingBean settings;
    private boolean trace = false;
    private boolean bothSort;
    private boolean centerCrossingX;
    private boolean centerSimpleNodes;
    private boolean crossingSort;
    private boolean crossPositionDuring;
    private boolean crossReduceRouting;
    private boolean crossResetXFromMiddle;
    private boolean crossResetXFromNode;
    private boolean decreaseLayerWidthDeviation;
    private boolean decreaseLayerWidthDeviationQuick;
    private boolean decreaseLayerWidthDeviationUp;
    private boolean dummyFirstSort;
    private boolean edgeBending;
    private boolean irrelevantLayoutCode;
    private boolean lastDownSweep;
    private boolean lastUpCrossingSweep;
    private boolean meanNotMedian;
    private boolean noCrossingLayerReassign;
    private boolean noDummyLongEdges;
    private boolean noVip;
    private boolean optimalUpVip;
    private boolean properCrossingClosestNode;
    private boolean reverseSort;
    private boolean spanByAngle;
    private boolean squashPosition;
    private boolean standalones;
    private boolean unreverseVips;
    private boolean unknownCrossingNumber;
    private int xAssignSweepCount;
    private int crossingSweepCount;
    private int minEdgeAngle;
    private float crossFactor;
    private final Combine combine;
    private final int dummyWidth;
    private final int offset;
    private int maxLayerLength;
    private final HashSet<Link> reversedLinks;
    private final HashSet<LayoutEdge> longEdges;
    private final ArrayList<LayoutNode> nodes;
    private final HashSet<LayoutNode> standAlones;
    private final HashMap<Vertex, LayoutNode> vertexToLayoutNode;
    private final HashMap<Link, List<Point>> reversedLinkStartPoints;
    private final HashMap<Link, List<Point>> reversedLinkEndPoints;
    private LayoutGraph graph;
    private LayoutLayer[] layers;
    private int layerCount;
    private final boolean isDefaultLayout;
    private final boolean isDummyCrossing;
    private final boolean isCrossingByConnDiff;
    private final boolean isDelayDanglingNodes;
    private final boolean isDrawLongEdges;
    static final ThreadLocal<Integer> indent = ThreadLocal.withInitial(() -> 0);
    private static final Comparator<LayoutNode> NODE_PROCESSING_BOTH_COMPARATOR = (n1, n2) -> {
        int part = HierarchicalLayoutManager.nodeBothVipCompare(n1, n2);
        if (part != 0) {
            return part;
        }
        part = HierarchicalLayoutManager.compareNodeDummy(n1, n2);
        if (part != 0) {
            return part;
        }
        return HierarchicalLayoutManager.compareNodeBoth(n1, n2);
    };
    private static final Comparator<LayoutNode> NODE_PROCESSING_BOTH_REVERSE_COMPARATOR = (n1, n2) -> {
        int part = HierarchicalLayoutManager.nodeBothVipCompare(n1, n2);
        if (part != 0) {
            return part;
        }
        part = HierarchicalLayoutManager.compareNodeDummy(n1, n2);
        if (part != 0) {
            return part;
        }
        return HierarchicalLayoutManager.compareNodeBothReverse(n1, n2);
    };
    private static final Comparator<LayoutNode> NODE_PROCESSING_DOWN_COMPARATOR = (n1, n2) -> {
        int part = HierarchicalLayoutManager.compareNodeDownVIP(n1, n2);
        if (part != 0) {
            return part;
        }
        part = HierarchicalLayoutManager.compareNodeDummy(n1, n2);
        if (part != 0) {
            return part;
        }
        return HierarchicalLayoutManager.compareNodeDown(n1, n2);
    };
    private static final Comparator<LayoutNode> NODE_PROCESSING_DOWN_REVERSE_COMPARATOR = (n1, n2) -> {
        int part = HierarchicalLayoutManager.compareNodeDownVIP(n1, n2);
        if (part != 0) {
            return part;
        }
        part = HierarchicalLayoutManager.compareNodeDummy(n1, n2);
        if (part != 0) {
            return part;
        }
        return HierarchicalLayoutManager.compareNodeDownReverse(n1, n2);
    };
    private static final Comparator<LayoutNode> NODE_PROCESSING_UP_COMPARATOR = (n1, n2) -> {
        int part = HierarchicalLayoutManager.compareNodeUpVIP(n1, n2);
        if (part != 0) {
            return part;
        }
        part = HierarchicalLayoutManager.compareNodeDummy(n1, n2);
        if (part != 0) {
            return part;
        }
        return HierarchicalLayoutManager.compareNodeUp(n1, n2);
    };
    private static final Comparator<LayoutNode> NODE_PROCESSING_UP_REVERSE_COMPARATOR = (n1, n2) -> {
        int part = HierarchicalLayoutManager.compareNodeUpVIP(n1, n2);
        if (part != 0) {
            return part;
        }
        part = HierarchicalLayoutManager.compareNodeDummy(n1, n2);
        if (part != 0) {
            return part;
        }
        return HierarchicalLayoutManager.compareNodeUpReverse(n1, n2);
    };
    private static final Comparator<LayoutNode> NODE_PROCESSING_DUMMY_BOTH_COMPARATOR = (n1, n2) -> {
        int part = HierarchicalLayoutManager.nodeBothVipCompare(n1, n2);
        if (part != 0) {
            return part;
        }
        part = HierarchicalLayoutManager.compareNodeRDummy(n1, n2);
        if (part != 0) {
            return part;
        }
        return HierarchicalLayoutManager.compareNodeBoth(n1, n2);
    };
    private static final Comparator<LayoutNode> NODE_PROCESSING_DUMMY_BOTH_REVERSE_COMPARATOR = (n1, n2) -> {
        int part = HierarchicalLayoutManager.nodeBothVipCompare(n1, n2);
        if (part != 0) {
            return part;
        }
        part = HierarchicalLayoutManager.compareNodeRDummy(n1, n2);
        if (part != 0) {
            return part;
        }
        return HierarchicalLayoutManager.compareNodeBothReverse(n1, n2);
    };
    private static final Comparator<LayoutNode> NODE_PROCESSING_DUMMY_DOWN_COMPARATOR = (n1, n2) -> {
        int part = HierarchicalLayoutManager.compareNodeDownVIP(n1, n2);
        if (part != 0) {
            return part;
        }
        part = HierarchicalLayoutManager.compareNodeRDummy(n1, n2);
        if (part != 0) {
            return part;
        }
        return HierarchicalLayoutManager.compareNodeDown(n1, n2);
    };
    private static final Comparator<LayoutNode> NODE_PROCESSING_DUMMY_DOWN_REVERSE_COMPARATOR = (n1, n2) -> {
        int part = HierarchicalLayoutManager.compareNodeDownVIP(n1, n2);
        if (part != 0) {
            return part;
        }
        part = HierarchicalLayoutManager.compareNodeRDummy(n1, n2);
        if (part != 0) {
            return part;
        }
        return HierarchicalLayoutManager.compareNodeDownReverse(n1, n2);
    };
    private static final Comparator<LayoutNode> NODE_PROCESSING_DUMMY_UP_COMPARATOR = (n1, n2) -> {
        int part = HierarchicalLayoutManager.compareNodeUpVIP(n1, n2);
        if (part != 0) {
            return part;
        }
        part = HierarchicalLayoutManager.compareNodeRDummy(n1, n2);
        if (part != 0) {
            return part;
        }
        return HierarchicalLayoutManager.compareNodeUp(n1, n2);
    };
    private static final Comparator<LayoutNode> NODE_PROCESSING_DUMMY_UP_REVERSE_COMPARATOR = (n1, n2) -> {
        int part = HierarchicalLayoutManager.compareNodeUpVIP(n1, n2);
        if (part != 0) {
            return part;
        }
        part = HierarchicalLayoutManager.compareNodeRDummy(n1, n2);
        if (part != 0) {
            return part;
        }
        return HierarchicalLayoutManager.compareNodeUpReverse(n1, n2);
    };
    private static final Comparator<LayoutNode> CROSSING_NODE_COMPARATOR = (n1, n2) -> Float.compare(n1.crossingNumber, n2.crossingNumber);
    private static final Comparator<LayoutNode> DOWN_CROSSING_COMPARATOR = Comparator.comparingInt(n -> n.succs.size());
    private static final Comparator<LayoutNode> UP_CROSSING_COMPARATOR = Comparator.comparingInt(n -> n.preds.size());
    private static final Comparator<LayoutNode> DANGLING_UP_NODE_COMPARATOR = (n1, n2) -> {
        int ret = Integer.compare(n1.layer, n2.layer);
        if (ret != 0) {
            return ret;
        }
        int part = HierarchicalLayoutManager.compareNodeUpVIP(n1, n2);
        if (part != 0) {
            return part;
        }
        part = HierarchicalLayoutManager.compareNodeDummy(n1, n2);
        if (part != 0) {
            return part;
        }
        ret = Integer.compare(n1.succs.size(), n2.succs.size());
        if (ret != 0) {
            return ret;
        }
        return n1.pos - n2.pos;
    };
    private static final Comparator<LayoutNode> DANGLING_DOWN_NODE_COMPARATOR = (n1, n2) -> {
        int ret = Integer.compare(n2.layer, n1.layer);
        if (ret != 0) {
            return ret;
        }
        ret = NODE_PROCESSING_DOWN_COMPARATOR.compare((LayoutNode)n1, (LayoutNode)n2);
        if (ret != 0) {
            return ret;
        }
        return n1.pos - n2.pos;
    };
    private static final Comparator<LayoutEdge> LAYER_COMPARATOR = Comparator.comparingInt(e -> e.to.layer);

    public void setTrace(boolean t) {
        this.trace = t;
    }

    public boolean cancel() {
        this.cancelled.set(true);
        return true;
    }

    private void traceEnd(long start, Class<?> theClass) {
        if (this.trace) {
            for (int i = 0; i < indent.get(); ++i) {
                System.out.print(' ');
            }
            System.out.println("Timing for " + theClass.getName() + " is " + (System.currentTimeMillis() - start));
        }
    }

    private long traceBegin(Class<?> theClass) {
        long start = 0L;
        if (this.trace) {
            for (int i = 0; i < indent.get(); ++i) {
                System.out.print(' ');
            }
            System.out.println("Starting part " + theClass.getName());
            start = System.currentTimeMillis();
        }
        return start;
    }

    public HierarchicalLayoutManager(Combine b, LayoutSettings.LayoutSettingBean setting) {
        this.isDefaultLayout = (Boolean)setting.get(Boolean.class, "DEFAULT_LAYOUT");
        this.isDummyCrossing = (Boolean)setting.get(Boolean.class, "DUMMY_CROSSING");
        this.isCrossingByConnDiff = (Boolean)setting.get(Boolean.class, "CROSS_BY_CONN_DIFF");
        this.isDelayDanglingNodes = (Boolean)setting.get(Boolean.class, "DELAY_DANGLING_NODES");
        this.isDrawLongEdges = (Boolean)setting.get(Boolean.class, "DRAW_LONG_EDGES");
        this.combine = b;
        this.dummyWidth = this.isDefaultLayout ? 1 : (Integer)setting.get(Integer.class, "DUMMY_WIDTH");
        this.settings = setting;
        this.maxLayerLength = -1;
        this.offset = 8 + this.dummyWidth;
        this.vertexToLayoutNode = new HashMap();
        this.reversedLinks = new HashSet();
        this.reversedLinkStartPoints = new HashMap();
        this.reversedLinkEndPoints = new HashMap();
        this.nodes = new ArrayList();
        this.standAlones = new HashSet();
        this.longEdges = new HashSet();
        this.cancelled = new AtomicBoolean(false);
    }

    private void initSettings(LayoutSettings.LayoutSettingBean setting) {
        this.bothSort = (Boolean)setting.get(Boolean.class, "BOTH_SORT");
        this.reverseSort = (Boolean)setting.get(Boolean.class, "REVERSE_SORT");
        this.dummyFirstSort = (Boolean)setting.get(Boolean.class, "DUMMY_FIRST_SORT");
        this.lastDownSweep = (Boolean)setting.get(Boolean.class, "LAST_DOWN_SWEEP");
        this.optimalUpVip = (Boolean)setting.get(Boolean.class, "OPTIMAL_UP_VIP");
        this.squashPosition = (Boolean)setting.get(Boolean.class, "SQUASH_POSITION");
        this.centerSimpleNodes = (Boolean)setting.get(Boolean.class, "CENTER_SIMPLE_NODES");
        this.meanNotMedian = (Boolean)setting.get(Boolean.class, "MEAN_MEDIAN");
        this.crossingSort = (Boolean)setting.get(Boolean.class, "CROSSING_SORT");
        this.noCrossingLayerReassign = (Boolean)setting.get(Boolean.class, "NO_CROSSING_LAYER_REASSIGN");
        this.lastUpCrossingSweep = (Boolean)setting.get(Boolean.class, "LAST_UP_CROSSING_SWEEP");
        this.irrelevantLayoutCode = (Boolean)setting.get(Boolean.class, "IRRELEVANT_LAYOUT_CODE");
        this.centerCrossingX = (Boolean)setting.get(Boolean.class, "CENTER_CROSSING_X");
        this.crossResetXFromNode = (Boolean)setting.get(Boolean.class, "CROSS_RESET_X_FROM_NODE");
        this.crossResetXFromMiddle = (Boolean)setting.get(Boolean.class, "CROSS_RESET_X_FROM_MIDDLE");
        this.spanByAngle = (Boolean)setting.get(Boolean.class, "SPAN_BY_ANGLE");
        this.noDummyLongEdges = (Boolean)setting.get(Boolean.class, "NO_DUMMY_LONG_EDGES");
        this.standalones = (Boolean)setting.get(Boolean.class, "STANDALONES");
        this.edgeBending = (Boolean)setting.get(Boolean.class, "EDGE_BENDING");
        this.decreaseLayerWidthDeviation = (Boolean)setting.get(Boolean.class, "DECREASE_LAYER_WIDTH_DEVIATION");
        this.decreaseLayerWidthDeviationQuick = (Boolean)setting.get(Boolean.class, "DECREASE_LAYER_WIDTH_DEVIATION_QUICK");
        this.decreaseLayerWidthDeviationUp = (Boolean)setting.get(Boolean.class, "DECREASE_LAYER_WIDTH_DEVIATION_UP");
        this.unreverseVips = (Boolean)setting.get(Boolean.class, "UNREVERSE_VIPS");
        this.noVip = (Boolean)setting.get(Boolean.class, "NO_VIP");
        this.crossReduceRouting = (Boolean)setting.get(Boolean.class, "CROSS_REDUCE_ROUTING");
        this.crossPositionDuring = (Boolean)setting.get(Boolean.class, "CROSS_POSITION_DURING");
        this.properCrossingClosestNode = (Boolean)setting.get(Boolean.class, "PROPER_CROSSING_CLOSEST_NODE");
        this.unknownCrossingNumber = (Boolean)setting.get(Boolean.class, "UNKNOWN_CROSSING_NUMBER");
        this.xAssignSweepCount = (Integer)setting.get(Integer.class, "X_ASSIGN_SWEEP_COUNT");
        this.crossingSweepCount = (Integer)setting.get(Integer.class, "CROSSING_SWEEP_COUNT");
        this.minEdgeAngle = (Integer)setting.get(Integer.class, "MIN_EDGE_ANGLE");
        this.crossFactor = ((Float)setting.get(Float.class, "CROSS_FACTOR")).floatValue();
    }

    public int getMaxLayerLength() {
        return this.maxLayerLength;
    }

    public void setMaxLayerLength(int v) {
        this.maxLayerLength = v;
    }

    private void cleanup() {
        this.vertexToLayoutNode.clear();
        this.reversedLinks.clear();
        this.reversedLinkStartPoints.clear();
        this.reversedLinkEndPoints.clear();
        this.nodes.clear();
        this.longEdges.clear();
        this.initSettings(this.settings);
    }

    public void doLayout(LayoutGraph graph) {
        this.graph = graph;
        this.cleanup();
        long start = this.traceBegin(this.getClass());
        new BuildDatastructure().start();
        if (this.cancelled.get()) {
            return;
        }
        new ReverseEdges().start();
        if (this.cancelled.get()) {
            return;
        }
        new AssignLayers().start();
        if (this.cancelled.get()) {
            return;
        }
        new CreateDummyNodes().start();
        if (this.cancelled.get()) {
            return;
        }
        new CrossingReduction().start();
        if (this.cancelled.get()) {
            return;
        }
        new AssignXCoordinates().start();
        if (this.cancelled.get()) {
            return;
        }
        new AssignYCoordinates().start();
        if (this.cancelled.get()) {
            return;
        }
        new WriteResult().start();
        this.traceEnd(start, this.getClass());
    }

    private void resolveInsOuts() {
        for (LayoutNode node : this.nodes) {
            int pos;
            TreeSet<Integer> reversedDown = new TreeSet<Integer>();
            for (Object e : node.succs) {
                if (!this.reversedLinks.contains(((LayoutEdge)e).link)) continue;
                reversedDown.add(((LayoutEdge)e).relativeFrom);
            }
            TreeSet<Object> reversedUp = reversedDown.isEmpty() ? new TreeSet(Collections.reverseOrder()) : new TreeSet();
            for (LayoutEdge e : node.preds) {
                if (!this.reversedLinks.contains(e.link)) continue;
                reversedUp.add(e.relativeTo);
            }
            int cur = -reversedDown.size() * this.offset;
            int curWidth = node.width + reversedDown.size() * this.offset;
            Iterator iterator = reversedDown.iterator();
            while (iterator.hasNext()) {
                Object e22;
                pos = (Integer)iterator.next();
                ArrayList<LayoutEdge> reversedSuccs = new ArrayList<LayoutEdge>();
                for (Object e22 : node.succs) {
                    if (((LayoutEdge)e22).relativeFrom != pos || !this.reversedLinks.contains(((LayoutEdge)e22).link)) continue;
                    reversedSuccs.add((LayoutEdge)e22);
                    ((LayoutEdge)e22).relativeFrom = curWidth;
                }
                ArrayList<Point> startPoints = new ArrayList<Point>();
                startPoints.add(new Point(curWidth, cur));
                startPoints.add(new Point(pos, cur));
                startPoints.add(new Point(pos, cur));
                startPoints.add(new Point(pos, 0));
                e22 = reversedSuccs.iterator();
                while (e22.hasNext()) {
                    LayoutEdge layoutEdge = (LayoutEdge)e22.next();
                    this.reversedLinkStartPoints.put(layoutEdge.link, (List<Point>)startPoints);
                }
                cur += this.offset;
                node.yOffset += this.offset;
                curWidth -= this.offset;
            }
            node.width += reversedDown.size() * this.offset;
            cur = reversedDown.isEmpty() ? this.offset : -this.offset;
            iterator = reversedUp.iterator();
            while (iterator.hasNext()) {
                pos = (Integer)iterator.next();
                ArrayList<LayoutEdge> reversedPreds = new ArrayList<LayoutEdge>();
                for (LayoutEdge e : node.preds) {
                    if (e.relativeTo != pos || !this.reversedLinks.contains(e.link)) continue;
                    e.relativeTo = reversedDown.isEmpty() ? node.width + this.offset : cur;
                    reversedPreds.add(e);
                }
                node.bottomYOffset += this.offset;
                ArrayList<Point> endPoints = new ArrayList<Point>();
                node.width += this.offset;
                if (reversedDown.isEmpty()) {
                    endPoints.add(new Point(node.width, node.height + node.bottomYOffset));
                } else {
                    endPoints.add(new Point(cur, node.height + node.bottomYOffset));
                    cur -= this.offset;
                }
                endPoints.add(new Point(pos, node.height + node.bottomYOffset));
                endPoints.add(new Point(pos, node.height + node.bottomYOffset));
                endPoints.add(new Point(pos, node.height));
                for (LayoutEdge layoutEdge : reversedPreds) {
                    this.reversedLinkEndPoints.put(layoutEdge.link, endPoints);
                }
            }
            if (reversedDown.isEmpty()) continue;
            node.xOffset = reversedUp.size() * this.offset;
        }
    }

    private void reverseEdge(LayoutEdge e) {
        assert (!this.reversedLinks.contains(e.link));
        this.reversedLinks.add(e.link);
        LayoutNode oldFrom = e.from;
        LayoutNode oldTo = e.to;
        int oldRelativeFrom = e.relativeFrom;
        int oldRelativeTo = e.relativeTo;
        e.from = oldTo;
        e.to = oldFrom;
        e.relativeFrom = oldRelativeTo;
        e.relativeTo = oldRelativeFrom;
        oldFrom.succs.remove(e);
        oldFrom.preds.add(e);
        oldTo.preds.remove(e);
        oldTo.succs.add(e);
    }

    private static int nodeBothVipCompare(LayoutNode n1, LayoutNode n2) {
        int n1VIP = n1.getPredsVips() + n1.getSuccsVips();
        int n2VIP = n2.getPredsVips() + n2.getSuccsVips();
        return Integer.compare(n2VIP, n1VIP);
    }

    private static int compareNodeDownVIP(LayoutNode n1, LayoutNode n2) {
        int n1VIP = n1.getPredsVips();
        int n2VIP = n2.getPredsVips();
        return Integer.compare(n2VIP, n1VIP);
    }

    private static int compareNodeUpVIP(LayoutNode n1, LayoutNode n2) {
        int n1VIP = n1.getSuccsVips();
        int n2VIP = n2.getSuccsVips();
        return Integer.compare(n2VIP, n1VIP);
    }

    private static int compareNodeDummy(LayoutNode n1, LayoutNode n2) {
        if (n1.isDummy()) {
            return n2.isDummy() ? 0 : 1;
        }
        return n2.isDummy() ? -1 : 0;
    }

    private static int compareNodeRDummy(LayoutNode n1, LayoutNode n2) {
        if (n1.isDummy()) {
            return n2.isDummy() ? 0 : -1;
        }
        return n2.isDummy() ? 1 : 0;
    }

    private static int compareNodeBoth(LayoutNode n1, LayoutNode n2) {
        return Integer.compare(n1.preds.size() + n1.succs.size(), n2.preds.size() + n2.succs.size());
    }

    private static int compareNodeBothReverse(LayoutNode n1, LayoutNode n2) {
        return Integer.compare(n2.preds.size() + n2.succs.size(), n1.preds.size() + n1.succs.size());
    }

    private static int compareNodeDown(LayoutNode n1, LayoutNode n2) {
        return Integer.compare(n1.preds.size(), n2.preds.size());
    }

    private static int compareNodeDownReverse(LayoutNode n1, LayoutNode n2) {
        return Integer.compare(n2.preds.size(), n1.preds.size());
    }

    private static int compareNodeUp(LayoutNode n1, LayoutNode n2) {
        return Integer.compare(n1.succs.size(), n2.succs.size());
    }

    private static int compareNodeUpReverse(LayoutNode n1, LayoutNode n2) {
        return Integer.compare(n2.succs.size(), n1.succs.size());
    }

    private static int compareLinkNoVip(Link l1, Link l2) {
        Port l1From = l1.getFrom();
        Port l2From = l2.getFrom();
        int result = l1From.getVertex().compareTo((Object)l2From.getVertex());
        if (result != 0) {
            return result;
        }
        Port l1To = l1.getTo();
        Port l2To = l2.getTo();
        result = l1To.getVertex().compareTo((Object)l2To.getVertex());
        if (result != 0) {
            return result;
        }
        result = l1From.getRelativePosition().x - l2From.getRelativePosition().x;
        if (result != 0) {
            return result;
        }
        result = l1To.getRelativePosition().x - l2To.getRelativePosition().x;
        return result;
    }

    private static int compareLink(Link l1, Link l2) {
        if (l1.isVIP() && !l2.isVIP()) {
            return -1;
        }
        if (!l1.isVIP() && l2.isVIP()) {
            return 1;
        }
        return HierarchicalLayoutManager.compareLinkNoVip(l1, l2);
    }

    public void doRouting(LayoutGraph graph) {
        this.graph = graph;
        this.cleanup();
        new BuildDatastructure().start();
        if (this.cancelled.get()) {
            return;
        }
        new ResolvePrevious().start();
        if (this.cancelled.get()) {
            return;
        }
        if (this.crossReduceRouting) {
            new CrossingReduction(true).start();
        }
        if (this.cancelled.get()) {
            return;
        }
        new AssignXCoordinates().start();
        if (this.cancelled.get()) {
            return;
        }
        new AssignYCoordinates().start();
        if (this.cancelled.get()) {
            return;
        }
        new WriteResult().start();
    }

    public static enum Combine {
        NONE,
        SAME_INPUTS,
        SAME_OUTPUTS;

    }

    private class BuildDatastructure
    extends AlgorithmPart {
        private BuildDatastructure() {
        }

        @Override
        protected void run() {
            boolean VIP;
            for (Vertex v : HierarchicalLayoutManager.this.graph.getVertices()) {
                assert (v.isVisible()) : "Invisible nodes aren't permited in HierarchicalLayout.";
                LayoutNode node = new LayoutNode(v);
                HierarchicalLayoutManager.this.nodes.add(node);
                HierarchicalLayoutManager.this.vertexToLayoutNode.put(v, node);
            }
            Link[] links = HierarchicalLayoutManager.this.graph.getLinks().toArray(new Link[0]);
            boolean bl = VIP = !HierarchicalLayoutManager.this.noVip;
            if (VIP) {
                Arrays.parallelSort(links, HierarchicalLayoutManager::compareLink);
            } else {
                Arrays.parallelSort(links, HierarchicalLayoutManager::compareLinkNoVip);
            }
            for (Link l : links) {
                LayoutEdge edge = new LayoutEdge(HierarchicalLayoutManager.this.vertexToLayoutNode.get(l.getFrom().getVertex()), HierarchicalLayoutManager.this.vertexToLayoutNode.get(l.getTo().getVertex()), l.getFrom().getRelativePosition().x, l.getTo().getRelativePosition().x, l, VIP && l.isVIP());
                edge.from.succs.add(edge);
                edge.to.preds.add(edge);
            }
        }

        @Override
        public void postCheck() {
            assert (HierarchicalLayoutManager.this.vertexToLayoutNode.keySet().size() == HierarchicalLayoutManager.this.nodes.size());
            assert (HierarchicalLayoutManager.this.nodes.size() == HierarchicalLayoutManager.this.graph.getVertices().size());
            for (Vertex v : HierarchicalLayoutManager.this.graph.getVertices()) {
                LayoutNode node = HierarchicalLayoutManager.this.vertexToLayoutNode.get(v);
                assert (node != null);
                for (LayoutEdge e : node.succs) {
                    assert (e.from == node);
                }
                for (LayoutEdge e : node.preds) {
                    assert (e.to == node);
                }
            }
        }
    }

    private class ReverseEdges
    extends AlgorithmPart {
        private HashSet<LayoutNode> visited;
        private HashSet<LayoutNode> active;

        private ReverseEdges() {
        }

        @Override
        protected void run() {
            for (LayoutNode node : HierarchicalLayoutManager.this.nodes) {
                ArrayList<LayoutEdge> succs = new ArrayList<LayoutEdge>(node.succs);
                for (LayoutEdge e : succs) {
                    assert (e.from == node);
                    if (e.to != node) continue;
                    node.succs.remove(e);
                    node.preds.remove(e);
                }
            }
            if (HierarchicalLayoutManager.this.standalones) {
                Iterator<LayoutNode> it = HierarchicalLayoutManager.this.nodes.iterator();
                while (it.hasNext()) {
                    LayoutNode n = it.next();
                    if (!n.succs.isEmpty() || !n.preds.isEmpty()) continue;
                    it.remove();
                    HierarchicalLayoutManager.this.standAlones.add(n);
                }
            }
            for (LayoutNode node : HierarchicalLayoutManager.this.nodes) {
                if (!node.vertex.isRoot()) continue;
                boolean ok = true;
                for (LayoutEdge e : node.preds) {
                    if (!e.from.vertex.isRoot()) continue;
                    ok = false;
                    break;
                }
                if (!ok) continue;
                this.reverseAllInputs(node);
            }
            this.visited = new HashSet(HierarchicalLayoutManager.this.nodes.size());
            this.active = new HashSet();
            this.DFS();
            HierarchicalLayoutManager.this.resolveInsOuts();
        }

        private void DFS(LayoutNode startNode, boolean vip) {
            if (this.visited.contains(startNode)) {
                return;
            }
            boolean sortSuccs = vip && !HierarchicalLayoutManager.this.isDefaultLayout && HierarchicalLayoutManager.this.unreverseVips;
            Stack<LayoutNode> stack = new Stack<LayoutNode>();
            stack.push(startNode);
            while (!stack.empty()) {
                LayoutNode node = (LayoutNode)stack.pop();
                if (this.visited.contains(node)) {
                    this.active.remove(node);
                    continue;
                }
                stack.push(node);
                this.visited.add(node);
                this.active.add(node);
                ArrayList<LayoutEdge> succs = new ArrayList<LayoutEdge>(node.succs);
                if (sortSuccs) {
                    succs.sort((e1, e2) -> Integer.compare(e1.vip ? e2.to.preds.size() : 0, e2.vip ? e1.to.preds.size() : 0));
                }
                for (LayoutEdge e : succs) {
                    if (this.active.contains(e.to)) {
                        assert (this.visited.contains(e.to));
                        HierarchicalLayoutManager.this.reverseEdge(e);
                        continue;
                    }
                    if (this.visited.contains(e.to)) continue;
                    stack.push(e.to);
                }
            }
        }

        private void DFS() {
            block5: {
                block4: {
                    if (!HierarchicalLayoutManager.this.isDefaultLayout && HierarchicalLayoutManager.this.unreverseVips) break block4;
                    for (LayoutNode n2 : HierarchicalLayoutManager.this.nodes) {
                        this.DFS(n2, false);
                    }
                    break block5;
                }
                for (LayoutNode node : HierarchicalLayoutManager.this.nodes) {
                    if (node.preds.getVips() != 0 || node.succs.getVips() == 0) continue;
                    this.DFS(node, true);
                }
                if (this.visited.size() >= HierarchicalLayoutManager.this.nodes.size()) break block5;
                ArrayList<LayoutNode> toSort = new ArrayList<LayoutNode>();
                for (LayoutNode n3 : HierarchicalLayoutManager.this.nodes) {
                    if (this.visited.contains(n3)) continue;
                    toSort.add(n3);
                }
                toSort.sort(Comparator.comparingInt(n -> n.preds.size()));
                for (LayoutNode n3 : toSort) {
                    this.DFS(n3, false);
                }
            }
        }

        private void reverseAllInputs(LayoutNode node) {
            for (LayoutEdge e : node.preds) {
                assert (!HierarchicalLayoutManager.this.reversedLinks.contains(e.link));
                HierarchicalLayoutManager.this.reversedLinks.add(e.link);
                node.succs.add(e);
                e.from.preds.add(e);
                e.from.succs.remove(e);
                int oldRelativeFrom = e.relativeFrom;
                int oldRelativeTo = e.relativeTo;
                e.to = e.from;
                e.from = node;
                e.relativeFrom = oldRelativeTo;
                e.relativeTo = oldRelativeFrom;
            }
            node.preds.clear();
        }

        @Override
        public void postCheck() {
            for (LayoutNode n : HierarchicalLayoutManager.this.nodes) {
                HashSet<LayoutNode> curVisited = new HashSet<LayoutNode>();
                LinkedList<LayoutNode> queue = new LinkedList<LayoutNode>();
                for (LayoutEdge e : n.succs) {
                    LayoutNode s = e.to;
                    queue.add(s);
                    curVisited.add(s);
                }
                while (!queue.isEmpty()) {
                    LayoutNode curNode = (LayoutNode)queue.remove();
                    for (LayoutEdge e : curNode.succs) {
                        assert (e.to != n);
                        if (curVisited.contains(e.to)) continue;
                        queue.add(e.to);
                        curVisited.add(e.to);
                    }
                }
            }
        }
    }

    private class AssignLayers
    extends AlgorithmPart {
        HashSet<LayoutNode> checked;
        private final Comparator<LayoutLayer> LAYER_WIDTH_COMPARATOR;
        private final Comparator<LayoutNode> NODE_WIDTH_COMPARATOR;
        private final SortedSet<LayoutLayer> lay;

        private AssignLayers() {
            this.checked = new HashSet();
            this.LAYER_WIDTH_COMPARATOR = (l1, l2) -> {
                int result = Integer.compare(l2.getMinimalWidth(), l1.getMinimalWidth());
                return result == 0 ? Integer.compare(((LayoutNode)l2.get((int)0)).layer, ((LayoutNode)l1.get((int)0)).layer) : result;
            };
            this.NODE_WIDTH_COMPARATOR = (n1, n2) -> Integer.compare(n2.getWholeWidth(), n1.getWholeWidth());
            this.lay = new TreeSet<LayoutLayer>(this.LAYER_WIDTH_COMPARATOR);
        }

        @Override
        public void preCheck() {
            for (LayoutNode n : HierarchicalLayoutManager.this.nodes) {
                assert (n.layer == -1);
            }
        }

        @Override
        protected void run() {
            this.assignLayerDownwards();
            this.assignLayerUpwards();
            this.reassignInOutBlockNodes();
            if (!HierarchicalLayoutManager.this.isDefaultLayout && HierarchicalLayoutManager.this.decreaseLayerWidthDeviation) {
                this.reassignLayers();
            }
        }

        private void reassignInOutBlockNodes() {
            for (Vertex v : HierarchicalLayoutManager.this.graph.getVertices()) {
                if (!(v instanceof ClusterSlotNode)) continue;
                LayoutNode n = HierarchicalLayoutManager.this.vertexToLayoutNode.get(v);
                if (((ClusterSlotNode)v).isInputSlot()) {
                    n.layer = 0;
                    continue;
                }
                n.layer = HierarchicalLayoutManager.this.layerCount - 1;
            }
        }

        private void assignLayerDownwards() {
            ArrayList<LayoutNode> hull = new ArrayList<LayoutNode>();
            for (LayoutNode n : HierarchicalLayoutManager.this.nodes) {
                if (!n.preds.isEmpty()) continue;
                hull.add(n);
                n.layer = 0;
            }
            int z = 1;
            while (!hull.isEmpty()) {
                ArrayList<LayoutNode> newSet = new ArrayList<LayoutNode>();
                for (LayoutNode n : hull) {
                    for (LayoutEdge se : n.succs) {
                        LayoutNode s = se.to;
                        if (s.layer != -1) continue;
                        boolean unassignedPred = false;
                        for (LayoutEdge pe : s.preds) {
                            LayoutNode p = pe.from;
                            if (p.layer != -1 && p.layer < z) continue;
                            unassignedPred = true;
                            break;
                        }
                        if (unassignedPred) continue;
                        s.layer = z;
                        newSet.add(s);
                    }
                }
                hull = newSet;
                ++z;
            }
            HierarchicalLayoutManager.this.layerCount = z - 1;
            for (LayoutNode n : HierarchicalLayoutManager.this.nodes) {
                n.layer = HierarchicalLayoutManager.this.layerCount - 1 - n.layer;
            }
        }

        private void assignLayerUpwards() {
            ArrayList<LayoutNode> hull = new ArrayList<LayoutNode>();
            for (LayoutNode n : HierarchicalLayoutManager.this.nodes) {
                if (n.succs.isEmpty()) {
                    hull.add(n);
                    continue;
                }
                n.layer = -1;
            }
            int z = 1;
            while (!hull.isEmpty()) {
                ArrayList<LayoutNode> newSet = new ArrayList<LayoutNode>();
                for (LayoutNode n : hull) {
                    if (n.layer < z) {
                        for (LayoutEdge se : n.preds) {
                            LayoutNode s = se.from;
                            if (s.layer != -1) continue;
                            boolean unassignedSucc = false;
                            for (LayoutEdge pe : s.succs) {
                                LayoutNode p = pe.to;
                                if (p.layer != -1 && p.layer < z) continue;
                                unassignedSucc = true;
                                break;
                            }
                            if (unassignedSucc) continue;
                            s.layer = z;
                            newSet.add(s);
                        }
                        continue;
                    }
                    newSet.add(n);
                }
                hull = newSet;
                ++z;
            }
            HierarchicalLayoutManager.this.layerCount = z - 1;
            for (LayoutNode n : HierarchicalLayoutManager.this.nodes) {
                n.layer = HierarchicalLayoutManager.this.layerCount - 1 - n.layer;
            }
        }

        private void reassignLayers() {
            HierarchicalLayoutManager.this.layers = new LayoutLayer[HierarchicalLayoutManager.this.layerCount];
            if (HierarchicalLayoutManager.this.layerCount == 0) {
                return;
            }
            for (int i = 0; i < HierarchicalLayoutManager.this.layerCount; ++i) {
                HierarchicalLayoutManager.this.layers[i] = new LayoutLayer();
            }
            for (LayoutNode n : HierarchicalLayoutManager.this.nodes) {
                HierarchicalLayoutManager.this.layers[n.layer].add(n);
            }
            this.lay.addAll(Arrays.asList(HierarchicalLayoutManager.this.layers));
            double avg = this.lay.stream().mapToInt(l -> l.getMinimalWidth()).sum() / HierarchicalLayoutManager.this.layerCount;
            boolean isQuick = HierarchicalLayoutManager.this.decreaseLayerWidthDeviationQuick;
            while (!this.lay.isEmpty()) {
                if (HierarchicalLayoutManager.this.cancelled.get()) {
                    return;
                }
                boolean up = false;
                boolean down = false;
                LayoutLayer layer = this.lay.first();
                if ((double)layer.getMinimalWidth() < avg) break;
                layer.sort(this.NODE_WIDTH_COMPARATOR);
                if (!HierarchicalLayoutManager.this.decreaseLayerWidthDeviationUp) {
                    var7_9 = layer.iterator();
                    while (var7_9.hasNext() && !(down = this.canMoveDown(n = (LayoutNode)var7_9.next())) && !(up = this.canMoveUp(n)) && !isQuick) {
                    }
                    if (down) {
                        this.moveDown();
                        if (!isQuick) continue;
                    }
                    if (up) {
                        this.moveUp();
                        if (!isQuick) {
                            continue;
                        }
                    }
                } else {
                    var7_9 = layer.iterator();
                    while (var7_9.hasNext() && !(up = this.canMoveUp(n = (LayoutNode)var7_9.next())) && !(down = this.canMoveDown(n)) && !isQuick) {
                    }
                    if (up) {
                        this.moveUp();
                        if (!isQuick) continue;
                    }
                    if (down) {
                        this.moveDown();
                        if (!isQuick) continue;
                    }
                }
                this.lay.remove(layer);
            }
        }

        private void moveUp() {
            HashSet<LayoutLayer> reassign = new HashSet<LayoutLayer>();
            for (LayoutNode node : this.checked) {
                LayoutLayer rl = HierarchicalLayoutManager.this.layers[node.layer];
                reassign.add(rl);
                this.lay.remove(rl);
                rl.remove(node);
                LayoutLayer al = HierarchicalLayoutManager.this.layers[node.layer - 1];
                reassign.add(al);
                this.lay.remove(al);
                al.add(node);
                --node.layer;
            }
            this.lay.addAll(reassign);
        }

        private void moveDown() {
            HashSet<LayoutLayer> reassign = new HashSet<LayoutLayer>();
            for (LayoutNode node : this.checked) {
                LayoutLayer rl = HierarchicalLayoutManager.this.layers[node.layer];
                reassign.add(rl);
                this.lay.remove(rl);
                rl.remove(node);
                LayoutLayer al = HierarchicalLayoutManager.this.layers[node.layer + 1];
                reassign.add(al);
                this.lay.remove(al);
                al.add(node);
                ++node.layer;
            }
            this.lay.addAll(reassign);
        }

        private boolean canMoveUp(LayoutNode node) {
            this.checked.clear();
            if (this.cantMoveUp(node)) {
                return false;
            }
            ArrayList<Integer> sizes = new ArrayList<Integer>();
            this.getSizesUp(sizes);
            int layNr = sizes.size() + 1;
            int initLay = node.layer;
            int[] before = new int[layNr];
            for (int i = 0; i < layNr; ++i) {
                before[i] = HierarchicalLayoutManager.this.layers[initLay - i].getMinimalWidth();
            }
            return this.improves(sizes, before);
        }

        private void getSizesUp(List<Integer> sizes) {
            assert (!this.checked.isEmpty());
            ArrayList<LayoutNode> nodes = new ArrayList<LayoutNode>(this.checked);
            nodes.sort((n1, n2) -> Integer.compare(n2.layer, n1.layer));
            int first = ((LayoutNode)nodes.get((int)0)).layer;
            for (LayoutNode node : nodes) {
                int index = first - node.layer;
                if (sizes.size() == index) {
                    sizes.add(node.getWholeWidth() + HierarchicalLayoutManager.this.offset);
                    continue;
                }
                sizes.set(index, sizes.get(index) + node.getWholeWidth() + HierarchicalLayoutManager.this.offset);
            }
        }

        private boolean cantMoveUp(LayoutNode node) {
            ArrayDeque<LayoutNode> que = new ArrayDeque<LayoutNode>();
            que.add(node);
            while (!que.isEmpty()) {
                node = (LayoutNode)que.poll();
                if (this.checked.contains(node)) continue;
                int layer = node.layer;
                if (layer == 0) {
                    return true;
                }
                if (!HierarchicalLayoutManager.this.isDrawLongEdges && HierarchicalLayoutManager.this.maxLayerLength >= 0) {
                    for (LayoutEdge e : node.succs) {
                        if (e.to.layer != layer + HierarchicalLayoutManager.this.maxLayerLength) continue;
                        return true;
                    }
                }
                for (LayoutEdge e : node.preds) {
                    if (e.from.layer != layer - 1) continue;
                    que.add(e.from);
                }
                this.checked.add(node);
            }
            return false;
        }

        private boolean improves(List<Integer> others, int[] before) {
            double tmp;
            int layNr = before.length;
            double avg = (double)Arrays.stream(before).sum() / (double)layNr;
            double dev1 = 0.0;
            for (int i : before) {
                tmp = (double)i / avg;
                dev1 += tmp * tmp;
            }
            dev1 = Math.sqrt(dev1 / (double)layNr);
            int[] after = new int[layNr];
            after[0] = before[0];
            double dev2 = 0.0;
            for (int i = 0; i < layNr - 1; ++i) {
                int dif = others.get(i);
                int n = i;
                after[n] = after[n] - dif;
                tmp = (double)after[i] / avg;
                dev2 += tmp * tmp;
                after[i + 1] = before[i + 1] + dif;
            }
            tmp = (double)after[layNr - 1] / avg;
            dev2 += tmp * tmp;
            return dev1 > (dev2 = Math.sqrt(dev2 / (double)layNr));
        }

        private boolean canMoveDown(LayoutNode node) {
            this.checked.clear();
            if (this.cantMoveDown(node)) {
                return false;
            }
            ArrayList<Integer> sizes = new ArrayList<Integer>();
            this.getSizesDown(sizes);
            int layNr = sizes.size() + 1;
            int initLay = node.layer;
            int[] before = new int[layNr];
            for (int i = 0; i < layNr; ++i) {
                before[i] = HierarchicalLayoutManager.this.layers[initLay + i].getMinimalWidth();
            }
            return this.improves(sizes, before);
        }

        private void getSizesDown(List<Integer> sizes) {
            assert (!this.checked.isEmpty());
            ArrayList<LayoutNode> nodes = new ArrayList<LayoutNode>(this.checked);
            nodes.sort(Comparator.comparingInt(n -> n.layer));
            int first = ((LayoutNode)nodes.get((int)0)).layer;
            for (LayoutNode node : nodes) {
                int index = node.layer - first;
                if (sizes.size() == index) {
                    sizes.add(node.getWholeWidth() + HierarchicalLayoutManager.this.offset);
                    continue;
                }
                sizes.set(index, sizes.get(index) + node.getWholeWidth() + HierarchicalLayoutManager.this.offset);
            }
        }

        private boolean cantMoveDown(LayoutNode node) {
            ArrayDeque<LayoutNode> que = new ArrayDeque<LayoutNode>();
            que.add(node);
            while (!que.isEmpty()) {
                node = (LayoutNode)que.poll();
                if (this.checked.contains(node)) continue;
                int layer = node.layer;
                if (layer == HierarchicalLayoutManager.this.layerCount - 1) {
                    return true;
                }
                if (!HierarchicalLayoutManager.this.isDrawLongEdges && HierarchicalLayoutManager.this.maxLayerLength >= 0) {
                    for (LayoutEdge e : node.preds) {
                        if (e.from.layer != layer - HierarchicalLayoutManager.this.maxLayerLength) continue;
                        return true;
                    }
                }
                for (LayoutEdge e : node.succs) {
                    if (e.to.layer != layer + 1) continue;
                    que.add(e.to);
                }
                this.checked.add(node);
            }
            return false;
        }

        @Override
        public void postCheck() {
            for (LayoutNode n : HierarchicalLayoutManager.this.nodes) {
                assert (n.layer >= 0);
                assert (n.layer < HierarchicalLayoutManager.this.layerCount);
                for (LayoutEdge e : n.succs) {
                    assert (e.from.layer < e.to.layer);
                }
            }
        }
    }

    private class CreateDummyNodes
    extends AlgorithmPart {
        private int oldNodeCount;

        private CreateDummyNodes() {
        }

        @Override
        protected void preCheck() {
            for (LayoutNode n : HierarchicalLayoutManager.this.nodes) {
                for (LayoutEdge e : n.succs) {
                    assert (e.from != null);
                    assert (e.from == n);
                    assert (e.from.layer < e.to.layer);
                }
                for (LayoutEdge e : n.preds) {
                    assert (e.to != null);
                    assert (e.to == n);
                }
            }
        }

        @Override
        protected void run() {
            this.oldNodeCount = HierarchicalLayoutManager.this.nodes.size();
            if (HierarchicalLayoutManager.this.combine == Combine.SAME_OUTPUTS) {
                HashMap portHash = new HashMap();
                ArrayList<LayoutNode> currentNodes = new ArrayList<LayoutNode>(HierarchicalLayoutManager.this.nodes);
                for (LayoutNode n2 : currentNodes) {
                    Integer i;
                    portHash.clear();
                    ArrayList<LayoutEdge> succs = new ArrayList<LayoutEdge>(n2.succs);
                    HashMap<Integer, LayoutNode> topNodeHash = new HashMap<Integer, LayoutNode>();
                    HashMap bottomNodeHash = new HashMap();
                    for (LayoutEdge e : succs) {
                        assert (e.from.layer < e.to.layer);
                        if (e.from.layer == e.to.layer - 1) continue;
                        if (HierarchicalLayoutManager.this.maxLayerLength != -1 && e.to.layer - e.from.layer > HierarchicalLayoutManager.this.maxLayerLength && !HierarchicalLayoutManager.this.isDrawLongEdges) {
                            assert (HierarchicalLayoutManager.this.maxLayerLength > 2);
                            e.to.preds.remove(e);
                            e.from.succs.remove(e);
                            if (HierarchicalLayoutManager.this.isDefaultLayout || !HierarchicalLayoutManager.this.noDummyLongEdges) {
                                LayoutNode bottomNode;
                                LayoutNode topNode = (LayoutNode)topNodeHash.get(e.relativeFrom);
                                if (topNode == null) {
                                    topNode = new LayoutNode();
                                    topNode.layer = e.from.layer + 1;
                                    HierarchicalLayoutManager.this.nodes.add(topNode);
                                    topNodeHash.put(e.relativeFrom, topNode);
                                    bottomNodeHash.put(e.relativeFrom, new HashMap());
                                }
                                LayoutEdge topEdge = new LayoutEdge(e.from, topNode, e.relativeFrom, topNode.width / 2, e.link, e.vip);
                                e.from.succs.add(topEdge);
                                topNode.preds.add(topEdge);
                                HashMap hash = (HashMap)bottomNodeHash.get(e.relativeFrom);
                                if (hash.containsKey(e.to.layer)) {
                                    bottomNode = (LayoutNode)hash.get(e.to.layer);
                                } else {
                                    bottomNode = new LayoutNode();
                                    bottomNode.layer = e.to.layer - 1;
                                    HierarchicalLayoutManager.this.nodes.add(bottomNode);
                                    hash.put(e.to.layer, bottomNode);
                                }
                                LayoutEdge bottomEdge = new LayoutEdge(bottomNode, e.to, bottomNode.width / 2, e.relativeTo, e.link, e.vip);
                                e.to.preds.add(bottomEdge);
                                bottomNode.succs.add(bottomEdge);
                                continue;
                            }
                            HierarchicalLayoutManager.this.longEdges.add(e);
                            continue;
                        }
                        i = e.relativeFrom;
                        if (!portHash.containsKey(i)) {
                            portHash.put(i, new ArrayList());
                        }
                        ((List)portHash.get(i)).add(e);
                    }
                    for (LayoutEdge e : succs) {
                        i = e.relativeFrom;
                        if (!portHash.containsKey(i)) continue;
                        List list = (List)portHash.get(i);
                        list.sort(LAYER_COMPARATOR);
                        if (list.size() == 1) {
                            this.processSingleEdge((LayoutEdge)list.get(0));
                        } else {
                            int maxLayer = ((LayoutEdge)list.get((int)(list.size() - 1))).to.layer;
                            int cnt = maxLayer - n2.layer - 1;
                            LayoutEdge[] edges = new LayoutEdge[cnt];
                            LayoutNode[] nodes = new LayoutNode[cnt];
                            nodes[0] = new LayoutNode();
                            nodes[0].layer = n2.layer + 1;
                            edges[0] = new LayoutEdge(n2, nodes[0], i, nodes[0].width / 2, null, e.vip);
                            nodes[0].preds.add(edges[0]);
                            n2.succs.add(edges[0]);
                            for (int j = 1; j < cnt; ++j) {
                                nodes[j] = new LayoutNode();
                                nodes[j].layer = n2.layer + j + 1;
                                edges[j] = new LayoutEdge(nodes[j - 1], nodes[j], nodes[j - 1].width / 2, nodes[j].width / 2, null, e.vip);
                                nodes[j - 1].succs.add(edges[j]);
                                nodes[j].preds.add(edges[j]);
                            }
                            for (LayoutEdge curEdge : list) {
                                assert (curEdge.to.layer - n2.layer - 2 >= 0);
                                assert (curEdge.to.layer - n2.layer - 2 < cnt);
                                LayoutNode anchor = nodes[curEdge.to.layer - n2.layer - 2];
                                for (int l = 0; l < curEdge.to.layer - n2.layer - 1; ++l) {
                                    anchor = nodes[l];
                                }
                                anchor.succs.add(curEdge);
                                curEdge.from = anchor;
                                curEdge.relativeFrom = anchor.width / 2;
                                n2.succs.remove(curEdge);
                            }
                            if (!HierarchicalLayoutManager.this.isDefaultLayout && HierarchicalLayoutManager.this.noCrossingLayerReassign) {
                                HierarchicalLayoutManager.this.nodes.addAll(Arrays.asList(nodes));
                            }
                        }
                        portHash.remove(i);
                    }
                }
            } else {
                if (HierarchicalLayoutManager.this.combine == Combine.SAME_INPUTS) {
                    throw new UnsupportedOperationException("Currently not supported");
                }
                new ArrayList<LayoutNode>(HierarchicalLayoutManager.this.nodes).forEach(n -> n.succs.forEach(this::processSingleEdge));
            }
        }

        private void processSingleEdge(LayoutEdge e) {
            LayoutNode n = e.from;
            if (e.to.layer > n.layer + 1) {
                LayoutEdge last = e;
                for (int i = n.layer + 1; i < last.to.layer; ++i) {
                    last = this.addBetween(last, i);
                }
            }
        }

        private LayoutEdge addBetween(LayoutEdge e, int layer) {
            LayoutNode n = new LayoutNode();
            n.layer = layer;
            n.preds.add(e);
            HierarchicalLayoutManager.this.nodes.add(n);
            LayoutEdge result = new LayoutEdge(n, e.to, n.width / 2, e.relativeTo, null, e.vip);
            n.succs.add(result);
            e.relativeTo = n.width / 2;
            e.to.preds.remove(e);
            e.to.preds.add(result);
            e.to = n;
            return result;
        }

        @Override
        public void printStatistics() {
            System.out.println("Dummy nodes created: " + (HierarchicalLayoutManager.this.nodes.size() - this.oldNodeCount));
        }

        @Override
        public void postCheck() {
            ArrayList<LayoutNode> currentNodes = new ArrayList<LayoutNode>(HierarchicalLayoutManager.this.nodes);
            for (LayoutNode n : currentNodes) {
                for (LayoutEdge e : n.succs) {
                    assert (e.from.layer == e.to.layer - 1);
                }
            }
        }
    }

    private class CrossingReduction
    extends AlgorithmPart {
        List<LayoutNode>[] upCrossing;
        List<LayoutNode>[] downCrossing;
        int[] centerDiffs;
        private final boolean routingCrossing;
        private LayoutLayer[] toMove;

        public CrossingReduction() {
            this(false);
        }

        public CrossingReduction(boolean routingCrossing) {
            this.routingCrossing = routingCrossing;
        }

        @Override
        public void preCheck() {
            for (LayoutNode n : HierarchicalLayoutManager.this.nodes) {
                assert (n.layer < HierarchicalLayoutManager.this.layerCount);
            }
        }

        private void createLayers() {
            if (!HierarchicalLayoutManager.this.isDefaultLayout && HierarchicalLayoutManager.this.crossingSort && !HierarchicalLayoutManager.this.isCrossingByConnDiff) {
                this.upCrossing = new ArrayList[HierarchicalLayoutManager.this.layerCount];
                this.downCrossing = new ArrayList[HierarchicalLayoutManager.this.layerCount];
            }
            if (!this.routingCrossing) {
                HierarchicalLayoutManager.this.layers = new LayoutLayer[HierarchicalLayoutManager.this.layerCount];
                for (int i = 0; i < HierarchicalLayoutManager.this.layerCount; ++i) {
                    HierarchicalLayoutManager.this.layers[i] = new LayoutLayer();
                }
                if (!HierarchicalLayoutManager.this.isDefaultLayout && HierarchicalLayoutManager.this.noCrossingLayerReassign) {
                    for (LayoutNode n : HierarchicalLayoutManager.this.nodes) {
                        HierarchicalLayoutManager.this.layers[n.layer].add(n);
                    }
                } else {
                    HashSet<LayoutNode> visited = new HashSet<LayoutNode>();
                    for (LayoutNode n : HierarchicalLayoutManager.this.nodes) {
                        if (n.layer == 0) {
                            HierarchicalLayoutManager.this.layers[0].add(n);
                            visited.add(n);
                            continue;
                        }
                        if (!n.preds.isEmpty()) continue;
                        HierarchicalLayoutManager.this.layers[n.layer].add(n);
                        visited.add(n);
                    }
                    for (int i = 0; i < HierarchicalLayoutManager.this.layers.length - 1; ++i) {
                        for (LayoutNode n : HierarchicalLayoutManager.this.layers[i]) {
                            for (LayoutEdge e : n.succs) {
                                if (visited.contains(e.to)) continue;
                                visited.add(e.to);
                                assert (e.to.layer == i + 1);
                                HierarchicalLayoutManager.this.layers[i + 1].add(e.to);
                            }
                        }
                    }
                }
            }
            LayoutLayer[] layoutLayerArray = this.toMove = !this.routingCrossing ? HierarchicalLayoutManager.this.layers : (LayoutLayer[])Arrays.stream(HierarchicalLayoutManager.this.layers).map(l -> l.stream().filter(LayoutNode::isDummy).collect(() -> new LayoutLayer(), LayoutLayer::add, LayoutLayer::addAll)).toArray(LayoutLayer[]::new);
            if (!HierarchicalLayoutManager.this.isDefaultLayout && HierarchicalLayoutManager.this.crossingSort && !HierarchicalLayoutManager.this.isCrossingByConnDiff) {
                for (int i = 0; i < HierarchicalLayoutManager.this.layerCount; ++i) {
                    this.upCrossing[i] = new ArrayList<LayoutNode>(HierarchicalLayoutManager.this.layers[i]);
                    this.downCrossing[i] = new ArrayList<LayoutNode>(HierarchicalLayoutManager.this.layers[i]);
                    this.upCrossing[i].sort(UP_CROSSING_COMPARATOR);
                    this.downCrossing[i].sort(DOWN_CROSSING_COMPARATOR);
                }
            }
        }

        @Override
        protected void run() {
            this.createLayers();
            if (HierarchicalLayoutManager.this.irrelevantLayoutCode) {
                this.updatePositions();
            }
            this.initX();
            int sweepCount = HierarchicalLayoutManager.this.isDefaultLayout ? 2 : HierarchicalLayoutManager.this.crossingSweepCount;
            for (int i = 0; i < sweepCount; ++i) {
                this.downSweep();
                this.upSweep();
            }
            if (HierarchicalLayoutManager.this.isDefaultLayout || !HierarchicalLayoutManager.this.lastUpCrossingSweep) {
                this.downSweep();
            }
            if (HierarchicalLayoutManager.this.irrelevantLayoutCode) {
                this.initX();
            }
            this.updatePositions();
        }

        private void initX() {
            if (!HierarchicalLayoutManager.this.isDefaultLayout && HierarchicalLayoutManager.this.centerCrossingX) {
                this.createCenterDiffs();
            }
            for (int i = 0; i < HierarchicalLayoutManager.this.layers.length; ++i) {
                this.updateXOfLayer(i);
            }
        }

        private void createCenterDiffs() {
            int i;
            if (this.centerDiffs != null) {
                return;
            }
            int max = 0;
            this.centerDiffs = new int[HierarchicalLayoutManager.this.layerCount];
            for (i = 0; i < HierarchicalLayoutManager.this.layers.length; ++i) {
                int length = 0;
                for (LayoutNode n : HierarchicalLayoutManager.this.layers[i]) {
                    length += n.getWholeWidth() + HierarchicalLayoutManager.this.offset;
                }
                this.centerDiffs[i] = length;
                max = Math.max(length, max);
            }
            for (i = 0; i < this.centerDiffs.length; ++i) {
                this.centerDiffs[i] = (max - this.centerDiffs[i]) / 2;
            }
        }

        private void updateXOfLayer(int index) {
            if (!HierarchicalLayoutManager.this.isDefaultLayout && HierarchicalLayoutManager.this.crossResetXFromNode) {
                if (HierarchicalLayoutManager.this.crossResetXFromMiddle) {
                    this.updateFromMiddle(index);
                } else {
                    this.updateFromLeft(index);
                }
            } else {
                int x = HierarchicalLayoutManager.this.isDefaultLayout || !HierarchicalLayoutManager.this.centerCrossingX ? 0 : this.centerDiffs[index];
                for (LayoutNode n : HierarchicalLayoutManager.this.layers[index]) {
                    n.x = x;
                    x += n.getWholeWidth() + HierarchicalLayoutManager.this.offset;
                }
            }
        }

        private void updateFromMiddle(int index) {
            int i;
            LayoutLayer layer = HierarchicalLayoutManager.this.layers[index];
            int middleIndex = layer.size() / 2;
            LayoutNode n = (LayoutNode)layer.get(middleIndex);
            int add = HierarchicalLayoutManager.this.isDefaultLayout || !HierarchicalLayoutManager.this.centerCrossingX ? 0 : this.centerDiffs[index] / (layer.size() + 1);
            int x = n.x;
            for (i = middleIndex - 1; i >= 0; --i) {
                n = (LayoutNode)layer.get(i);
                x = n.x = Math.min(n.x, x - n.getWholeWidth() - HierarchicalLayoutManager.this.offset - add);
            }
            n = (LayoutNode)layer.get(middleIndex);
            x = n.getRightSide() + HierarchicalLayoutManager.this.offset;
            for (i = middleIndex + 1; i < layer.size(); ++i) {
                n = (LayoutNode)layer.get(i);
                n.x = Math.max(n.x, x + add);
                x = n.getRightSide() + HierarchicalLayoutManager.this.offset;
            }
        }

        private void updateFromLeft(int index) {
            LayoutLayer layer = HierarchicalLayoutManager.this.layers[index];
            LayoutNode n = (LayoutNode)layer.get(0);
            int add = HierarchicalLayoutManager.this.isDefaultLayout || !HierarchicalLayoutManager.this.centerCrossingX ? 0 : this.centerDiffs[index] / (layer.size() + 1);
            int x = n.getRightSide() + HierarchicalLayoutManager.this.offset;
            for (int i = 0; i < layer.size(); ++i) {
                n = (LayoutNode)layer.get(i);
                n.x = Math.max(n.x, x + add);
                x = n.getRightSide() + HierarchicalLayoutManager.this.offset;
            }
        }

        private void updatePositions() {
            for (int i = 0; i < HierarchicalLayoutManager.this.layerCount; ++i) {
                this.updateLayerPositions(i);
            }
        }

        private void updateLayerPositions(int index) {
            int z = 0;
            for (LayoutNode n : HierarchicalLayoutManager.this.layers[index]) {
                n.pos = z++;
            }
        }

        private void changeXOfLayer(int index) {
            float factor = !HierarchicalLayoutManager.this.isDefaultLayout && HierarchicalLayoutManager.this.crossResetXFromMiddle ? HierarchicalLayoutManager.this.crossFactor : 1.0f;
            for (LayoutNode n : this.toMove[index]) {
                n.x = (int)((float)n.x + n.crossingNumber * factor);
            }
        }

        private void downSweep() {
            if (!HierarchicalLayoutManager.this.isDefaultLayout && HierarchicalLayoutManager.this.crossPositionDuring) {
                this.updatePositions();
                new AssignXCoordinates().start();
            }
            for (int i = 0; i < HierarchicalLayoutManager.this.layerCount; ++i) {
                for (LayoutNode n : this.toMove[i]) {
                    n.loadCrossingNumber(false);
                }
                if (!HierarchicalLayoutManager.this.isDefaultLayout && HierarchicalLayoutManager.this.isCrossingByConnDiff) {
                    this.changeXOfLayer(i);
                    HierarchicalLayoutManager.this.layers[i].sort(Comparator.comparingInt(LayoutNode::getCenterX));
                    this.updateXOfLayer(i);
                } else {
                    this.updateCrossingNumbers(i, true);
                    HierarchicalLayoutManager.this.layers[i].sort(CROSSING_NODE_COMPARATOR);
                    this.updateXOfLayer(i);
                }
                if (!HierarchicalLayoutManager.this.irrelevantLayoutCode) continue;
                this.updateLayerPositions(i);
            }
        }

        private void upSweep() {
            if (!HierarchicalLayoutManager.this.isDefaultLayout && HierarchicalLayoutManager.this.crossPositionDuring) {
                this.updatePositions();
                new AssignXCoordinates().start();
            }
            for (int i = HierarchicalLayoutManager.this.layerCount - 1; i >= 0; --i) {
                for (LayoutNode n : this.toMove[i]) {
                    n.loadCrossingNumber(true);
                }
                if (!HierarchicalLayoutManager.this.isDefaultLayout && HierarchicalLayoutManager.this.isCrossingByConnDiff) {
                    this.changeXOfLayer(i);
                    HierarchicalLayoutManager.this.layers[i].sort(Comparator.comparingInt(LayoutNode::getCenterX));
                    this.updateXOfLayer(i);
                } else {
                    this.updateCrossingNumbers(i, false);
                    HierarchicalLayoutManager.this.layers[i].sort(CROSSING_NODE_COMPARATOR);
                    this.updateXOfLayer(i);
                }
                if (!HierarchicalLayoutManager.this.irrelevantLayoutCode) continue;
                this.updateLayerPositions(i);
            }
        }

        private void updateCrossingNumbers(int index, boolean down) {
            List<LayoutNode> layer = !HierarchicalLayoutManager.this.isDefaultLayout && HierarchicalLayoutManager.this.crossingSort ? (down ? this.downCrossing[index] : this.upCrossing[index]) : HierarchicalLayoutManager.this.layers[index];
            boolean properCrossing = !HierarchicalLayoutManager.this.isDefaultLayout && HierarchicalLayoutManager.this.properCrossingClosestNode;
            boolean diff = !HierarchicalLayoutManager.this.isDefaultLayout && HierarchicalLayoutManager.this.unknownCrossingNumber;
            for (int i = 0; i < layer.size(); ++i) {
                LayoutNode n = layer.get(i);
                if (!(down ? n.preds.isEmpty() : n.succs.isEmpty())) continue;
                LayoutNode prev = null;
                LayoutNode next = null;
                if (properCrossing) {
                    prev = this.getPrevPositioned(HierarchicalLayoutManager.this.layers[index], i);
                    next = this.getNextPositioned(HierarchicalLayoutManager.this.layers[index], i);
                } else {
                    if (i > 0) {
                        prev = layer.get(i - 1);
                    }
                    if (i < layer.size() - 1) {
                        next = layer.get(i + 1);
                    }
                }
                if (prev != null && next != null) {
                    n.crossingNumber = (prev.crossingNumber + next.crossingNumber) / 2.0f;
                    continue;
                }
                if (prev != null) {
                    n.crossingNumber = prev.crossingNumber + (float)diff;
                    continue;
                }
                if (next == null) continue;
                n.crossingNumber = next.crossingNumber - (float)diff;
            }
        }

        private LayoutNode getPrevPositioned(List<LayoutNode> layer, int i) {
            while (--i >= 0) {
                LayoutNode node = layer.get(i);
                if (node.crossingNumber == 0.0f) continue;
                return node;
            }
            return null;
        }

        private LayoutNode getNextPositioned(List<LayoutNode> layer, int i) {
            while (++i < layer.size()) {
                LayoutNode node = layer.get(i);
                if (node.crossingNumber == 0.0f) continue;
                return node;
            }
            return null;
        }

        @Override
        public void postCheck() {
            int i;
            HashSet<LayoutNode> visited = new HashSet<LayoutNode>();
            for (i = 0; i < HierarchicalLayoutManager.this.layers.length; ++i) {
                for (LayoutNode n : HierarchicalLayoutManager.this.layers[i]) {
                    assert (!visited.contains(n));
                    assert (n.layer == i);
                    visited.add(n);
                }
            }
            for (i = 0; i < HierarchicalLayoutManager.this.layers.length; ++i) {
                assert (!HierarchicalLayoutManager.this.layers[i].isEmpty());
                for (LayoutNode n : HierarchicalLayoutManager.this.layers[i]) {
                    assert (n.layer == i);
                }
            }
        }
    }

    private class AssignXCoordinates
    extends AlgorithmPart {
        private int[][] space;
        private LayoutNode[][] downProcessingOrder;
        private LayoutNode[][] upProcessingOrder;
        private LayoutNode[][] bothProcessingOrder;

        private AssignXCoordinates() {
        }

        private void initialPositions() {
            for (LayoutNode n : HierarchicalLayoutManager.this.nodes) {
                n.x = this.space[n.layer][n.pos];
            }
        }

        private void createArrays() {
            this.space = new int[HierarchicalLayoutManager.this.layers.length][];
            if (HierarchicalLayoutManager.this.isDefaultLayout || !HierarchicalLayoutManager.this.bothSort) {
                this.downProcessingOrder = new LayoutNode[HierarchicalLayoutManager.this.layers.length][];
                this.upProcessingOrder = new LayoutNode[HierarchicalLayoutManager.this.layers.length][];
            } else {
                this.bothProcessingOrder = new LayoutNode[HierarchicalLayoutManager.this.layers.length][];
            }
            Comparator<LayoutNode> upComparer = NODE_PROCESSING_DUMMY_UP_COMPARATOR;
            Comparator<LayoutNode> downComparer = NODE_PROCESSING_DUMMY_DOWN_COMPARATOR;
            Comparator<LayoutNode> bothComparer = NODE_PROCESSING_DUMMY_BOTH_COMPARATOR;
            if (!HierarchicalLayoutManager.this.isDefaultLayout) {
                if (HierarchicalLayoutManager.this.reverseSort) {
                    if (HierarchicalLayoutManager.this.dummyFirstSort) {
                        upComparer = NODE_PROCESSING_DUMMY_UP_REVERSE_COMPARATOR;
                        downComparer = NODE_PROCESSING_DUMMY_DOWN_REVERSE_COMPARATOR;
                        bothComparer = NODE_PROCESSING_DUMMY_BOTH_REVERSE_COMPARATOR;
                    } else {
                        upComparer = NODE_PROCESSING_UP_REVERSE_COMPARATOR;
                        downComparer = NODE_PROCESSING_DOWN_REVERSE_COMPARATOR;
                        bothComparer = NODE_PROCESSING_BOTH_REVERSE_COMPARATOR;
                    }
                } else if (!HierarchicalLayoutManager.this.dummyFirstSort) {
                    upComparer = NODE_PROCESSING_UP_COMPARATOR;
                    downComparer = NODE_PROCESSING_DOWN_COMPARATOR;
                    bothComparer = NODE_PROCESSING_BOTH_COMPARATOR;
                }
            }
            for (int i = 0; i < HierarchicalLayoutManager.this.layers.length; ++i) {
                LayoutLayer layer = HierarchicalLayoutManager.this.layers[i];
                this.space[i] = new int[layer.size()];
                int[] layerSpace = this.space[i];
                boolean visible = layer.isVisible();
                int curX = 0;
                for (int y = 0; y < layer.size(); ++y) {
                    layerSpace[y] = curX;
                    LayoutNode node = (LayoutNode)layer.get(y);
                    if (!visible) {
                        node.width = 0;
                        node.xOffset = 0;
                        continue;
                    }
                    curX += node.getWholeWidth() + (node.isDummy() ? 8 : HierarchicalLayoutManager.this.offset);
                }
                if (HierarchicalLayoutManager.this.isDefaultLayout || !HierarchicalLayoutManager.this.bothSort) {
                    this.downProcessingOrder[i] = layer.toArray(new LayoutNode[0]);
                    Arrays.sort(this.downProcessingOrder[i], downComparer);
                    this.upProcessingOrder[i] = AssignXCoordinates.reverseSort(this.downProcessingOrder[i], upComparer);
                    continue;
                }
                this.bothProcessingOrder[i] = layer.toArray(new LayoutNode[0]);
                Arrays.sort(this.bothProcessingOrder[i], bothComparer);
            }
        }

        private static LayoutNode[] reverseSort(LayoutNode[] source, Comparator<LayoutNode> upComparer) {
            LayoutNode[] array = (LayoutNode[])source.clone();
            int left = 0;
            for (int right = array.length - 1; left < right; ++left, --right) {
                LayoutNode temp = array[left];
                array[left] = array[right];
                array[right] = temp;
            }
            assert (AssignXCoordinates.verifySort(array, upComparer));
            return array;
        }

        private static boolean verifySort(LayoutNode[] array, Comparator<LayoutNode> upComparer) {
            Object[] copy = (LayoutNode[])array.clone();
            Arrays.sort(copy, upComparer);
            assert (Arrays.equals(array, copy));
            return true;
        }

        @Override
        protected void run() {
            this.createArrays();
            this.initialPositions();
            for (int i = 0; i < (HierarchicalLayoutManager.this.isDefaultLayout ? 1 : HierarchicalLayoutManager.this.xAssignSweepCount); ++i) {
                this.sweepDown();
                this.sweepUp();
            }
            this.sweepDown();
            if (HierarchicalLayoutManager.this.isDefaultLayout || !HierarchicalLayoutManager.this.lastDownSweep) {
                this.sweepUp();
            }
        }

        private int getVisibleLayer(int start, boolean up) {
            if (up) {
                for (int i = start - 1; i >= 0; --i) {
                    if (!HierarchicalLayoutManager.this.layers[i].isVisible()) continue;
                    return i;
                }
            } else {
                for (int i = start + 1; i < HierarchicalLayoutManager.this.layers.length; ++i) {
                    if (!HierarchicalLayoutManager.this.layers[i].isVisible()) continue;
                    return i;
                }
            }
            return -1;
        }

        public void getOptimalPositions(LayoutEdge edge, int layer, List<Integer> vals, int correction, boolean up, boolean hasNoDangling) {
            if (up) {
                if (edge.from.layer <= layer) {
                    if (!edge.from.isDangling()) {
                        vals.add(edge.getStartPoint() - correction);
                    }
                } else if (edge.from.isDummy()) {
                    edge.from.preds.forEach(x -> this.getOptimalPositions((LayoutEdge)x, layer, vals, correction, up, hasNoDangling));
                }
            } else if (edge.to.layer >= layer) {
                if (!edge.to.isDangling()) {
                    vals.add(edge.getEndPoint() - correction);
                }
            } else if (edge.to.isDummy()) {
                edge.to.succs.forEach(x -> this.getOptimalPositions((LayoutEdge)x, layer, vals, correction, up, hasNoDangling));
            }
        }

        private int calculateOptimalDown(LayoutNode n, LayoutNode last, boolean hasNoDangling) {
            ArrayList<Integer> values = new ArrayList<Integer>(n.preds.size());
            int layer = this.getVisibleLayer(n.layer, true);
            if (n.getPredsVips() != 0) {
                for (LayoutEdge e : n.preds) {
                    if (!e.vip) continue;
                    this.getOptimalPositions(e, layer, values, e.relativeTo, true, hasNoDangling);
                }
            } else {
                for (LayoutEdge e : n.preds) {
                    this.getOptimalPositions(e, layer, values, e.relativeTo, true, hasNoDangling);
                }
            }
            return this.median(values, n, last, true, hasNoDangling);
        }

        private int calcLayerCenter(LayoutLayer layer) {
            LayoutNode last = (LayoutNode)layer.get(layer.size() - 1);
            return (((LayoutNode)layer.get((int)0)).x + last.getRightSide()) / 2;
        }

        private int calcClosestPosition(LayoutNode n, LayoutNode last, boolean up, boolean hasNoDangling) {
            assert (n != null);
            return last == null ? this.calcLastLayerCenter(n, up, hasNoDangling) : last.x;
        }

        public int getExpectedRelativePosition(LayoutLayer layer, LayoutNode n) {
            assert (layer.get(n.pos) == n);
            int x = 0;
            for (int i = 0; i < n.pos; ++i) {
                x += ((LayoutNode)layer.get(i)).getWholeWidth() + HierarchicalLayoutManager.this.offset;
            }
            return x;
        }

        private int calcLastLayerCenter(LayoutNode n, boolean up, boolean hasNoDangling) {
            if (up) {
                for (int i = n.layer - 1; i >= 0; --i) {
                    if (!HierarchicalLayoutManager.this.layers[i].isVisible() || !hasNoDangling && !HierarchicalLayoutManager.this.layers[i].stream().noneMatch(LayoutNode::isDangling)) continue;
                    return this.calcLayerCenter(HierarchicalLayoutManager.this.layers[i]) - HierarchicalLayoutManager.this.layers[n.layer].getMinimalWidth() / 2 + this.getExpectedRelativePosition(HierarchicalLayoutManager.this.layers[n.layer], n);
                }
            } else {
                for (int i = n.layer + 1; i < HierarchicalLayoutManager.this.layers.length; ++i) {
                    if (!HierarchicalLayoutManager.this.layers[i].isVisible() || !hasNoDangling && !HierarchicalLayoutManager.this.layers[i].stream().noneMatch(LayoutNode::isDangling)) continue;
                    return this.calcLayerCenter(HierarchicalLayoutManager.this.layers[i]) - HierarchicalLayoutManager.this.layers[n.layer].getMinimalWidth() / 2 + this.getExpectedRelativePosition(HierarchicalLayoutManager.this.layers[n.layer], n);
                }
            }
            return n.x;
        }

        private int calculateOptimalUp(LayoutNode n, LayoutNode last, boolean hasNoDangling) {
            ArrayList<Integer> values = new ArrayList<Integer>(n.succs.size());
            int layer = this.getVisibleLayer(n.layer, false);
            if (HierarchicalLayoutManager.this.isDefaultLayout || !HierarchicalLayoutManager.this.optimalUpVip) {
                for (LayoutEdge e : n.succs) {
                    if (e.vip) {
                        this.getOptimalPositions(e, layer, new ArrayList<Integer>(), e.relativeFrom, false, hasNoDangling);
                        break;
                    }
                    this.getOptimalPositions(e, layer, values, e.relativeFrom, false, hasNoDangling);
                }
            } else if (n.getSuccsVips() != 0) {
                for (LayoutEdge e : n.succs) {
                    if (!e.vip) continue;
                    this.getOptimalPositions(e, layer, values, e.relativeFrom, false, hasNoDangling);
                }
            } else {
                for (LayoutEdge e : n.succs) {
                    this.getOptimalPositions(e, layer, values, e.relativeFrom, false, hasNoDangling);
                }
            }
            return this.median(values, n, last, false, hasNoDangling);
        }

        private int median(ArrayList<Integer> values, LayoutNode n, LayoutNode last, boolean up, boolean hasNoDangling) {
            if (values.isEmpty()) {
                if (HierarchicalLayoutManager.this.isDefaultLayout || !HierarchicalLayoutManager.this.squashPosition) {
                    return n.x;
                }
                return this.calcClosestPosition(n, last, up, hasNoDangling);
            }
            if (HierarchicalLayoutManager.this.centerSimpleNodes && !n.isDummy() && values.size() == 1 && (up ? n.preds.size() == 1 : n.succs.size() == 1) && !(n.vertex instanceof ClusterSlotNode)) {
                LayoutNode node = up ? ((LayoutEdge)n.preds.get((int)0)).from : ((LayoutEdge)n.succs.get((int)0)).to;
                if (!(node.vertex instanceof ClusterSlotNode) && (up ? node.succs.size() == 1 : node.preds.size() == 1)) {
                    return node.x + (node.getWholeWidth() - n.getWholeWidth()) / 2;
                }
            }
            if (!HierarchicalLayoutManager.this.isDefaultLayout && HierarchicalLayoutManager.this.meanNotMedian) {
                int sum = 0;
                for (int v : values) {
                    sum += v;
                }
                return sum / values.size();
            }
            values.sort(Integer::compare);
            if (values.size() % 2 == 0) {
                return (values.get(values.size() / 2 - 1) + values.get(values.size() / 2)) / 2;
            }
            return values.get(values.size() / 2);
        }

        private void sweepUp() {
            LayoutNode[][] chosenOrder = HierarchicalLayoutManager.this.isDefaultLayout || !HierarchicalLayoutManager.this.bothSort ? this.upProcessingOrder : this.bothProcessingOrder;
            ArrayList<LayoutNode> dangling = new ArrayList<LayoutNode>();
            for (int i = HierarchicalLayoutManager.this.layers.length - 2; i >= 0; --i) {
                NodeRow r = new NodeRow(this.space[i], chosenOrder[i].length);
                LayoutNode last = null;
                for (LayoutNode n : chosenOrder[i]) {
                    if (!HierarchicalLayoutManager.this.isDefaultLayout && HierarchicalLayoutManager.this.isDelayDanglingNodes && (n.succs.isEmpty() && !n.preds.isEmpty() || !n.succs.isEmpty() && this.isAllDanglingSuccs(n))) {
                        n.setDangling(r);
                        dangling.add(n);
                        continue;
                    }
                    int optimal = this.calculateOptimalUp(n, last, dangling.isEmpty());
                    r.insert(n, optimal);
                    last = n;
                }
            }
            this.resolveDanglingNodes(true, dangling);
        }

        private boolean isAllDanglingPreds(LayoutNode n) {
            for (LayoutEdge e : n.preds) {
                if (e.from.isDangling()) continue;
                return false;
            }
            return true;
        }

        private boolean isAllDanglingSuccs(LayoutNode n) {
            if (n.succs.isEmpty()) {
                return false;
            }
            for (LayoutEdge e : n.succs) {
                if (e.to.isDangling()) continue;
                return false;
            }
            return true;
        }

        private void sweepDown() {
            LayoutNode[][] chosenOrder = HierarchicalLayoutManager.this.isDefaultLayout || !HierarchicalLayoutManager.this.bothSort ? this.downProcessingOrder : this.bothProcessingOrder;
            boolean noDefaultAndDelay = !HierarchicalLayoutManager.this.isDefaultLayout && HierarchicalLayoutManager.this.isDelayDanglingNodes;
            ArrayList<LayoutNode> dangling = new ArrayList<LayoutNode>();
            for (int i = 1; i < HierarchicalLayoutManager.this.layers.length; ++i) {
                NodeRow r = new NodeRow(this.space[i], chosenOrder[i].length);
                LayoutNode last = null;
                for (LayoutNode n : chosenOrder[i]) {
                    boolean predsIsEmpty = n.preds.isEmpty();
                    if (noDefaultAndDelay && (predsIsEmpty ? !n.succs.isEmpty() : !dangling.isEmpty() && this.isAllDanglingPreds(n))) {
                        n.setDangling(r);
                        dangling.add(n);
                        continue;
                    }
                    int optimal = this.calculateOptimalDown(n, last, dangling.isEmpty());
                    r.insert(n, optimal);
                    last = n;
                }
            }
            this.resolveDanglingNodes(false, dangling);
        }

        private void resolveDanglingNodes(boolean up, List<LayoutNode> dangling) {
            boolean dir = up;
            boolean force = false;
            LayoutNode[] nodes = dangling.toArray(new LayoutNode[0]);
            Arrays.parallelSort(nodes, up ? DANGLING_UP_NODE_COMPARATOR : DANGLING_DOWN_NODE_COMPARATOR);
            int length = nodes.length;
            while (length > 0) {
                int newResolved = 0;
                SimpleArrayIterator<LayoutNode> iterator = new SimpleArrayIterator<LayoutNode>(nodes, nodes.length);
                while (iterator.hasNext()) {
                    int optimal;
                    NodeRow r;
                    LayoutNode n = iterator.next();
                    if (n == null || (r = n.getDanglingRow()) == null) continue;
                    if (up) {
                        if ((n.preds.isEmpty() || this.isAllDanglingPreds(n)) && (!force || !n.preds.isEmpty())) continue;
                        optimal = this.calculateOptimalDown(n, null, false);
                        r.insert(n, optimal);
                        iterator.clear();
                        n.removeDangling();
                        ++newResolved;
                        continue;
                    }
                    if ((n.succs.isEmpty() || this.isAllDanglingSuccs(n)) && (!force || !n.succs.isEmpty())) continue;
                    optimal = this.calculateOptimalUp(n, null, false);
                    r.insert(n, optimal);
                    iterator.clear();
                    n.removeDangling();
                    ++newResolved;
                }
                if (newResolved != 0) {
                    int i;
                    int finger = -1;
                    for (i = 0; i < length; ++i) {
                        if (nodes[i] != null) continue;
                        finger = i;
                        break;
                    }
                    for (i = finger; i < length; ++i) {
                        if (nodes[i] == null) continue;
                        nodes[finger++] = nodes[i];
                    }
                    if (length - newResolved != finger) {
                        throw new InternalError();
                    }
                }
                if (newResolved != 0 || (length -= newResolved) == 0) continue;
                iterator.reverse();
                up = !up;
                force = up == dir;
            }
        }

        private static class SimpleArrayIterator<T> {
            private final T[] array;
            private final int length;
            private int index = 0;

            public SimpleArrayIterator(T[] array, int length) {
                this.array = array;
                this.length = length;
            }

            public boolean hasNext() {
                return this.index < this.length;
            }

            public T next() {
                return this.array[this.index++];
            }

            public void clear() {
                this.array[this.index - 1] = null;
            }

            private static void swap(Object[] arr, int i, int j) {
                Object tmp = arr[i];
                arr[i] = arr[j];
                arr[j] = tmp;
            }

            public void reverse() {
                int size = this.length;
                int i = 0;
                int mid = size >> 1;
                int j = size - 1;
                while (i < mid) {
                    SimpleArrayIterator.swap(this.array, i, j);
                    ++i;
                    --j;
                }
            }
        }
    }

    private class AssignYCoordinates
    extends AlgorithmPart {
        private AssignYCoordinates() {
        }

        @Override
        protected void run() {
            IntUnaryOperator layerDiff;
            if (HierarchicalLayoutManager.this.isDefaultLayout || !HierarchicalLayoutManager.this.spanByAngle) {
                layerDiff = in -> (int)(Math.sqrt(in) * 2.0);
            } else {
                double coef = Math.tan(Math.toRadians(HierarchicalLayoutManager.this.minEdgeAngle));
                layerDiff = in -> (int)((double)in * coef);
            }
            int curY = 0;
            for (LayoutLayer layer : HierarchicalLayoutManager.this.layers) {
                if (layer.isVisible()) {
                    int maxHeight = layer.height;
                    layer.y = curY;
                    int maxXOffset = 0;
                    for (LayoutNode n : layer) {
                        n.y = curY;
                        if (!n.isDummy()) {
                            n.yOffset = (maxHeight - n.getWholeHeight()) / 2 + n.yOffset;
                            n.y += n.yOffset;
                            n.bottomYOffset = maxHeight - n.yOffset - n.height;
                        }
                        for (LayoutEdge e : n.getVisibleSuccs()) {
                            maxXOffset = Math.max(Math.abs(e.getStartPoint() - e.getEndPoint()), maxXOffset);
                        }
                    }
                    curY += maxHeight + Math.max(layerDiff.applyAsInt(maxXOffset), 24);
                    continue;
                }
                for (LayoutNode n : layer) {
                    n.height = 0;
                    n.y = curY;
                }
                layer.height = 0;
            }
        }
    }

    private class WriteResult
    extends AlgorithmPart {
        private HashMap<Point, Point> pointsIdentity;
        private int pointCount;
        private final int addition = 4;

        private WriteResult() {
            this.addition = 4;
        }

        @Override
        protected void run() {
            Dimension dim;
            HashMap<Link, ArrayList<Point>> splitStartPoints = new HashMap<Link, ArrayList<Point>>();
            HashMap<Link, ArrayList<Point>> splitEndPoints = new HashMap<Link, ArrayList<Point>>();
            this.pointsIdentity = new HashMap();
            HashMap<Vertex, Point> vertexPositions = new HashMap<Vertex, Point>();
            HashMap<Link, List<Point>> linkPositions = new HashMap<Link, List<Point>>();
            for (Vertex v : HierarchicalLayoutManager.this.graph.getVertices()) {
                Iterator n = HierarchicalLayoutManager.this.vertexToLayoutNode.get(v);
                if (HierarchicalLayoutManager.this.standalones && HierarchicalLayoutManager.this.standAlones.contains(n)) continue;
                assert (!vertexPositions.containsKey(v));
                vertexPositions.put(v, new Point(((LayoutNode)((Object)n)).getLeftSide(), ((LayoutNode)((Object)n)).y));
            }
            for (LayoutNode n : HierarchicalLayoutManager.this.nodes) {
                LayoutEdge curEdge;
                LayoutNode cur;
                ArrayList<Point> points;
                if (!HierarchicalLayoutManager.this.layers[n.layer].isVisible()) continue;
                for (LayoutEdge e2 : n.preds) {
                    if (e2.link == null) continue;
                    points = new ArrayList();
                    points.add(new Point(e2.getEndPoint(), e2.to.y));
                    points.add(new Point(e2.getEndPoint(), HierarchicalLayoutManager.this.layers[e2.to.layer].y - 8));
                    cur = e2.from;
                    LayoutNode layoutNode = e2.to;
                    curEdge = e2;
                    while (cur.isDummy() && !cur.preds.isEmpty()) {
                        if (HierarchicalLayoutManager.this.layers[cur.layer].isVisible()) {
                            points.add(new Point(cur.getCenterX(), HierarchicalLayoutManager.this.layers[cur.layer].getBottom() + 8));
                            points.add(new Point(cur.getCenterX(), cur.y - 8));
                        }
                        assert (cur.preds.size() == 1);
                        curEdge = (LayoutEdge)cur.preds.get(0);
                        cur = curEdge.from;
                    }
                    points.add(new Point(curEdge.getStartPoint(), HierarchicalLayoutManager.this.layers[cur.layer].getBottom() + 8));
                    points.add(new Point(curEdge.getStartPoint(), cur.getBottom()));
                    Collections.reverse(points);
                    if (cur.isDummy() && cur.preds.isEmpty()) {
                        if (HierarchicalLayoutManager.this.reversedLinkEndPoints.containsKey(e2.link)) {
                            for (Point p1 : HierarchicalLayoutManager.this.reversedLinkEndPoints.get(e2.link)) {
                                points.add(new Point(p1.x + layoutNode.getLeftSide(), p1.y + layoutNode.y));
                            }
                        }
                        if (splitStartPoints.containsKey(e2.link)) {
                            points.add(0, null);
                            points.addAll(0, (Collection)splitStartPoints.get(e2.link));
                            if (HierarchicalLayoutManager.this.reversedLinks.contains(e2.link)) {
                                Collections.reverse(points);
                            }
                            assert (!linkPositions.containsKey(e2.link));
                            linkPositions.put(e2.link, points);
                        } else {
                            splitEndPoints.put(e2.link, points);
                        }
                    } else {
                        if (HierarchicalLayoutManager.this.reversedLinks.contains(e2.link)) {
                            Collections.reverse(points);
                            if (HierarchicalLayoutManager.this.reversedLinkStartPoints.containsKey(e2.link)) {
                                for (Point p1 : HierarchicalLayoutManager.this.reversedLinkStartPoints.get(e2.link)) {
                                    points.add(new Point(p1.x + cur.getLeftSide(), p1.y + cur.y));
                                }
                            }
                            if (HierarchicalLayoutManager.this.reversedLinkEndPoints.containsKey(e2.link)) {
                                for (Point p1 : HierarchicalLayoutManager.this.reversedLinkEndPoints.get(e2.link)) {
                                    points.add(0, new Point(p1.x + layoutNode.getLeftSide(), p1.y + layoutNode.y));
                                }
                            }
                        }
                        assert (!linkPositions.containsKey(e2.link));
                        linkPositions.put(e2.link, points);
                    }
                    this.pointCount += points.size();
                    e2.link = null;
                }
                for (LayoutEdge e2 : n.succs) {
                    if (e2.link == null) continue;
                    points = new ArrayList<Point>();
                    points.add(new Point(e2.getStartPoint(), e2.from.getBottom()));
                    points.add(new Point(e2.getStartPoint(), HierarchicalLayoutManager.this.layers[e2.from.layer].getBottom() + 8));
                    cur = e2.to;
                    LayoutNode layoutNode = e2.from;
                    curEdge = e2;
                    while (cur.isDummy() && !cur.succs.isEmpty()) {
                        if (HierarchicalLayoutManager.this.layers[cur.layer].isVisible()) {
                            points.add(new Point(cur.getCenterX(), HierarchicalLayoutManager.this.layers[cur.layer].y - 8));
                            points.add(new Point(cur.getCenterX(), HierarchicalLayoutManager.this.layers[cur.layer].getBottom() + 8));
                        }
                        if (cur.succs.isEmpty()) break;
                        assert (cur.succs.size() == 1);
                        curEdge = (LayoutEdge)cur.succs.get(0);
                        cur = curEdge.to;
                    }
                    points.add(new Point(curEdge.getEndPoint(), HierarchicalLayoutManager.this.layers[cur.layer].y - 8));
                    points.add(new Point(curEdge.getEndPoint(), cur.y));
                    if (cur.succs.isEmpty() && cur.isDummy()) {
                        if (HierarchicalLayoutManager.this.reversedLinkStartPoints.containsKey(e2.link)) {
                            for (Point p1 : HierarchicalLayoutManager.this.reversedLinkStartPoints.get(e2.link)) {
                                points.add(0, new Point(p1.x + layoutNode.getLeftSide(), p1.y + layoutNode.y));
                            }
                        }
                        if (splitEndPoints.containsKey(e2.link)) {
                            points.add(null);
                            points.addAll((Collection)splitEndPoints.get(e2.link));
                            if (HierarchicalLayoutManager.this.reversedLinks.contains(e2.link)) {
                                Collections.reverse(points);
                            }
                            assert (!linkPositions.containsKey(e2.link));
                            linkPositions.put(e2.link, points);
                        } else {
                            splitStartPoints.put(e2.link, points);
                        }
                    } else {
                        if (HierarchicalLayoutManager.this.reversedLinks.contains(e2.link)) {
                            if (HierarchicalLayoutManager.this.reversedLinkStartPoints.containsKey(e2.link)) {
                                for (Point p1 : HierarchicalLayoutManager.this.reversedLinkStartPoints.get(e2.link)) {
                                    points.add(0, new Point(p1.x + layoutNode.getLeftSide(), p1.y + layoutNode.y));
                                }
                            }
                            if (HierarchicalLayoutManager.this.reversedLinkEndPoints.containsKey(e2.link)) {
                                for (Point p1 : HierarchicalLayoutManager.this.reversedLinkEndPoints.get(e2.link)) {
                                    points.add(new Point(p1.x + cur.getLeftSide(), p1.y + cur.y));
                                }
                            }
                            Collections.reverse(points);
                        }
                        assert (!linkPositions.containsKey(e2.link));
                        linkPositions.put(e2.link, points);
                    }
                    this.pointCount += points.size();
                    e2.link = null;
                }
            }
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            for (Map.Entry entry : vertexPositions.entrySet()) {
                Vertex vertex = (Vertex)entry.getKey();
                if (!vertex.isVisible()) continue;
                Point p2 = (Point)entry.getValue();
                Dimension s = vertex.getSize();
                minX = Math.min(minX, p2.x);
                minY = Math.min(minY, p2.y);
                maxX = Math.max(maxX, p2.x + s.width);
                maxY = Math.max(maxY, p2.y + s.height);
            }
            for (Map.Entry entry : linkPositions.entrySet()) {
                Link link = (Link)entry.getKey();
                if (!link.getFrom().getVertex().isVisible() || !link.getTo().getVertex().isVisible()) continue;
                for (Point p3 : (List)entry.getValue()) {
                    if (p3 == null) continue;
                    minX = Math.min(minX, p3.x);
                    minY = Math.min(minY, p3.y);
                    maxX = Math.max(maxX, p3.x);
                    maxY = Math.max(maxY, p3.y);
                }
            }
            if (HierarchicalLayoutManager.this.standalones) {
                dim = this.setStandAlones(new Rectangle(minX, minY, maxX - minX, maxY - minY), vertexPositions);
                minY -= dim.height - maxY + minY;
            } else {
                dim = new Dimension(maxX - minX, maxY - minY);
            }
            for (Map.Entry entry : vertexPositions.entrySet()) {
                Point p2 = (Point)entry.getValue();
                p2.x -= minX;
                p2.y -= minY;
                ((Vertex)entry.getKey()).setPosition(p2);
            }
            for (LayoutEdge layoutEdge : HierarchicalLayoutManager.this.longEdges) {
                layoutEdge.from.succs.add(layoutEdge);
                layoutEdge.to.preds.add(layoutEdge);
                linkPositions.put(layoutEdge.link, this.makeLongEnding(layoutEdge));
            }
            if (!HierarchicalLayoutManager.this.edgeBending) {
                for (List list : linkPositions.values()) {
                    list.remove(list.size() - 2);
                    list.remove(1);
                }
            }
            HashMap<Port, List> coLinks = new HashMap<Port, List>();
            for (Map.Entry entry : linkPositions.entrySet()) {
                Link l = (Link)entry.getKey();
                if (l.getFrom().getVertex().isVisible() && l.getTo().getVertex().isVisible()) {
                    coLinks.computeIfAbsent(l.getFrom(), p -> new ArrayList()).add(entry);
                }
                List points = (List)entry.getValue();
                for (Point p4 : points) {
                    if (p4 == null) continue;
                    p4.x -= minX;
                    p4.y -= minY;
                }
            }
            for (List links : coLinks.values()) {
                this.reduceLinksPoints(links);
                links.forEach(e -> ((Link)e.getKey()).setControlPoints((List)e.getValue()));
            }
            assert (this.allLinksSet()) : this.failedLinks();
            HierarchicalLayoutManager.this.graph.setSize(dim);
        }

        private Dimension setStandAlones(Rectangle oldSize, Map<Vertex, Point> vertexPositions) {
            if (HierarchicalLayoutManager.this.standAlones.isEmpty()) {
                return oldSize.getSize();
            }
            int layerOffset = 24;
            int rightSide = oldSize.x + oldSize.width;
            int curY = oldSize.y - layerOffset - (HierarchicalLayoutManager.this.layers.length == 0 ? 0 : HierarchicalLayoutManager.this.layers[0].height);
            int curX = oldSize.x;
            int maxHeight = 0;
            for (LayoutNode n : HierarchicalLayoutManager.this.standAlones) {
                int width = n.getWholeWidth();
                if (curX + width > rightSide) {
                    curX = oldSize.x;
                    curY -= maxHeight + layerOffset;
                    maxHeight = 0;
                }
                Vertex v = n.vertex;
                assert (!vertexPositions.containsKey(v));
                vertexPositions.put(v, new Point(curX, curY));
                curX += width + 8;
                maxHeight = Math.max(maxHeight, n.getWholeHeight());
            }
            return new Dimension(oldSize.width, oldSize.height + oldSize.y - curY);
        }

        private StringBuilder failedLinks() {
            StringBuilder sb = new StringBuilder();
            HierarchicalLayoutManager.this.graph.getLinks().stream().filter(l -> l.getControlPoints().size() < 2 && l.getFrom().getVertex() != l.getTo().getVertex() && l.getTo().getVertex().isVisible() && l.getFrom().getVertex().isVisible()).forEach(l -> sb.append(l).append("\n"));
            return sb;
        }

        private boolean allLinksSet() {
            Link tst = HierarchicalLayoutManager.this.graph.getLinks().stream().findAny().orElse(null);
            if (tst == null || tst.getControlPoints() != tst.getControlPoints()) {
                return true;
            }
            return HierarchicalLayoutManager.this.graph.getLinks().stream().filter(l -> l.getFrom().getVertex() != l.getTo().getVertex() && l.getTo().getVertex().isVisible() && l.getFrom().getVertex().isVisible()).map(l -> l.getControlPoints().size()).allMatch(s -> s > 1);
        }

        private void reduceLinksPoints(List<Map.Entry<Link, List<Point>>> links) {
            Point firstPoint = links.get(0).getValue().get(0);
            ArrayList<Point> points = new ArrayList<Point>();
            points.add(firstPoint);
            ArrayDeque<ReductionEntry> tasks = new ArrayDeque<ReductionEntry>();
            tasks.addAll(this.makeReductionEntries(links, points, firstPoint, 0));
            while (!tasks.isEmpty()) {
                tasks.addAll(this.reducePoints((ReductionEntry)tasks.remove()));
            }
            for (Map.Entry<Link, List<Point>> pnts : links) {
                ArrayList<Point> newPoints = new ArrayList<Point>(pnts.getValue().size());
                for (Point p : pnts.getValue()) {
                    newPoints.add(this.pointsIdentity.computeIfAbsent(p, x -> x));
                }
                pnts.setValue(newPoints);
            }
        }

        private List<ReductionEntry> makeReductionEntries(List<Map.Entry<Link, List<Point>>> entries, List<Point> reducedPoints, Point lastPoint, int lastPointIndex) {
            assert (this.assertCorrectPointAtIndex(entries, reducedPoints, lastPoint, lastPointIndex));
            int nextIndex = lastPointIndex + 1;
            HashMap<Point, List> nexts = new HashMap<Point, List>();
            for (Map.Entry<Link, List<Point>> entry : entries) {
                List<Point> controlPoints = entry.getValue();
                if (controlPoints.size() > nextIndex) {
                    nexts.computeIfAbsent(controlPoints.get(nextIndex), p -> new ArrayList()).add(entry);
                    continue;
                }
                assert (reducedPoints.size() > 1);
                entry.setValue(reducedPoints);
            }
            boolean branching = nexts.size() > 1;
            ArrayList<ReductionEntry> list = new ArrayList<ReductionEntry>();
            for (Map.Entry e : nexts.entrySet()) {
                list.add(new ReductionEntry(lastPoint, nextIndex, (Point)e.getKey(), (List)e.getValue(), branching ? new ArrayList(reducedPoints) : reducedPoints));
            }
            return list;
        }

        private boolean pointsInLine(Point p1, Point p2, Point p3) {
            return p1 != null && p2 != null && p3 != null && (p1.x - p2.x) * (p2.y - p3.y) == (p1.y - p2.y) * (p2.x - p3.x);
        }

        private List<ReductionEntry> reducePoints(ReductionEntry task) {
            boolean multiple;
            Point lastPoint = task.lastPoint;
            Point currentPoint = task.nextPoint;
            int currentIndex = task.nextPointIndex;
            if (currentPoint == null || lastPoint == null) {
                task.reducedPoints.add(currentPoint);
                return this.makeReductionEntries(task.entries, task.reducedPoints, currentPoint, currentIndex);
            }
            List<Point> points = task.entries.get(0).getValue();
            boolean bl = multiple = task.entries.size() > 1;
            while (points.size() > currentIndex + 1) {
                int nextIndex = currentIndex + 1;
                Point nextPoint = points.get(nextIndex);
                if (multiple && !task.entries.stream().map(Map.Entry::getValue).allMatch(pts -> Objects.equals(nextPoint, pts.get(nextIndex)))) break;
                if (!this.pointsInLine(lastPoint, currentPoint, nextPoint)) {
                    task.reducedPoints.add(currentPoint);
                    lastPoint = currentPoint;
                }
                currentPoint = nextPoint;
                currentIndex = nextIndex;
            }
            task.reducedPoints.add(currentPoint);
            return this.makeReductionEntries(task.entries, task.reducedPoints, currentPoint, currentIndex);
        }

        private boolean assertCorrectPointAtIndex(List<Map.Entry<Link, List<Point>>> entries, List<Point> reducedPoints, Point lastPoint, int lastPointIndex) {
            if (!Objects.equals(reducedPoints.get(reducedPoints.size() - 1), lastPoint)) {
                return false;
            }
            for (Map.Entry<Link, List<Point>> entry : entries) {
                if (Objects.equals(entry.getValue().get(lastPointIndex), lastPoint)) continue;
                return false;
            }
            return true;
        }

        private List<Point> makeLongEnding(LayoutEdge e) {
            ArrayList<Point> points = new ArrayList<Point>();
            if (!HierarchicalLayoutManager.this.reversedLinks.contains(e.link)) {
                points.add(new Point(e.getStartPoint(), e.from.getBottom()));
                this.makeLongEndingStart(points);
                points.add(null);
                this.makeLongEndingEnd(points, new Point(e.getEndPoint(), e.to.y));
            } else {
                int diffX = e.from.getLeftSide();
                int diffY = e.from.y;
                for (Point p : HierarchicalLayoutManager.this.reversedLinkStartPoints.get(e.link)) {
                    points.add(new Point(p.x + diffX, p.y + diffY));
                }
                Collections.reverse(points);
                points.add(new Point(((Point)points.get((int)(points.size() - 1))).x, diffY + e.from.height));
                this.makeLongEndingStart(points);
                points.add(null);
                List<Point> ends = HierarchicalLayoutManager.this.reversedLinkEndPoints.get(e.link);
                diffX = e.to.getLeftSide();
                diffY = e.to.y;
                this.makeLongEndingEnd(points, new Point(ends.get((int)0).x + diffX, diffY));
                for (Point p : ends) {
                    points.add(new Point(p.x + diffX, p.y + diffY));
                }
                Collections.reverse(points);
            }
            return points;
        }

        private void makeLongEndingStart(List<Point> points) {
            Point last = points.get(points.size() - 1);
            last = new Point(last.x, last.y + 4);
            points.add(last);
            last = new Point(last.x + 4, last.y + 4);
            points.add(last);
            points.add(new Point(last.x, last.y + 8));
        }

        private void makeLongEndingEnd(List<Point> points, Point last) {
            last = new Point(last.x - 4, last.y - 12);
            points.add(last);
            last = new Point(last.x, last.y + 4);
            points.add(last);
            last = new Point(last.x + 4, last.y + 4);
            points.add(last);
            points.add(new Point(last.x, last.y + 4));
        }

        @Override
        protected void printStatistics() {
            System.out.println("Number of nodes: " + HierarchicalLayoutManager.this.nodes.size());
            int edgeCount = 0;
            for (LayoutNode n : HierarchicalLayoutManager.this.nodes) {
                edgeCount += n.succs.size();
            }
            System.out.println("Number of edges: " + edgeCount);
            System.out.println("Number of points: " + this.pointCount);
        }

        private static class ReductionEntry {
            final Point lastPoint;
            final int nextPointIndex;
            final Point nextPoint;
            final List<Point> reducedPoints;
            final List<Map.Entry<Link, List<Point>>> entries;

            public ReductionEntry(Point lastPoint, int nextPointIndex, Point nextPoint, List<Map.Entry<Link, List<Point>>> entries, List<Point> reducedPoints) {
                this.lastPoint = lastPoint;
                this.nextPointIndex = nextPointIndex;
                this.nextPoint = nextPoint;
                this.entries = entries;
                this.reducedPoints = reducedPoints;
            }
        }
    }

    private class LayoutNode {
        public int x;
        public int y;
        public int width;
        public int height;
        public int layer = -1;
        public int xOffset;
        public int yOffset;
        public int bottomYOffset;
        public final Vertex vertex;
        public final VIPArrayList preds = new VIPArrayList();
        public final VIPArrayList succs = new VIPArrayList();
        public int pos = -1;
        NodeRow dangling;
        public float crossingNumber = 0.0f;

        boolean isDangling() {
            return this.dangling != null;
        }

        private NodeRow getDanglingRow() {
            return this.dangling;
        }

        private void setDangling(NodeRow r) {
            assert (this.dangling == null) : this.dangling;
            this.dangling = r;
        }

        private void removeDangling() {
            assert (this.dangling != null) : this;
            this.dangling = null;
        }

        public int getPos() {
            return this.pos;
        }

        public int getPredsVips() {
            return this.preds.getVips();
        }

        public int getSuccsVips() {
            return this.succs.getVips();
        }

        public void loadCrossingNumber(boolean up) {
            this.crossingNumber = 0.0f;
            int count = this.loadCrossingNumber(up, this);
            this.crossingNumber = count > 0 ? (this.crossingNumber /= (float)count) : 0.0f;
        }

        public int loadCrossingNumber(boolean up, LayoutNode source) {
            int count = 0;
            if (up) {
                for (LayoutEdge e : this.succs) {
                    count += e.loadCrossingNumber(true, source);
                }
            } else {
                for (LayoutEdge e : this.preds) {
                    count += e.loadCrossingNumber(false, source);
                }
            }
            return count;
        }

        public String toString() {
            return "Node " + this.vertex;
        }

        public LayoutNode(Vertex v) {
            this.vertex = v;
            if (v == null) {
                this.height = 1;
                this.width = HierarchicalLayoutManager.this.dummyWidth;
            } else {
                Dimension size = v.getSize();
                this.height = size.height;
                this.width = size.width;
            }
        }

        public LayoutNode() {
            this(null);
        }

        public Collection<LayoutEdge> getVisibleSuccs() {
            ArrayList<LayoutEdge> edges = new ArrayList<LayoutEdge>();
            for (int i = this.layer + 1; i < HierarchicalLayoutManager.this.layerCount; ++i) {
                if (!HierarchicalLayoutManager.this.layers[i].isVisible()) continue;
                Iterator iterator = this.succs.iterator();
                while (iterator.hasNext()) {
                    LayoutEdge e;
                    LayoutEdge last = e = (LayoutEdge)iterator.next();
                    block2: for (int l = this.layer + 1; l < i; ++l) {
                        for (LayoutEdge ed : last.to.succs) {
                            if (ed.link != e.link) continue;
                            last = ed;
                            continue block2;
                        }
                    }
                    if (last == e) {
                        edges.add(e);
                        continue;
                    }
                    edges.add(new LayoutEdge(e.from, last.to, e.relativeFrom, last.relativeTo, e.link, e.vip));
                }
                break;
            }
            return edges;
        }

        public int getLeftSide() {
            return this.xOffset + this.x;
        }

        public int getWholeWidth() {
            return this.xOffset + this.width;
        }

        public int getWholeHeight() {
            return this.height + this.yOffset + this.bottomYOffset;
        }

        public int getRightSide() {
            return this.x + this.getWholeWidth();
        }

        public int getCenterX() {
            return this.getLeftSide() + this.width / 2;
        }

        public int getBottom() {
            return this.y + this.height;
        }

        public boolean isDummy() {
            return this.vertex == null;
        }
    }

    static class VIPArrayList
    extends ArrayList<LayoutEdge> {
        int vips;

        public int getVips() {
            return this.vips;
        }

        VIPArrayList() {
        }

        @Override
        public boolean add(LayoutEdge e) {
            super.add(e);
            if (e.vip) {
                ++this.vips;
            }
            return true;
        }

        @Override
        public boolean remove(Object object) {
            boolean remove = super.remove(object);
            if (remove && ((LayoutEdge)object).vip) {
                --this.vips;
            }
            return remove;
        }

        @Override
        public void clear() {
            super.clear();
            this.vips = 0;
        }
    }

    private class LayoutEdge {
        public LayoutNode from;
        public LayoutNode to;
        public int relativeFrom;
        public int relativeTo;
        public Link link;
        public final boolean vip;

        public int loadCrossingNumber(boolean up, LayoutNode source) {
            if (HierarchicalLayoutManager.this.isDefaultLayout || !HierarchicalLayoutManager.this.isDummyCrossing || !(!up ? this.from.isDummy() : this.to.isDummy())) {
                int factor;
                int n = factor = this.vip ? 10 : 1;
                int nr = !HierarchicalLayoutManager.this.isDefaultLayout && HierarchicalLayoutManager.this.isCrossingByConnDiff ? (up ? (this.getEndPoint() - this.getStartPoint()) * factor : (this.getStartPoint() - this.getEndPoint()) * factor) : (up ? this.getEndPoint() * factor : this.getStartPoint() * factor);
                source.crossingNumber += (float)nr;
                return factor;
            }
            if (up) {
                return this.to.loadCrossingNumber(up, source);
            }
            return this.from.loadCrossingNumber(up, source);
        }

        public int getStartPoint() {
            return this.relativeFrom + this.from.getLeftSide();
        }

        public int getEndPoint() {
            return this.relativeTo + this.to.getLeftSide();
        }

        public LayoutEdge(LayoutNode from, LayoutNode to, int relativeFrom, int relativeTo, Link link, boolean vip) {
            assert (from != null && to != null) : "Dangling LayoutEdge.";
            this.from = from;
            this.to = to;
            this.relativeFrom = relativeFrom;
            this.relativeTo = relativeTo;
            this.link = link;
            this.vip = vip;
        }
    }

    private class ResolvePrevious
    extends AlgorithmPart {
        private ResolvePrevious() {
        }

        @Override
        public void preCheck() {
            for (LayoutNode n : HierarchicalLayoutManager.this.nodes) {
                assert (n.layer == -1);
                assert (n.vertex.getPosition() != null);
            }
        }

        @Override
        protected void run() {
            this.reassignPositions();
            this.recreateLayers();
            this.reassignLayers();
            this.reassignInOutBlockNodes();
            this.reverseEdges();
            this.reassignLayers();
            this.recreateDummyNodes();
            this.reassignLayers();
            this.refreshLayers();
        }

        private void refreshLayers() {
            for (LayoutLayer l : HierarchicalLayoutManager.this.layers) {
                l.refresh();
            }
        }

        private void reverseEdges() {
            for (LayoutNode node : HierarchicalLayoutManager.this.nodes) {
                ArrayList<LayoutEdge> succs = new ArrayList<LayoutEdge>(node.succs);
                for (LayoutEdge e : succs) {
                    assert (e.from == node);
                    if (e.to == node) {
                        node.succs.remove(e);
                        node.preds.remove(e);
                        continue;
                    }
                    if (node.layer <= e.to.layer) continue;
                    HierarchicalLayoutManager.this.reverseEdge(e);
                }
            }
            HierarchicalLayoutManager.this.resolveInsOuts();
        }

        private void recreateDummyNodes() {
            ArrayList<LayoutEdge> edges = new ArrayList<LayoutEdge>();
            for (int i = 0; i < HierarchicalLayoutManager.this.layers.length - 2; ++i) {
                for (LayoutNode n : HierarchicalLayoutManager.this.layers[i]) {
                    if (n.isDummy()) continue;
                    for (LayoutEdge e : n.succs) {
                        List points = e.link.getControlPoints();
                        if (e.to.layer == e.from.layer) {
                            edges.add(e);
                            continue;
                        }
                        if (points.isEmpty()) {
                            if (e.to.layer - e.from.layer <= 1) continue;
                            edges.add(e);
                            continue;
                        }
                        if (((Point)points.get((int)0)).y > ((Point)points.get((int)(points.size() - 1))).y) {
                            Collections.reverse(points);
                        }
                        if (((Point)points.get((int)(points.size() - 1))).y <= HierarchicalLayoutManager.this.layers[i + 1].y) continue;
                        edges.add(e);
                    }
                    if (edges.isEmpty()) continue;
                    this.resolveDummyNodes(n, edges);
                    edges.clear();
                }
            }
        }

        private int getInvisible(int from, int to) {
            int count = 0;
            for (int i = from + 1; i < to; ++i) {
                if (HierarchicalLayoutManager.this.layers[i].visible) continue;
                ++count;
            }
            return count;
        }

        private void resolveDummyNodes(LayoutNode n, List<LayoutEdge> succs) {
            HashMap portHash = new HashMap();
            HashMap<Integer, LayoutNode> topNodeHash = new HashMap<Integer, LayoutNode>();
            HashMap bottomNodeHash = new HashMap();
            for (LayoutEdge e : succs) {
                int invisibleLayers = this.getInvisible(n.layer, e.to.layer);
                assert (e.from.layer <= e.to.layer) : e.from + "=" + e.from.layer + "; " + e.to + "=" + e.to.layer;
                if (e.from.layer == e.to.layer - 1 - invisibleLayers) continue;
                if (HierarchicalLayoutManager.this.maxLayerLength != -1 && e.to.layer - invisibleLayers - e.from.layer > HierarchicalLayoutManager.this.maxLayerLength && !HierarchicalLayoutManager.this.isDrawLongEdges || e.from.layer == e.to.layer) {
                    assert (HierarchicalLayoutManager.this.maxLayerLength > 2);
                    e.to.preds.remove(e);
                    e.from.succs.remove(e);
                    if ((HierarchicalLayoutManager.this.isDefaultLayout || !HierarchicalLayoutManager.this.noDummyLongEdges) && e.from.layer != e.to.layer) {
                        LayoutNode bottomNode;
                        LayoutNode topNode = (LayoutNode)topNodeHash.get(e.relativeFrom);
                        if (topNode == null) {
                            topNode = new LayoutNode();
                            topNode.layer = e.from.layer + 1;
                            HierarchicalLayoutManager.this.nodes.add(topNode);
                            topNodeHash.put(e.relativeFrom, topNode);
                            bottomNodeHash.put(e.relativeFrom, new HashMap());
                        }
                        LayoutEdge topEdge = new LayoutEdge(e.from, topNode, e.relativeFrom, topNode.width / 2, e.link, e.vip);
                        e.from.succs.add(topEdge);
                        topNode.preds.add(topEdge);
                        HashMap hash = (HashMap)bottomNodeHash.get(e.relativeFrom);
                        if (hash.containsKey(e.to.layer)) {
                            bottomNode = (LayoutNode)hash.get(e.to.layer);
                        } else {
                            bottomNode = new LayoutNode();
                            bottomNode.layer = e.to.layer - 1;
                            HierarchicalLayoutManager.this.nodes.add(bottomNode);
                            hash.put(e.to.layer, bottomNode);
                        }
                        LayoutEdge bottomEdge = new LayoutEdge(bottomNode, e.to, bottomNode.width / 2, e.relativeTo, e.link, e.vip);
                        e.to.preds.add(bottomEdge);
                        bottomNode.succs.add(bottomEdge);
                        continue;
                    }
                    HierarchicalLayoutManager.this.longEdges.add(e);
                    continue;
                }
                Integer i = e.relativeFrom;
                if (!portHash.containsKey(i)) {
                    portHash.put(i, new ArrayList());
                }
                ((List)portHash.get(i)).add(e);
            }
            for (LayoutEdge e : succs) {
                Integer i = e.relativeFrom;
                if (!portHash.containsKey(i)) continue;
                List list = (List)portHash.get(i);
                if (list.size() == 1) {
                    this.resolveDummyNodes((LayoutEdge)list.get(0));
                } else {
                    list.sort(LAYER_COMPARATOR);
                    int maxLayer = ((LayoutEdge)list.get((int)(list.size() - 1))).to.layer;
                    int cnt = maxLayer - n.layer - 1;
                    LayoutEdge[] edges = new LayoutEdge[cnt];
                    LayoutNode[] nodes = new LayoutNode[cnt];
                    nodes[0] = new LayoutNode();
                    nodes[0].layer = n.layer + 1;
                    HierarchicalLayoutManager.this.layers[nodes[0].layer].add(nodes[0]);
                    nodes[0].y = HierarchicalLayoutManager.this.layers[nodes[0].layer].y;
                    edges[0] = new LayoutEdge(n, nodes[0], i, nodes[0].width / 2, null, e.vip);
                    nodes[0].preds.add(edges[0]);
                    n.succs.add(edges[0]);
                    for (int j = 1; j < cnt; ++j) {
                        nodes[j] = new LayoutNode();
                        nodes[j].layer = n.layer + j + 1;
                        edges[j] = new LayoutEdge(nodes[j - 1], nodes[j], nodes[j - 1].width / 2, nodes[j].width / 2, null, e.vip);
                        nodes[j - 1].succs.add(edges[j]);
                        nodes[j].preds.add(edges[j]);
                        HierarchicalLayoutManager.this.layers[nodes[j].layer].add(nodes[j]);
                        nodes[j].y = HierarchicalLayoutManager.this.layers[nodes[j].layer].y;
                    }
                    this.resolveDummyNodes(list, nodes);
                    for (LayoutEdge curEdge : list) {
                        assert (curEdge.to.layer - n.layer - 2 >= 0);
                        assert (curEdge.to.layer - n.layer - 2 < cnt);
                        LayoutNode anchor = nodes[curEdge.to.layer - n.layer - 2];
                        for (int l = 0; l < curEdge.to.layer - n.layer - 1; ++l) {
                            anchor = nodes[l];
                        }
                        anchor.succs.add(curEdge);
                        curEdge.from = anchor;
                        curEdge.relativeFrom = anchor.width / 2;
                        n.succs.remove(curEdge);
                    }
                    HierarchicalLayoutManager.this.nodes.addAll(Arrays.asList(nodes));
                }
                portHash.remove(i);
            }
        }

        private void reassignInOutBlockNodes() {
            for (Vertex v : HierarchicalLayoutManager.this.graph.getVertices()) {
                if (!(v instanceof ClusterSlotNode)) continue;
                LayoutNode n = HierarchicalLayoutManager.this.vertexToLayoutNode.get(v);
                HierarchicalLayoutManager.this.layers[n.layer].remove(n);
                n.layer = ((ClusterSlotNode)v).isInputSlot() ? 0 : HierarchicalLayoutManager.this.layerCount - 1;
                HierarchicalLayoutManager.this.layers[n.layer].add(n);
            }
            ArrayList<LayoutLayer> lay = new ArrayList<LayoutLayer>();
            for (LayoutLayer l : HierarchicalLayoutManager.this.layers) {
                if (l.isEmpty()) continue;
                lay.add(l);
            }
            HierarchicalLayoutManager.this.layers = lay.toArray(new LayoutLayer[0]);
            HierarchicalLayoutManager.this.layerCount = HierarchicalLayoutManager.this.layers.length;
        }

        private void resolveDummyNodes(LayoutEdge edge) {
            double startX = edge.getStartPoint();
            double endX = edge.getEndPoint();
            double startY = edge.from.y;
            double endY = edge.to.y;
            int startLayer = edge.from.layer + 1;
            int endLayer = edge.to.layer - 1;
            double coef = (endX - startX) / (endY - startY);
            for (int i = 0; i <= endLayer - startLayer; ++i) {
                int layer = startLayer + i;
                LayoutLayer addedLayer = HierarchicalLayoutManager.this.layers[layer];
                LayoutNode dummy = new LayoutNode();
                dummy.layer = layer + 1;
                LayoutEdge e = new LayoutEdge(edge.from, dummy, edge.relativeFrom, dummy.width / 2, null, edge.vip);
                edge.from.succs.remove(edge);
                edge.from.succs.add(e);
                edge.from = dummy;
                edge.relativeFrom = dummy.width / 2;
                dummy.succs.add(edge);
                dummy.preds.add(e);
                dummy.x = (int)(startX + ((double)addedLayer.y - startY) * coef);
                dummy.y = addedLayer.y;
                addedLayer.add(dummy);
            }
        }

        private void resolveDummyNodes(List<LayoutEdge> edges, LayoutNode[] nodes) {
            LayoutEdge edge = edges.get(edges.size() - 1);
            int layer = edge.from.layer + 1;
            List<Integer> positions = this.resolveEdgePoints(edges);
            LayoutLayer nextLayer = HierarchicalLayoutManager.this.layers[layer++];
            for (int i = 0; i < positions.size(); ++i) {
                LayoutNode dummy = nodes[i];
                dummy.x = positions.get(i);
                dummy.y = nextLayer.y;
                nextLayer = HierarchicalLayoutManager.this.layers[layer + i];
            }
        }

        private List<Integer> resolveEdgePoints(List<LayoutEdge> edges) {
            ArrayList<Integer> positions = new ArrayList<Integer>();
            LayoutEdge edge = this.getLastFullEdge(edges);
            if (edge != null) {
                LayoutEdge longestEdge = edges.get(edges.size() - 1);
                List points = edge.link.getControlPoints();
                int layer = edge.from.layer + 1;
                Point pointA = (Point)points.get(0);
                int lastLayer = edge.to.layer;
                LayoutLayer nextLayer = HierarchicalLayoutManager.this.layers[layer];
                for (int i = 1; i < points.size(); ++i) {
                    int avgY;
                    Point pointB = (Point)points.get(i);
                    if (pointA.x == pointB.x && (avgY = (pointA.y + pointB.y) / 2) > nextLayer.y && avgY < nextLayer.y + nextLayer.height) {
                        if (layer == lastLayer) {
                            if (longestEdge.to.layer != lastLayer) break;
                            return positions;
                        }
                        positions.add(pointA.x);
                        nextLayer = HierarchicalLayoutManager.this.layers[++layer];
                    }
                    pointA = pointB;
                }
            }
            return this.resolveUnconnectedEdges(positions, edges);
        }

        private List<Integer> resolveUnconnectedEdges(List<Integer> positions, List<LayoutEdge> edges) {
            ArrayList<LayoutEdge> list = new ArrayList<LayoutEdge>();
            for (LayoutEdge edge : edges) {
                if (!edge.link.getControlPoints().contains(null) && !edge.link.getControlPoints().isEmpty()) continue;
                list.add(edge);
            }
            edges = list;
            if (edges.isEmpty()) {
                return positions;
            }
            LayoutEdge firstEdge = edges.get(0);
            int fromLayer = firstEdge.from.layer;
            int toLayer = edges.get((int)(edges.size() - 1)).to.layer;
            ArrayList<ArrayList<LayoutEdge>> packedEdges = new ArrayList<ArrayList<LayoutEdge>>();
            for (int i = fromLayer; i < toLayer - 1; ++i) {
                packedEdges.add(null);
            }
            for (LayoutEdge e : edges) {
                int index = e.to.layer - fromLayer - 2;
                ArrayList<LayoutEdge> el = (ArrayList<LayoutEdge>)packedEdges.get(index);
                if (el == null) {
                    el = new ArrayList<LayoutEdge>();
                    packedEdges.set(index, el);
                }
                el.add(e);
            }
            int lastLayer = fromLayer + positions.size();
            int misses = -positions.size();
            int lX = positions.isEmpty() ? firstEdge.getStartPoint() : positions.get(positions.size() - 1).intValue();
            int fX = 0;
            for (List list2 : packedEdges) {
                if (list2 == null) {
                    ++misses;
                    continue;
                }
                for (LayoutEdge ed : list2) {
                    fX += ed.getEndPoint();
                }
                fX /= list2.size();
                if (misses > 0) {
                    this.resolveBetweenLongEdges(positions, lX, fX, lastLayer, misses);
                    lastLayer += misses;
                    misses = 0;
                } else {
                    ++lastLayer;
                }
                positions.add(fX);
                lX = fX;
                fX = 0;
            }
            return positions;
        }

        private void resolveBetweenLongEdges(List<Integer> positions, double startX, double endX, int lastLayer, int count) {
            double startY = HierarchicalLayoutManager.this.layers[lastLayer].y;
            double endY = HierarchicalLayoutManager.this.layers[lastLayer + count].y;
            double coef = (endX - startX) / (endY - startY);
            for (int i = lastLayer + 1; i <= lastLayer + count; ++i) {
                positions.add((int)(startX + ((double)HierarchicalLayoutManager.this.layers[i].y - startY) * coef));
            }
        }

        private LayoutEdge getLastFullEdge(List<LayoutEdge> edges) {
            for (int i = edges.size() - 1; i >= 0; --i) {
                LayoutEdge edge = edges.get(i);
                if (edge.link.getControlPoints().contains(null) || edge.link.getControlPoints().isEmpty()) continue;
                return edge;
            }
            return null;
        }

        private void reassignPositions() {
            for (LayoutNode n : HierarchicalLayoutManager.this.nodes) {
                Point position = n.vertex.getPosition();
                n.x = position.x;
                n.y = position.y;
            }
        }

        private void recreateLayers() {
            ArrayList<LayoutLayer> layers = new ArrayList<LayoutLayer>();
            for (LayoutNode n : HierarchicalLayoutManager.this.nodes) {
                int nodeHeight = n.getWholeHeight();
                if (n.vertex instanceof ClusterNode) {
                    nodeHeight = n.vertex.getCluster().getBounds().height;
                }
                boolean assigned = false;
                int avgPos = n.y + nodeHeight / 2;
                for (LayoutLayer l2 : layers) {
                    int lBot = l2.getBottom();
                    if (avgPos <= l2.y || avgPos >= lBot) continue;
                    l2.add(n);
                    l2.y = Math.min(l2.y, n.y - n.yOffset);
                    l2.height = Math.max(l2.height, l2.height + n.y + nodeHeight - l2.getBottom());
                    assigned = true;
                    break;
                }
                if (assigned) continue;
                LayoutLayer l3 = new LayoutLayer();
                layers.add(l3);
                l3.add(n);
                l3.y = n.y - n.yOffset;
                l3.height = nodeHeight;
            }
            for (LayoutLayer l4 : layers) {
                l4.refresh();
            }
            layers.sort(Comparator.comparingInt(l -> l.y));
            HierarchicalLayoutManager.this.layers = layers.toArray(new LayoutLayer[0]);
            HierarchicalLayoutManager.this.layerCount = layers.size();
        }

        private void reassignLayers() {
            for (int i = 0; i < HierarchicalLayoutManager.this.layers.length; ++i) {
                LayoutLayer layer = HierarchicalLayoutManager.this.layers[i];
                int p = 0;
                while (p < layer.size()) {
                    LayoutNode n = (LayoutNode)layer.get(p);
                    n.pos = p++;
                    n.layer = i;
                }
            }
        }

        @Override
        public void postCheck() {
            for (LayoutNode n : HierarchicalLayoutManager.this.nodes) {
                assert (n.layer >= 0);
                assert (n.layer < HierarchicalLayoutManager.this.layerCount);
                for (LayoutEdge e : n.succs) {
                    assert (e.from.layer < e.to.layer);
                }
            }
        }
    }

    private class NodeRow {
        private final ArrayList<LayoutNode> positions = new ArrayList();
        private final int[] space;
        static final Comparator<LayoutNode> COMPARATOR = Comparator.comparingInt(LayoutNode::getPos);

        public NodeRow(int[] space, int length) {
            this.space = space;
        }

        public int offset(LayoutNode n1, LayoutNode n2) {
            int v1 = this.space[n1.pos] + n1.getWholeWidth();
            int v2 = this.space[n2.pos];
            return v2 - v1;
        }

        public void insert(LayoutNode n, int pos) {
            LayoutNode rightNeighbor;
            int minX = Integer.MIN_VALUE;
            int idx = Collections.binarySearch(this.positions, n, COMPARATOR);
            if (idx > 0) {
                throw new IllegalArgumentException("already in list");
            }
            int insertPos = -idx - 1;
            LayoutNode leftNeighbor = insertPos > 0 ? this.positions.get(insertPos - 1) : null;
            LayoutNode layoutNode = rightNeighbor = insertPos < this.positions.size() ? this.positions.get(insertPos) : null;
            if (leftNeighbor != null) {
                minX = leftNeighbor.getRightSide() + this.offset(leftNeighbor, n);
            }
            if (pos < minX) {
                n.x = minX;
            } else {
                int maxX = Integer.MAX_VALUE;
                if (rightNeighbor != null) {
                    maxX = rightNeighbor.x - this.offset(n, rightNeighbor) - n.getWholeWidth();
                }
                n.x = Math.min(pos, maxX);
                assert (minX <= maxX) : minX + " vs " + maxX;
            }
            this.positions.add(insertPos, n);
        }
    }

    private class LayoutLayer
    extends ArrayList<LayoutNode> {
        private boolean visible = false;
        private int minimalWidth;
        private int height;
        private int y;

        private LayoutLayer() {
            this.minimalWidth = -HierarchicalLayoutManager.this.offset;
            this.height = 0;
            this.y = 0;
        }

        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public boolean addAll(Collection<? extends LayoutNode> c) {
            c.forEach(this::add0);
            return super.addAll(c);
        }

        private void add0(LayoutNode n) {
            this.visible = this.visible || !n.isDummy();
            this.height = Math.max(this.height, n.getWholeHeight());
            this.minimalWidth += n.getWholeWidth() + HierarchicalLayoutManager.this.offset;
        }

        @Override
        public boolean add(LayoutNode n) {
            this.add0(n);
            return super.add(n);
        }

        private boolean remove0(LayoutNode n) {
            this.minimalWidth -= n.getWholeWidth() + HierarchicalLayoutManager.this.offset;
            return true;
        }

        @Override
        public boolean remove(Object o) {
            return o instanceof LayoutNode && super.remove(o) && this.remove0((LayoutNode)o);
        }

        public int getBottom() {
            return this.y + this.height;
        }

        public int getMinimalWidth() {
            return this.minimalWidth;
        }

        public int getActualWidth() {
            LayoutNode n = (LayoutNode)this.get(this.size() - 1);
            return n.x + n.width - ((LayoutNode)this.get((int)0)).x;
        }

        public void refresh() {
            this.visible = false;
            this.minimalWidth = -HierarchicalLayoutManager.this.offset;
            this.height = 0;
            this.y = Integer.MAX_VALUE;
            for (LayoutNode n : this) {
                this.y = Math.min(this.y, n.y - n.yOffset);
                this.visible = this.visible || !n.isDummy();
                this.height = Math.max(this.height, n.getWholeHeight());
                this.minimalWidth += n.getWholeWidth() + HierarchicalLayoutManager.this.offset;
            }
        }
    }

    private abstract class AlgorithmPart {
        private AlgorithmPart() {
        }

        public void start() {
            try {
                indent.set(indent.get() + 2);
                long start = HierarchicalLayoutManager.this.traceBegin(this.getClass());
                this.run();
                HierarchicalLayoutManager.this.traceEnd(start, this.getClass());
            }
            finally {
                indent.set(indent.get() - 2);
            }
            if (HierarchicalLayoutManager.this.trace) {
                this.printStatistics();
            }
        }

        protected abstract void run();

        protected void printStatistics() {
        }

        protected void postCheck() {
        }

        protected void preCheck() {
        }
    }
}

