/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedCountingConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNodeGen;
import com.oracle.truffle.js.nodes.control.IfNode;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@GeneratedBy(value=IfNode.class)
public final class IfNodeGen
extends IfNode
implements Introspection.Provider {
    private static final InlineSupport.StateField STATE_0_IfNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
    private static final InlinedCountingConditionProfile INLINED_PROFILE = InlinedCountingConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedCountingConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{InlineSupport.IntField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"profile_field0_"), InlineSupport.IntField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"profile_field1_")}));
    private static final JSToBooleanNode INLINED_OBJECT_TO_BOOLEAN_NODE_ = JSToBooleanNodeGen.inline(InlineSupport.InlineTarget.create(JSToBooleanNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_IfNode_UPDATER.subUpdater(2, 15), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"object_toBooleanNode__field1_", Node.class)}));
    @CompilerDirectives.CompilationFinal
    @InlineSupport.UnsafeAccessedField
    private int state_0_;
    @CompilerDirectives.CompilationFinal
    @InlineSupport.UnsafeAccessedField
    private int profile_field0_;
    @CompilerDirectives.CompilationFinal
    @InlineSupport.UnsafeAccessedField
    private int profile_field1_;
    @Node.Child
    @InlineSupport.UnsafeAccessedField
    private Node object_toBooleanNode__field1_;

    private IfNodeGen(JavaScriptNode condition, JavaScriptNode thenPart, JavaScriptNode elsePart) {
        super(condition, thenPart, elsePart);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 2) == 0 && (state_0 & 3) != 0) {
            return this.execute_boolean0(state_0, frameValue);
        }
        return this.execute_generic1(state_0, frameValue);
    }

    private Object execute_boolean0(int state_0__, VirtualFrame frameValue) {
        boolean conditionValue_;
        int state_0 = state_0__;
        try {
            conditionValue_ = this.condition.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, ex.getResult());
        }
        assert ((state_0 & 1) != 0);
        return this.doBoolean(frameValue, conditionValue_, INLINED_PROFILE);
    }

    private Object execute_generic1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object conditionValue_ = this.condition.execute(frameValue);
        if ((state_0 & 3) != 0) {
            if ((state_0 & 1) != 0 && conditionValue_ instanceof Boolean) {
                boolean conditionValue__ = (Boolean)conditionValue_;
                return this.doBoolean(frameValue, conditionValue__, INLINED_PROFILE);
            }
            if ((state_0 & 2) != 0) {
                return this.doObject(frameValue, conditionValue_, INLINED_OBJECT_TO_BOOLEAN_NODE_, INLINED_PROFILE);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, conditionValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    private Object executeAndSpecialize(VirtualFrame frameValue, Object conditionValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 2) == 0 && conditionValue instanceof Boolean) {
            boolean conditionValue_ = (Boolean)conditionValue;
            this.state_0_ = state_0 |= 1;
            return this.doBoolean(frameValue, conditionValue_, INLINED_PROFILE);
        }
        state_0 &= 0xFFFFFFFE;
        this.state_0_ = state_0 |= 2;
        return this.doObject(frameValue, conditionValue, INLINED_OBJECT_TO_BOOLEAN_NODE_, INLINED_PROFILE);
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 3) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 3 & (state_0 & 3) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[3];
        data[0] = 0;
        int state_0 = this.state_0_;
        Object[] s = new Object[3];
        s[0] = "doBoolean";
        if ((state_0 & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            cached.add(Arrays.asList(INLINED_PROFILE));
            s[2] = cached;
        }
        if (s[1] == null) {
            s[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doObject";
        if ((state_0 & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(new Object[]{INLINED_OBJECT_TO_BOOLEAN_NODE_, INLINED_PROFILE}));
            s[2] = cached;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[2] = s;
        return Introspection.Provider.create((Object[])data);
    }

    @NeverDefault
    public static IfNode create(JavaScriptNode condition, JavaScriptNode thenPart, JavaScriptNode elsePart) {
        return new IfNodeGen(condition, thenPart, elsePart);
    }
}

