/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.selectioncoordinator;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import jdk.graal.compiler.graphio.parsing.model.ChangedEvent;
import jdk.graal.compiler.graphio.parsing.model.GraphContainer;

public class SelectionCoordinator {
    private static final Map<GraphContainer, SelectionCoordinator> INSTANCES = new WeakHashMap<GraphContainer, SelectionCoordinator>();
    private static final SelectionCoordinator SINGLETON = new SelectionCoordinator();
    private final Set<Object> selectedObjects;
    private final Set<Object> highlightedObjects;
    private final ChangedEvent<SelectionCoordinator> selectedChangedEvent = new ChangedEvent((Object)this);
    private final ChangedEvent<SelectionCoordinator> highlightedChangedEvent = new ChangedEvent((Object)this);

    @Deprecated
    public static SelectionCoordinator getInstance() {
        return SINGLETON;
    }

    public static SelectionCoordinator getInstanceForContainer(GraphContainer container) {
        SelectionCoordinator coordinator = INSTANCES.get(container);
        if (coordinator == null) {
            coordinator = new SelectionCoordinator();
            INSTANCES.put(container, coordinator);
        }
        return coordinator;
    }

    private SelectionCoordinator() {
        this.selectedObjects = new HashSet<Object>();
        this.highlightedObjects = new HashSet<Object>();
    }

    public Set<Object> getSelectedObjects() {
        return Collections.unmodifiableSet(this.selectedObjects);
    }

    public Set<Object> getHighlightedObjects() {
        return Collections.unmodifiableSet(this.highlightedObjects);
    }

    public ChangedEvent<SelectionCoordinator> getHighlightedChangedEvent() {
        return this.highlightedChangedEvent;
    }

    public ChangedEvent<SelectionCoordinator> getSelectedChangedEvent() {
        return this.selectedChangedEvent;
    }

    public void addHighlighted(Object o) {
        if (!this.highlightedObjects.contains(o)) {
            this.highlightedObjects.add(o);
            this.highlightedObjectsChanged();
        }
    }

    public void removeHighlighted(Object o) {
        if (this.highlightedObjects.contains(o)) {
            this.highlightedObjects.remove(o);
            this.highlightedObjectsChanged();
        }
    }

    public void addAllHighlighted(Set<? extends Object> s) {
        int oldSize = this.highlightedObjects.size();
        this.highlightedObjects.addAll(s);
        if (oldSize != this.highlightedObjects.size()) {
            this.highlightedObjectsChanged();
        }
    }

    public void removeAllHighlighted(Set<? extends Object> s) {
        int oldSize = this.highlightedObjects.size();
        this.highlightedObjects.removeAll(s);
        if (oldSize != this.highlightedObjects.size()) {
            this.highlightedObjectsChanged();
        }
    }

    private void highlightedObjectsChanged() {
        this.highlightedChangedEvent.fire();
    }

    public void addSelected(Object o) {
        if (!this.selectedObjects.contains(o)) {
            this.selectedObjects.add(o);
            this.selectedObjectsChanged();
        }
    }

    public void removeSelected(Object o) {
        if (this.selectedObjects.contains(o)) {
            this.selectedObjects.remove(o);
            this.selectedObjectsChanged();
        }
    }

    public void addAllSelected(Set<? extends Object> s) {
        int oldSize = this.selectedObjects.size();
        this.selectedObjects.addAll(s);
        if (oldSize != this.selectedObjects.size()) {
            this.selectedObjectsChanged();
        }
    }

    public void removeAllSelected(Set<? extends Object> s) {
        int oldSize = this.selectedObjects.size();
        this.selectedObjects.removeAll(s);
        if (oldSize != this.selectedObjects.size()) {
            this.selectedObjectsChanged();
        }
    }

    public void setSelectedObjects(Set<? extends Object> s) {
        assert (s != null);
        this.selectedObjects.clear();
        this.selectedObjects.addAll(s);
        this.selectedObjectsChanged();
    }

    private void selectedObjectsChanged() {
        this.selectedChangedEvent.fire();
    }

    public void setHighlightedObjects(Set<? extends Object> s) {
        assert (s != null);
        this.highlightedObjects.clear();
        this.highlightedObjects.addAll(s);
        this.highlightedObjectsChanged();
    }
}

