/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import jdk.graal.compiler.graphio.parsing.model.ChangedEvent;
import jdk.graal.compiler.graphio.parsing.model.ChangedListener;
import jdk.graal.compiler.graphio.parsing.model.DataCollectionListener;
import jdk.graal.compiler.graphio.parsing.model.Folder;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.graalvm.visualizer.data.services.GraphSelections;
import org.graalvm.visualizer.data.services.InputGraphProvider;
import org.graalvm.visualizer.filter.DataFilterSelector;
import org.graalvm.visualizer.filter.FilterChain;
import org.graalvm.visualizer.filter.FilterSequence;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.graph.services.DiagramProvider;
import org.graalvm.visualizer.settings.layout.LayoutSettings;
import org.graalvm.visualizer.util.ExternalDropTarget;
import org.graalvm.visualizer.util.ListenerSupport;
import org.graalvm.visualizer.util.LookupHistory;
import org.graalvm.visualizer.util.RangeSliderModel;
import org.graalvm.visualizer.view.Bundle;
import org.graalvm.visualizer.view.DiagramScene;
import org.graalvm.visualizer.view.DiagramViewModel;
import org.graalvm.visualizer.view.EditorInputGraphProvider;
import org.graalvm.visualizer.view.ExportCookie;
import org.graalvm.visualizer.view.SliderPanel;
import org.graalvm.visualizer.view.api.DiagramViewer;
import org.graalvm.visualizer.view.api.DiagramViewerLocator;
import org.graalvm.visualizer.view.api.TimelineModel;
import org.graalvm.visualizer.view.impl.Colorizer;
import org.graalvm.visualizer.view.impl.GraphCoordinator;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Widget;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.Toolbar;
import org.openide.awt.ToolbarPool;
import org.openide.awt.ToolbarWithOverflow;
import org.openide.awt.UndoRedo;
import org.openide.filesystems.FileObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public final class EditorTopComponent
extends TopComponent
implements PropertyChangeListener,
ChangeListener,
UndoRedo.Provider {
    public static String PROP_SATELLITE_SHOWN = "satelliteShown";
    public static final String MODE = "mainArea";
    public static final String TOOLBAR_ACTIONS = "NodeGraphViewer/Actions";
    public static final String CONTEXT_ACTIONS = "NodeGraphViewer/ContextActions";
    public static final String SELECTION_ACTIONS = "NodeGraphViewer/SelectionActions";
    private DiagramScene scene;
    private InstanceContent graphContent;
    private boolean notFirstTime;
    private final JComponent satelliteComponent;
    private final JPanel centerPanel;
    private final CardLayout cardLayout;
    private final TimelineModel timeline;
    private JComponent rangeSliderArea;
    private static final String PREFERRED_ID = "EditorTopComponent";
    private static final String SATELLITE_STRING = "satellite";
    private static final String SCENE_STRING = "scene";
    private DiagramViewModel rangeSliderModel;
    private Component quicksearch;
    private JComponent toolbarContainer;
    private Toolbar toolbar;
    private Colorizer timelineColorizer;
    private InputGraphProvider graphProvider;
    private DropTarget dt;
    private final TitleUpdater titleUpdater;
    private ExportCookie exportCookie = new ExportCookie(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void export(File f) {
            DOMImplementation dom = GenericDOMImplementation.getDOMImplementation();
            Document document = dom.createDocument("http://www.w3.org/2000/svg", "svg", null);
            SVGGeneratorContext ctx = SVGGeneratorContext.createDefault((Document)document);
            ctx.setEmbeddedFontsOn(true);
            SVGGraphics2D svgGenerator = new SVGGraphics2D(ctx, true);
            EditorTopComponent.this.scene.paint((Graphics2D)svgGenerator);
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(f);
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)os, "UTF-8");
                assert (svgGenerator instanceof SVGGraphics2D);
                SVGGraphics2D svgGraphics = svgGenerator;
                svgGraphics.stream((Writer)out, true);
            }
            catch (IOException e) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)Bundle.EXPORT_BATIK_ErrorExportingSVG(e.toString()), 0);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    };
    private GraphSelections selectionsBridge = new GraphSelections(){

        public InputGraph getGraph() {
            return EditorTopComponent.this.getModel().getGraphToView();
        }

        public Collection<InputNode> getSelectedNodes() {
            return EditorTopComponent.this.getModel().getSelectedNodes();
        }

        public void setSelectedNodes(Collection<InputNode> nodes) {
            EditorTopComponent.this.scene.gotoSelection(new HashSet<InputNode>(nodes));
        }

        public void extractNodes(Collection<InputNode> nodes) {
            EditorTopComponent.this.getModel().showOnlyNodes(nodes);
        }

        public void scrollToVisible(Collection<InputNode> nodes) {
            EditorTopComponent.this.scene.gotoNodes(new HashSet<InputNode>(nodes), false);
        }
    };
    private DiagramProvider diagramProvider = new DiagramProvider(){

        public Diagram getDiagram() {
            return EditorTopComponent.this.getModel().getDiagramToView();
        }

        public ChangedEvent<DiagramProvider> getChangedEvent() {
            return EditorTopComponent.this.diagramChangedEvent;
        }

        public Future<Diagram> withDiagram(Consumer<Diagram> task) {
            return EditorTopComponent.this.getModel().withDiagramToView(task);
        }
    };
    private ChangedEvent<DiagramProvider> diagramChangedEvent = new ChangedEvent((Object)this.diagramProvider);
    private final DataCollectionListener dcl = ev -> {
        Group g = this.getModel().getContainer().getContentOwner();
        for (FolderElement e : ev.getItems()) {
            if (!(e instanceof Folder) || !((Folder)e).isParentOf((FolderElement)g)) continue;
            SwingUtilities.invokeLater(() -> ((EditorTopComponent)this).close());
            return;
        }
    };
    private final DataCollectionListener wDcl;
    private static final Insets BUTTON_INSETS = new Insets(2, 1, 0, 1);
    private static final MouseListener sharedMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent evt) {
            AbstractButton button;
            Object src = evt.getSource();
            if (src instanceof AbstractButton && (button = (AbstractButton)evt.getSource()).isEnabled()) {
                button.setContentAreaFilled(true);
                button.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            Object src = evt.getSource();
            if (src instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)evt.getSource();
                EditorTopComponent.removeButtonContentAreaAndBorder(button);
            }
        }
    };
    private PropertyChangeListener colorizerNodesUpdater = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Collection<InputNode> nodes = EditorTopComponent.this.rangeSliderModel.getSelectedNodes();
            HashSet<Integer> ids = new HashSet<Integer>(nodes.size());
            for (InputNode n : nodes) {
                ids.add(n.getId());
            }
            EditorTopComponent.this.timelineColorizer.setTrackedNodes(ids);
        }
    };
    private JCheckBox jCheckBox1;
    private final ChangedListener<DiagramViewModel> diagramChangedListener = new ChangedListener<DiagramViewModel>(){

        public void changed(DiagramViewModel source) {
            if (!source.isValid()) {
                SwingUtilities.invokeLater(() -> ((EditorTopComponent)EditorTopComponent.this).close());
                return;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(source.getGraphToView());
            list.add(EditorTopComponent.this.newGraphProvider());
            EditorTopComponent.this.graphContent.set(list, null);
            EditorTopComponent.this.diagramChangedEvent.fire();
        }
    };

    protected void componentOpened() {
        super.componentOpened();
        GraphCoordinator c = (GraphCoordinator)Lookup.getDefault().lookup(GraphCoordinator.class);
        c.registerSynchronizedModel(this.timeline, this);
    }

    private void processButton(AbstractButton button) {
        if (button == null) {
            return;
        }
        EditorTopComponent.removeButtonContentAreaAndBorder(button);
        button.setMargin(BUTTON_INSETS);
        button.addMouseListener(sharedMouseListener);
        button.setFocusable(false);
    }

    private static void removeButtonContentAreaAndBorder(AbstractButton button) {
        boolean canRemove = true;
        if (button instanceof JToggleButton) {
            boolean bl = canRemove = !button.isSelected();
        }
        if (canRemove) {
            button.setContentAreaFilled(false);
            button.setBorderPainted(false);
        }
    }

    public EditorTopComponent(InputGraph graph, TimelineModel timeline) {
        LookupHistory.init(InputGraphProvider.class);
        LookupHistory.init(DiagramProvider.class);
        LookupHistory.init(GraphSelections.class);
        LookupHistory.init(DiagramViewer.class);
        LayoutSettings.obtain().addWeakChangeListener((ChangeListener)this);
        this.setFocusable(true);
        Object filterChain = null;
        DataFilterSelector provider = (DataFilterSelector)Lookup.getDefault().lookup(DataFilterSelector.class);
        PL lkp = new PL();
        InstanceContent content = new InstanceContent();
        content.add((Object)this.diagramProvider);
        content.add((Object)this);
        AbstractLookup cl = new AbstractLookup((AbstractLookup.Content)content);
        lkp.accessSetLookups(new Lookup[]{cl});
        filterChain = provider == null ? new FilterChain() : provider.getFilterChain(graph, timeline.getPrimaryPartition(), (Lookup)lkp);
        this.setName(NbBundle.getMessage(EditorTopComponent.class, (String)"CTL_EditorTopComponent"));
        this.setToolTipText(NbBundle.getMessage(EditorTopComponent.class, (String)"HINT_EditorTopComponent"));
        this.initComponents();
        ToolbarPool.getDefault().setPreferredIconSize(16);
        FixedToolbar toolBar = new FixedToolbar();
        this.toolbar = toolBar;
        Border b = (Border)UIManager.get("Nb.Editor.Toolbar.border");
        toolBar.setBorder(b);
        JPanel container = new JPanel();
        this.add(container, "North");
        this.toolbarContainer = container;
        container.setLayout(new BorderLayout());
        container.add("North", (Component)((Object)toolBar));
        this.timeline = timeline;
        this.rangeSliderModel = new DiagramViewModel(timeline, (FilterSequence<FilterChain>)filterChain, LayoutSettings.getBean());
        timeline.whenStable().execute(() -> this.rangeSliderModel.selectGraph(graph));
        this.rangeSliderArea = new SliderPanel(timeline.getPrimaryType(), timeline);
        JScrollPane pane = new JScrollPane(this.rangeSliderArea, 21, 30);
        pane.setLayout(new SliderPanel.Layout(timeline));
        container.add("Center", pane);
        this.scene = new TCScene(this.rangeSliderModel, this);
        this.graphContent = new InstanceContent();
        lkp.accessSetLookups(new Lookup[]{this.scene.getLookup(), new AbstractLookup((AbstractLookup.Content)this.graphContent), cl});
        this.associateLookup((Lookup)lkp);
        ArrayList<InputGraphProvider> list = new ArrayList<InputGraphProvider>();
        list.add(this.newGraphProvider());
        this.graphContent.set(list, null);
        content.add((Object)timeline);
        content.add((Object)this.exportCookie);
        content.add((Object)this.rangeSliderModel);
        content.add((Object)this.selectionsBridge);
        content.add((Object)this.scene);
        content.add(filterChain);
        this.graphContent.add((Object)graph);
        this.rangeSliderModel.setLookup(this.getLookup());
        this.rangeSliderModel.getDiagramChangedEvent().addListener(this.diagramChangedListener);
        this.satelliteComponent = this.scene.createSatelliteView();
        RangeSliderModel primaryModel = timeline.getPrimaryRange();
        this.timelineColorizer = new Colorizer(timeline.getPrimaryPartition(), primaryModel);
        this.rangeSliderModel.addPropertyChangeListener("selectedNodes", WeakListeners.propertyChange((PropertyChangeListener)this.colorizerNodesUpdater, (String)"selectedNodes", (Object)this.rangeSliderModel));
        this.centerPanel = new JPanel();
        this.add(this.centerPanel, "Center");
        this.cardLayout = new CardLayout();
        this.centerPanel.setLayout(this.cardLayout);
        this.centerPanel.add(SCENE_STRING, this.scene.getComponent());
        this.centerPanel.setBackground(Color.WHITE);
        this.satelliteComponent.setSize(200, 200);
        this.centerPanel.add(SATELLITE_STRING, this.satelliteComponent);
        ActionMap am = this.getActionMap();
        for (Action a : Utilities.actionsForPath((String)TOOLBAR_ACTIONS)) {
            Component item;
            if (a == null) {
                toolBar.addSeparator();
                continue;
            }
            if (a instanceof ContextAwareAction) {
                if ((a = ((ContextAwareAction)a).createContextAwareInstance(this.getLookup())) instanceof PropertyChangeListener) {
                    ((PropertyChangeListener)((Object)a)).propertyChange(new PropertyChangeEvent(a, "SwingSelectedKey", null, Boolean.TRUE));
                }
                a.isEnabled();
            }
            if ((item = a instanceof Presenter.Toolbar ? toolBar.add(((Presenter.Toolbar)a).getToolbarPresenter()) : toolBar.add(a)) instanceof AbstractButton) {
                AbstractButton button = item;
                this.processButton(button);
            }
            String n = (String)a.getValue("Name");
            String desc = (String)a.getValue("ShortDescription");
            if (desc == null || desc.equals(n)) continue;
            am.put(n, a);
        }
        toolBar.add(Box.createHorizontalGlue());
        Action action = (Action)Utilities.actionsForPath((String)"QuickSearchShadow").get(0);
        this.quicksearch = ((Presenter.Toolbar)action).getToolbarPresenter();
        try {
            this.quicksearch = (Component)this.quicksearch.getClass().getConstructor(KeyStroke.class).newInstance(new Object[]{null});
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException a) {
            // empty catch block
        }
        Dimension preferredSize = this.quicksearch.getPreferredSize();
        preferredSize = new Dimension((int)preferredSize.getWidth() * 2, (int)preferredSize.getHeight());
        this.quicksearch.setMinimumSize(preferredSize);
        this.quicksearch.setPreferredSize(preferredSize);
        toolBar.add(this.quicksearch);
        this.scene.getComponent().addHierarchyBoundsListener(new HierarchyBoundsListener(){

            @Override
            public void ancestorMoved(HierarchyEvent e) {
            }

            @Override
            public void ancestorResized(HierarchyEvent e) {
                if (!EditorTopComponent.this.notFirstTime && EditorTopComponent.this.scene.getComponent().getBounds().width > 0) {
                    EditorTopComponent.this.notFirstTime = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            EditorTopComponent.this.scene.initialize();
                        }
                    });
                }
            }
        });
        if (graph.getGroup().getGraphsCount() == 1) {
            this.rangeSliderArea.setVisible(false);
        }
        this.titleUpdater = new TitleUpdater(this.rangeSliderModel, this);
        this.titleUpdater.start();
        GraphDocument doc = graph.getGroup().getOwner();
        if (doc != null) {
            this.wDcl = (DataCollectionListener)WeakListeners.create(DataCollectionListener.class, (EventListener)this.dcl, (Object)doc);
            doc.addDataCollectionListener(this.wDcl);
        } else {
            this.wDcl = null;
        }
        this.dt = ExternalDropTarget.createDropTarget((JComponent)((Object)this));
        this.setDropTarget(this.dt);
        this.dt.setActive(true);
        this.scene.getPriorActions().addAction((WidgetAction)new WidgetAction.Adapter(){

            public WidgetAction.State dragOver(Widget widget, final WidgetAction.WidgetDropTargetDragEvent wdtde) {
                EditorTopComponent.this.getDropTarget().dragOver(new DropTargetDragEvent(wdtde.getDropTargetContext(), wdtde.getPoint(), wdtde.getDropAction(), wdtde.getSourceActions()){

                    @Override
                    public void rejectDrag() {
                        wdtde.rejectDrag();
                    }

                    @Override
                    public void acceptDrag(int dragOperation) {
                        wdtde.acceptDrag(dragOperation);
                    }
                });
                return WidgetAction.State.CONSUMED;
            }

            public WidgetAction.State drop(Widget widget, final WidgetAction.WidgetDropTargetDropEvent wdtde) {
                EditorTopComponent.this.getDropTarget().drop(new DropTargetDropEvent(wdtde.getDropTargetContext(), wdtde.getPoint(), wdtde.getDropAction(), wdtde.getSourceActions()){

                    @Override
                    public void dropComplete(boolean success) {
                    }

                    @Override
                    public void rejectDrop() {
                        wdtde.rejectDrop();
                    }

                    @Override
                    public void acceptDrop(int dropAction) {
                        wdtde.acceptDrop(dropAction);
                    }
                });
                return WidgetAction.State.CONSUMED;
            }
        });
    }

    public boolean isSatelliteShown() {
        return this.satelliteComponent.isVisible();
    }

    public void showSatellite() {
        this.cardLayout.show(this.centerPanel, SATELLITE_STRING);
        this.satelliteComponent.requestFocus();
        this.firePropertyChange(PROP_SATELLITE_SHOWN, false, true);
    }

    public void showScene() {
        this.cardLayout.show(this.centerPanel, SCENE_STRING);
        this.scene.getComponent().requestFocus();
        this.firePropertyChange(PROP_SATELLITE_SHOWN, true, false);
    }

    public void zoomOut() {
        this.scene.zoomOut();
    }

    public void zoomIn() {
        this.scene.zoomIn();
    }

    public void zoomTo(float factor) {
        this.scene.zoomTo(factor);
    }

    public void showPrevDiagram() {
        int fp = this.getModel().getDiagramPeers().getFirstPosition();
        int sp = this.getModel().getDiagramPeers().getSecondPosition();
        if (fp != 0) {
            this.getModel().getDiagramPeers().setPositions(--fp, --sp);
        }
    }

    public DiagramViewModel getModel() {
        return this.rangeSliderModel;
    }

    public FilterSequence getFilterChain() {
        return this.getModel().getFilterChain();
    }

    public static EditorTopComponent getActive() {
        DiagramViewer v = ((DiagramViewerLocator)Lookup.getDefault().lookup(DiagramViewerLocator.class)).getActiveViewer();
        TopComponent tc = (TopComponent)v.getLookup().lookup(TopComponent.class);
        return tc instanceof EditorTopComponent ? (EditorTopComponent)tc : null;
    }

    private void initComponents() {
        this.jCheckBox1 = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox1, (String)"jCheckBox1");
        this.jCheckBox1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setLayout(new BorderLayout());
    }

    public int getPersistenceType() {
        return 2;
    }

    public void componentClosed() {
        this.rangeSliderModel.close();
        this.remove(this.toolbarContainer);
        this.toolbar.remove(this.quicksearch);
        GraphDocument d = this.getModel().getContainer().getContentOwner().getOwner();
        if (d != null && this.wDcl != null) {
            d.removeDataCollectionListener(this.wDcl);
        }
        super.componentClosed();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private InputGraphProvider newGraphProvider() {
        this.graphProvider = new EditorInputGraphProvider(this);
        return this.graphProvider;
    }

    public void setSelection(Properties.PropertyMatcher matcher) {
        this.getModel().withDiagramToView(d -> {
            Properties.PropertySelector selector = new Properties.PropertySelector(d.getFigures());
            List list = selector.selectMultiple(matcher);
            this.setSelectedFigures(list);
        });
    }

    public DiagramViewer getViewer() {
        return this.scene;
    }

    public void setSelectedFigures(List<Figure> list) {
        this.scene.centerFigures(list);
        this.scene.setSelection(list);
    }

    public void setSelectedNodes(Collection<InputNode> nodes) {
        this.getModel().withDiagramToView(d -> this.setSelectedFigures(new ArrayList<Figure>(this.scene.figuresForNodes(nodes))));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void extract() {
        this.getModel().showOnlyNodes(this.getModel().getSelectedNodes());
    }

    public void hideNodes() {
        Collection<InputNode> selectedNodes = this.getModel().getSelectedNodes();
        HashSet<Integer> nodes = new HashSet<Integer>(this.getModel().getHiddenNodes());
        nodes.addAll(selectedNodes.stream().map(InputNode::getId).collect(Collectors.toList()));
        this.getModel().showNot(nodes);
    }

    public void expandPredecessors() {
        Collection<Figure> oldSelection = this.getModel().getSelectedFigures();
        HashSet<Figure> figures = new HashSet<Figure>();
        for (Figure f : this.getDiagram().getFigures()) {
            boolean ok = false;
            if (oldSelection.contains(f)) {
                ok = true;
            } else {
                for (Figure pred : f.getSuccessors()) {
                    if (!oldSelection.contains(pred)) continue;
                    ok = true;
                    break;
                }
            }
            if (!ok) continue;
            figures.add(f);
        }
        this.getModel().showAll(figures);
    }

    public void expandSuccessors() {
        Collection<Figure> oldSelection = this.getModel().getSelectedFigures();
        HashSet<Figure> figures = new HashSet<Figure>();
        for (Figure f : this.getDiagram().getFigures()) {
            boolean ok = false;
            if (oldSelection.contains(f)) {
                ok = true;
            } else {
                for (Figure succ : f.getPredecessors()) {
                    if (!oldSelection.contains(succ)) continue;
                    ok = true;
                    break;
                }
            }
            if (!ok) continue;
            figures.add(f);
        }
        this.getModel().showAll(figures);
    }

    public void showAll() {
        this.getModel().showNot(Collections.emptySet());
    }

    private Diagram getDiagram() {
        return this.getModel().getDiagramToView();
    }

    protected void componentHidden() {
        super.componentHidden();
        this.scene.componentHidden();
    }

    protected void componentShowing() {
        super.componentShowing();
        this.scene.componentShowing();
    }

    public void requestActive() {
        super.requestActive();
        this.scene.getComponent().requestFocus();
    }

    public UndoRedo getUndoRedo() {
        return this.scene.getUndoRedo();
    }

    protected Object writeReplace() throws ObjectStreamException {
        throw new NotSerializableException();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source != null && source instanceof LayoutSettings.LayoutSettingBean) {
            this.scene.relayout((LayoutSettings.LayoutSettingBean)source);
        }
    }

    public Executor whenReady() {
        return this.scene::executeWithDiagramShown;
    }

    private static class PL
    extends ProxyLookup {
        private PL() {
        }

        public void accessSetLookups(Lookup[] lookups) {
            super.setLookups(lookups);
        }
    }

    static class FixedToolbar
    extends Toolbar
    implements PopupMenuListener {
        private JPopupMenu popup;

        FixedToolbar() {
            try {
                Field f = ToolbarWithOverflow.class.getDeclaredField("popup");
                f.setAccessible(true);
                JPopupMenu popupMenu = (JPopupMenu)f.get(this);
                if (popupMenu != null) {
                    popupMenu.addPopupMenuListener(this);
                }
                this.popup = popupMenu;
            }
            catch (ReflectiveOperationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public Dimension getMinimumSize() {
            Dimension d = super.getMinimumSize();
            d.width = 60;
            return d;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.popup.setInvoker((Component)((Object)this));
            Window win = SwingUtilities.windowForComponent((Component)((Object)this));
            if (win instanceof JWindow && win.getType() == Window.Type.POPUP) {
                win.setFocusableWindowState(true);
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    static class TCScene
    extends DiagramScene {
        public TCScene(DiagramViewModel model, TopComponent tc) {
            super(model, tc);
        }

        @Override
        public JPopupMenu createPopupMenu() {
            String p = this.getSelectedObjects().isEmpty() ? EditorTopComponent.CONTEXT_ACTIONS : EditorTopComponent.SELECTION_ACTIONS;
            List al = Utilities.actionsForPath((String)p);
            Action[] aa = al.toArray(new Action[al.size()]);
            return Utilities.actionsToPopup((Action[])aa, (Lookup)this.getLookup());
        }
    }

    static class TitleUpdater
    implements ChangedListener<Properties.MutableOwner<?>>,
    PropertyChangeListener {
        private final TimelineModel viewModel;
        private final DiagramViewModel diagramModel;
        private final EditorTopComponent target;
        private final ChangedListener<GraphDocument> docL = e -> this.refresh();

        public TitleUpdater(DiagramViewModel diagramModel, EditorTopComponent target) {
            this.diagramModel = diagramModel;
            this.viewModel = diagramModel.getTimeline();
            this.target = target;
        }

        public void start() {
            for (Group g = this.viewModel.getPrimaryPartition().getContentOwner(); g != null; g = g.getParent()) {
                if (!(g instanceof Properties.MutableOwner)) continue;
                ListenerSupport.addWeakListener((ChangedListener)this, (ChangedEvent)((Properties.MutableOwner)g).getPropertyChangedEvent());
            }
            this.diagramModel.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.diagramModel));
            SwingUtilities.invokeLater(this::updateDisplayName);
        }

        private void refresh() {
            SwingUtilities.invokeLater(this::updateDisplayName);
        }

        public void changed(Properties.MutableOwner<?> source) {
            this.refresh();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("selectedGraph".equals(evt.getPropertyName())) {
                this.refresh();
            }
        }

        private String getUserLabel(Properties.Entity e) {
            return e.getProperties().getString("igv.userLabel", null);
        }

        private String findContainerTitle() {
            FileObject fo;
            Group g;
            InputGraph ig = this.diagramModel.getGraphToView();
            String l = this.getUserLabel((Properties.Entity)ig);
            if (l != null) {
                return l;
            }
            for (g = this.viewModel.getPrimaryPartition().getContentOwner(); g != null; g = g.getParent()) {
                if (!(g instanceof Properties.Entity) || (l = this.getUserLabel((Properties.Entity)g)) == null) continue;
                return l;
            }
            g = this.viewModel.getPrimaryPartition().getContentOwner();
            if (g == null || g.getOwner() == null) {
                return null;
            }
            GraphDocument gdoc = g.getOwner();
            l = this.getUserLabel((Properties.Entity)gdoc);
            if (l != null) {
                return l;
            }
            String docName = gdoc.getName();
            if (docName.startsWith("HotSpotCompilation") || docName.startsWith("TruffleHotSpotCompilation")) {
                int bracket = docName.indexOf("[");
                int dash = docName.indexOf(45);
                if (bracket > 0) {
                    if (dash > 0) {
                        return docName.substring(dash + 1, bracket);
                    }
                    return docName.substring(0, bracket);
                }
            }
            if (gdoc instanceof Lookup.Provider && (fo = (FileObject)((Lookup.Provider)gdoc).getLookup().lookup(FileObject.class)) != null) {
                return fo.getName();
            }
            return null;
        }

        private void updateDisplayName() {
            String suffix = this.findContainerTitle();
            Diagram d = this.diagramModel.getDiagramToView();
            String n = d.getName();
            String g = d.getGraph().getGroup().getName();
            if (suffix != null) {
                n = Bundle.FMT_DiagramNameSuffix(n, suffix);
                g = Bundle.FMT_GroupNameSuffix(n, suffix);
            }
            this.target.setDisplayName(n);
            this.target.setToolTipText(g);
        }
    }
}

