/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.graalvm.visualizer.view.DiagramScene;
import org.graalvm.visualizer.view.SceneViewport;
import org.netbeans.api.visual.widget.Scene;
import org.openide.util.RequestProcessor;

public final class ExtendedSatelliteComponent
extends JComponent
implements MouseListener,
MouseMotionListener,
Scene.SceneListener,
ComponentListener {
    private static final Logger LOG = Logger.getLogger(ExtendedSatelliteComponent.class.getName());
    private static final RequestProcessor DELAY_RP = new RequestProcessor(ExtendedSatelliteComponent.class);
    private final DiagramScene scene;
    private final SVImpl sceneViewportImpl = new SVImpl();
    private Image image;
    private int imageWidth;
    private int imageHeight;
    private double scale;
    private boolean viewUpdated;
    private Dimension sceneSize;
    private RequestProcessor.Task pendingUpdate;

    public ExtendedSatelliteComponent(DiagramScene scene) {
        this.scene = scene;
        this.setDoubleBuffered(true);
        this.setPreferredSize(new Dimension(128, 128));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        scene.getScrollPane().getViewport().addChangeListener(e -> this.sceneViewportChanged());
        scene.getModel().getChangedEvent().addListener(e -> SwingUtilities.invokeLater(this::update));
        this.sceneSize = scene.getSceneSize();
    }

    private void sceneViewportChanged() {
        Dimension newSize = this.scene.getSceneSize();
        if (newSize.equals(this.sceneSize)) {
            return;
        }
        LOG.log(Level.FINE, "Scene size changed to {0}, invalidating", this.sceneSize);
        this.sceneSize = newSize;
        this.invalidateImage();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.verifyImageScale();
    }

    private void invalidateImage() {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.viewUpdated) {
            this.image = null;
            return;
        }
        this.image = null;
        this.imageWidth = -1;
        this.imageHeight = -1;
        this.viewUpdated = false;
        this.sceneViewportImpl.fireChange();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.scene.addSceneListener(this);
        JComponent viewComponent = this.scene.getView();
        if (viewComponent == null) {
            viewComponent = this.scene.createView();
        }
        viewComponent.addComponentListener(this);
        this.registerIfVisible();
    }

    @Override
    public void setVisible(boolean aFlag) {
        boolean oFlag = this.isVisible();
        super.setVisible(aFlag);
        if (this.getParent() == null || oFlag == aFlag) {
            return;
        }
        this.registerIfVisible();
        if (aFlag) {
            this.repaint();
        }
    }

    private void registerIfVisible() {
        if (this.isVisible()) {
            LOG.log(Level.FINE, "Satellite view visible, computed bounds: {0}, current number of objects: {1}", new Object[]{this.getSceneRectangle(), this.scene.getObjects().size()});
            this.scene.addSceneViewport(this.sceneViewportImpl);
        } else {
            this.scene.removeSceneViewport(this.sceneViewportImpl);
            LOG.log(Level.FINE, "Satellite view hidden");
        }
    }

    @Override
    public void removeNotify() {
        this.scene.getView().removeComponentListener(this);
        this.scene.removeSceneListener(this);
        this.registerIfVisible();
        super.removeNotify();
    }

    void finalUpdate() {
        this.update0(true);
    }

    void update() {
        this.update0(false);
    }

    void update0(boolean finalUpdate) {
        this.image = null;
        this.verifyImageScale();
        this.viewUpdated |= finalUpdate;
        if (this.isVisible()) {
            this.repaint();
            this.revalidate();
            this.validate();
        }
    }

    private Rectangle getSceneRectangle() {
        if (this.viewUpdated) {
            return this.scene.getSceneViewportSize();
        }
        this.verifyImageScale();
        Dimension size = this.getSize();
        int vw = (int)((double)size.width / this.scale);
        int vh = (int)((double)size.height / this.scale);
        return new Rectangle(0, 0, vh, vw);
    }

    private boolean verifyImageScale() {
        return this.verifyImageScale(true);
    }

    private boolean verifyImageScale(boolean invalidate) {
        boolean inv;
        if (!this.isDisplayable() || !this.isVisible()) {
            return false;
        }
        Dimension sSize = this.scene.getSceneSize();
        Dimension size = this.getSize();
        double sx = sSize.width > 0 ? Math.min((double)size.width / (double)sSize.width, 1.0) : 1.0;
        double sy = sSize.width > 0 ? Math.min((double)size.height / (double)sSize.height, 1.0) : 1.0;
        this.scale = Math.min(sx, sy);
        int vw = (int)(this.scale * (double)sSize.width);
        int vh = (int)(this.scale * (double)sSize.height);
        if (vw <= 0 || vh <= 0) {
            return false;
        }
        boolean bl = inv = this.imageWidth != vw || this.imageHeight != vh;
        if (this.image == null || inv) {
            if (inv && invalidate) {
                this.invalidateImage();
            }
            this.imageWidth = vw;
            this.imageHeight = vh;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        Rectangle viewRectangle;
        Graphics2D gr = (Graphics2D)g;
        super.paint(g);
        if (!this.isVisible()) {
            return;
        }
        if (this.verifyImageScale(false)) {
            LOG.log(Level.FINER, "Satellite view: paint, scene object count: {0}, dim = {1} x {2}", new Object[]{this.scene.getObjects().size(), this.imageWidth, this.imageHeight});
            this.image = this.createImage(this.imageWidth, this.imageHeight);
            Graphics2D ig = (Graphics2D)this.image.getGraphics();
            ig.scale(this.scale, this.scale);
            double oldFactor = this.scene.getZoomFactor();
            try {
                this.scene.setZoomFactor(this.scale);
                this.scene.paintOnViewport(this.sceneViewportImpl, ig);
            }
            finally {
                this.scene.setZoomFactor(oldFactor);
            }
        }
        if (this.image == null) {
            return;
        }
        Dimension size = this.getSize();
        int vx = (size.width - this.imageWidth) / 2;
        int vy = (size.height - this.imageHeight) / 2;
        gr.drawImage(this.image, vx, vy, this);
        JComponent component = this.scene.getView();
        double zoomFactor = this.scene.getZoomFactor();
        Rectangle rectangle = viewRectangle = component != null ? component.getVisibleRect() : null;
        if (viewRectangle != null) {
            Rectangle window = new Rectangle((int)((double)viewRectangle.x * this.scale / zoomFactor), (int)((double)viewRectangle.y * this.scale / zoomFactor), (int)((double)viewRectangle.width * this.scale / zoomFactor), (int)((double)viewRectangle.height * this.scale / zoomFactor));
            window.translate(vx, vy);
            gr.setColor(new Color(200, 200, 200, 128));
            gr.fill(window);
            gr.setColor(Color.BLACK);
            gr.drawRect(window.x, window.y, window.width - 1, window.height - 1);
        }
        gr.setColor(Color.BLACK);
        gr.drawRect(vx, vy, this.imageWidth, this.imageHeight);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.moveVisibleRect(e.getPoint());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.moveVisibleRect(e.getPoint());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.moveVisibleRect(e.getPoint());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private void moveVisibleRect(Point center) {
        JComponent component = this.scene.getView();
        if (component == null) {
            return;
        }
        double zoomFactor = this.scene.getZoomFactor();
        Dimension size = this.getSize();
        this.verifyImageScale();
        int vx = (size.width - this.imageWidth) / 2;
        int vy = (size.height - this.imageHeight) / 2;
        int cx = (int)((double)(center.x - vx) / this.scale * zoomFactor);
        int cy = (int)((double)(center.y - vy) / this.scale * zoomFactor);
        Rectangle visibleRect = component.getVisibleRect();
        visibleRect.x = cx - visibleRect.width / 2;
        visibleRect.y = cy - visibleRect.height / 2;
        component.scrollRectToVisible(visibleRect);
        this.repaint();
    }

    public void sceneRepaint() {
    }

    public void sceneValidating() {
    }

    public void sceneValidated() {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.repaint();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    class SVImpl
    implements SceneViewport,
    Runnable {
        private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();

        SVImpl() {
        }

        @Override
        public Rectangle getSceneViewRect() {
            assert (SwingUtilities.isEventDispatchThread());
            return ExtendedSatelliteComponent.this.getSceneRectangle();
        }

        @Override
        public synchronized void addChangeListener(ChangeListener l) {
            this.listeners.add(l);
        }

        @Override
        public synchronized void removeChangeListener(ChangeListener l) {
            this.listeners.remove(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireChange() {
            ChangeListener[] ll;
            SVImpl sVImpl = this;
            synchronized (sVImpl) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                ll = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            ChangeEvent chg = new ChangeEvent(ExtendedSatelliteComponent.this);
            for (ChangeListener l : ll) {
                l.stateChanged(chg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sceneContentsUpdated(boolean finished, Rectangle validRectangle) {
            if (ExtendedSatelliteComponent.this.viewUpdated && ExtendedSatelliteComponent.this.image != null) {
                LOG.log(Level.FINE, "Scene update ignored, view image is ready");
                return;
            }
            ExtendedSatelliteComponent extendedSatelliteComponent = ExtendedSatelliteComponent.this;
            synchronized (extendedSatelliteComponent) {
                if (finished && ExtendedSatelliteComponent.this.pendingUpdate != null) {
                    LOG.log(Level.FINE, "Final update, trying to cancel scheduled partial one");
                    ExtendedSatelliteComponent.this.pendingUpdate.cancel();
                    ExtendedSatelliteComponent.this.pendingUpdate = null;
                }
                if (!ExtendedSatelliteComponent.this.isVisible()) {
                    return;
                }
                if (finished) {
                    SwingUtilities.invokeLater(ExtendedSatelliteComponent.this::finalUpdate);
                } else if (ExtendedSatelliteComponent.this.pendingUpdate == null) {
                    ExtendedSatelliteComponent.this.pendingUpdate = DELAY_RP.post((Runnable)this, 500);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SVImpl sVImpl = this;
            synchronized (sVImpl) {
                ExtendedSatelliteComponent.this.pendingUpdate = null;
            }
            LOG.log(Level.FINE, "Satellite: perform repaint");
            SwingUtilities.invokeLater(ExtendedSatelliteComponent.this::update);
        }

        @Override
        public Rectangle getViewportRect() {
            return ExtendedSatelliteComponent.this.getBounds();
        }
    }
}

