/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view.impl;

import java.beans.PropertyChangeEvent;
import java.lang.ref.WeakReference;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.view.DiagramViewModel;
import org.graalvm.visualizer.view.impl.DiagramCacheBase;
import org.graalvm.visualizer.view.impl.DiagramCacheTask;
import org.openide.util.RequestProcessor;

public class DiagramCacheUpdater {
    private static final Logger LOG = Logger.getLogger(DiagramCacheUpdater.class.getName());
    private Consumer<Diagram> diagramReadyCallback;
    private final RequestProcessor processor;
    private final WeakReference<DiagramViewModel> originModel;
    private DiagramCacheBase currentCache;
    private RequestProcessor.Task scheduledTask;
    private DiagramCacheTask diagramTask;
    private volatile Phase phase = Phase.DONE;

    public DiagramCacheUpdater(DiagramViewModel model) {
        LOG.log(Level.FINE, "Created for model: {0}", model);
        this.processor = new RequestProcessor(DiagramCacheUpdater.class);
        this.originModel = new WeakReference<DiagramViewModel>(model);
        model.addPropertyChangeListener(this::modelChanged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleUpdate(DiagramCacheBase cache, Consumer<Diagram> diagramReadyCallback) {
        Phase nextPhase;
        DiagramViewModel model;
        DiagramCacheUpdater diagramCacheUpdater = this;
        synchronized (diagramCacheUpdater) {
            model = (DiagramViewModel)this.originModel.get();
            nextPhase = cache.nextPhase(model);
            if (model == null) {
                this.cancelPendingTask();
                LOG.log(Level.FINE, "Model was GCed, ending.");
                return;
            }
            if (this.phase != nextPhase && this.diagramTask != null) {
                this.cancelPendingTask();
                LOG.log(Level.WARNING, "Phase changed resheduling.");
            }
            if (this.diagramTask != null) {
                LOG.log(Level.FINE, "Diagram {0} task {1} already scheduled.", new Object[]{this.phase, this.diagramTask});
                return;
            }
            this.diagramReadyCallback = diagramReadyCallback;
        }
        this.makeUpdateTask(cache, model, nextPhase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeUpdateTask(DiagramCacheBase cache, DiagramViewModel model, Phase nextPhase) {
        DiagramCacheUpdater diagramCacheUpdater = this;
        synchronized (diagramCacheUpdater) {
            this.phase = nextPhase;
            if (this.phase != Phase.DONE) {
                this.currentCache = cache;
                this.diagramTask = DiagramCacheTask.makeTask(cache.get(), model, this, nextPhase);
                this.scheduledTask = this.processor.post((Runnable)this.diagramTask);
                LOG.log(Level.FINE, "Scheduled Diagram {0} task: {1}.", new Object[]{this.phase, this.diagramTask});
                return;
            }
            this.currentCache = null;
            this.diagramTask = null;
            this.scheduledTask = null;
        }
        this.fireDiagramDone(cache.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void afterTask(DiagramCacheTask t) {
        DiagramCacheBase newCache;
        DiagramViewModel origin;
        DiagramCacheUpdater diagramCacheUpdater = this;
        synchronized (diagramCacheUpdater) {
            LOG.log(Level.FINE, "Finished Diagram {1} task: {0}.", new Object[]{t, this.phase});
            if (this.diagramTask != t || t.cancelled()) {
                return;
            }
            origin = (DiagramViewModel)this.originModel.get();
            if (origin == null) {
                return;
            }
            newCache = this.currentCache.makeCache(origin, t.outputDiagram);
        }
        this.makeUpdateTask(newCache, origin, newCache.nextPhase(origin));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDiagramDone(Diagram diagram) {
        Consumer<Diagram> callback;
        LOG.log(Level.FINE, "Diagram is done.");
        DiagramCacheUpdater diagramCacheUpdater = this;
        synchronized (diagramCacheUpdater) {
            assert (this.diagramReadyCallback != null);
            callback = this.diagramReadyCallback;
            this.diagramReadyCallback = null;
        }
        callback.accept(diagram);
    }

    private void modelChanged(PropertyChangeEvent event) {
        Phase currentPhase = this.phase;
        switch (event.getPropertyName()) {
            case "layoutSetting": 
            case "showBlocks": {
                if (currentPhase == Phase.EXTRACT || currentPhase == Phase.LAYOUT) break;
                return;
            }
            case "selectedGraph": {
                break;
            }
            case "hiddenNodes": 
            case "showNodeHull": {
                if (currentPhase == Phase.EXTRACT) break;
                return;
            }
            case "filters": {
                if (currentPhase != Phase.BUILD) break;
                return;
            }
            default: {
                return;
            }
        }
        this.cancelPendingTask();
    }

    private synchronized void cancelPendingTask() {
        if (this.diagramTask == null && this.scheduledTask == null) {
            return;
        }
        LOG.log(Level.FINE, "Cancelling task {0}.", this.diagramTask);
        this.diagramReadyCallback = null;
        if (this.diagramTask != null) {
            this.diagramTask.cancel();
            this.diagramTask = null;
        }
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel();
            this.scheduledTask = null;
        }
    }

    public static enum Phase {
        BUILD,
        FILTER,
        LAYOUT,
        EXTRACT,
        DONE;

    }
}

