/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import org.graalvm.visualizer.filter.FilterExecution;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.view.DiagramViewModel;

public final class FilterView {
    private final DiagramViewModel model;
    private Collection<Figure> selection;
    private Collection<Figure> toExtract;
    private Diagram diagram;
    private boolean showAll;
    private boolean changed;

    FilterView(DiagramViewModel model) {
        this.model = model;
    }

    private void clear() {
        this.changed = false;
        this.selection = null;
        this.toExtract = null;
        this.showAll = false;
    }

    private Optional<Figure> find(int id) {
        if (this.diagram == null) {
            return Optional.empty();
        }
        return this.diagram.getFigure(id);
    }

    public void select(int nodeID) {
        this.find(nodeID).ifPresent(f -> this.select((Figure)f));
    }

    public void select(Collection<Figure> figures) {
        this.selection = new HashSet<Figure>(figures);
        this.changed = true;
    }

    public void select(Figure figure) {
        this.select(Collections.singletonList(figure));
    }

    public Collection<Figure> getSelected() {
        if (this.selection == null) {
            return this.model.getSelectedFigures();
        }
        return Collections.unmodifiableCollection(this.selection);
    }

    public void extract(int nodeID) {
        this.find(nodeID).ifPresent(f -> this.extract((Figure)f));
    }

    public void addExtract(int nodeID) {
        this.find(nodeID).ifPresent(f -> this.addExtract((Figure)f));
    }

    public void extract(Figure figure) {
        this.extract(Collections.singleton(figure));
    }

    private Collection<Figure> findExtractedFigures() {
        if (this.diagram == null) {
            return new HashSet<Figure>();
        }
        Collection hidden = this.model.getHiddenNodes();
        Diagram dg = this.diagram;
        Collection figures = dg.forSources(hidden, Figure.class).stream().filter(f -> f.isVisible()).collect(Collectors.toList());
        return new HashSet<Figure>(figures);
    }

    public void addExtract(Figure f) {
        if (this.toExtract == null) {
            this.toExtract = this.findExtractedFigures();
        }
        this.toExtract.add(f);
        this.changed = true;
    }

    public void extract(Collection<Figure> figures) {
        this.toExtract = new HashSet<Figure>(figures);
        this.changed = true;
    }

    private void doSelection() {
        if (this.selection == null) {
            return;
        }
        this.model.setSelectedFigures(this.selection);
    }

    private void doExtract() {
        if (this.showAll) {
            this.model.showNot(Collections.emptySet());
            return;
        }
        if (this.toExtract == null) {
            return;
        }
        HashSet nodesToExtract = new HashSet();
        for (Figure f : this.toExtract) {
            nodesToExtract.addAll(f.getSource().getSourceNodes());
        }
        this.model.showOnly(nodesToExtract.stream().map(n -> n.getId()).collect(Collectors.toSet()));
    }

    public void showAll() {
        this.showAll = true;
        this.changed = true;
    }

    void setExecution(FilterExecution exec) {
        if (this.diagram != null && this.diagram != exec.getDiagram()) {
            this.clear();
        }
        this.diagram = exec.getDiagram();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void perform() {
        FilterView filterView = this;
        synchronized (filterView) {
            if (!this.changed || this.model.getGraphToView() != this.diagram.getGraph()) {
                return;
            }
            this.doExtract();
            this.doSelection();
        }
    }
}

