/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view.impl;

import java.util.Objects;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import org.graalvm.visualizer.view.api.TimelineModel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.Mode;
import org.openide.windows.ModeSelector;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class GraphTypeModeSelector
implements ModeSelector {
    public Mode selectModeForOpen(TopComponent tc, Mode mode) {
        Object o;
        FileObject fo;
        if (tc.getLookup().lookup(InputGraph.class) == null) {
            return null;
        }
        TimelineModel mdl = (TimelineModel)tc.getLookup().lookup(TimelineModel.class);
        if (mdl == null) {
            return null;
        }
        String type = mdl.getPrimaryType();
        if (type != null && (fo = FileUtil.getConfigFile((String)("IGV/GraphTypes/" + type))) != null && (o = fo.getAttribute("defaultMode")) instanceof String) {
            Mode m = WindowManager.getDefault().findMode((String)o);
            TopComponent[] openedComps = WindowManager.getDefault().getOpenedTopComponents(m);
            if (openedComps.length > 0) {
                return m;
            }
            for (Mode existing : WindowManager.getDefault().getModes()) {
                for (TopComponent exC : openedComps = WindowManager.getDefault().getOpenedTopComponents(m)) {
                    TimelineModel time = (TimelineModel)exC.getLookup().lookup(TimelineModel.class);
                    if (time == null || !Objects.equals(time.getPrimaryType(), mdl.getPrimaryType())) continue;
                    return existing;
                }
            }
            return m;
        }
        return null;
    }
}

