/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view.widgets;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.data.services.GraphViewer;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.util.DoubleClickAction;
import org.graalvm.visualizer.util.DoubleClickHandler;
import org.graalvm.visualizer.util.PropertiesSheet;
import org.graalvm.visualizer.view.DiagramScene;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;

public final class FigureWidget
extends Widget
implements Properties.Provider,
PopupMenuProvider,
DoubleClickHandler {
    public static final boolean VERTICAL_LAYOUT = true;
    private static final double LABEL_ZOOM_FACTOR = 0.3;
    private final Figure figure;
    private final Widget middleWidget;
    private final ArrayList<LabelWidget> labelWidgets;
    private final DiagramScene diagramScene;
    private boolean boundary;
    private final Node node;

    public void setBoundary(boolean b) {
        this.boundary = b;
    }

    public Rectangle getRectangle() {
        Rectangle r = this.getBounds();
        Point p = this.getLocation();
        if (r == null || p == null) {
            return null;
        }
        return new Rectangle(p.x, p.y, r.width, r.height);
    }

    public boolean isBoundary() {
        return this.boundary;
    }

    public Node getNode() {
        return this.node;
    }

    public boolean isHitAt(Point localLocation) {
        return this.middleWidget.isHitAt(localLocation);
    }

    public FigureWidget(final Figure f, WidgetAction hoverAction, WidgetAction selectAction, DiagramScene scene, Widget parent) {
        super((Scene)scene);
        assert (this.getScene() != null);
        assert (this.getScene().getView() != null);
        this.figure = f;
        this.setCheckClipping(true);
        this.diagramScene = scene;
        this.boundary = f.isBoundary();
        parent.addChild((Widget)this);
        this.middleWidget = new Widget((Scene)scene);
        this.middleWidget.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.CENTER, (int)0));
        this.middleWidget.setBackground((Paint)f.getColor());
        this.middleWidget.setOpaque(true);
        this.middleWidget.getActions().addAction((WidgetAction)new DoubleClickAction((DoubleClickHandler)this));
        this.middleWidget.setCheckClipping(true);
        String[] strings = this.figure.getLines();
        this.labelWidgets = new ArrayList(strings.length);
        for (String displayString : strings) {
            LabelWidget lw = new LabelWidget((Scene)scene, displayString);
            this.labelWidgets.add(lw);
            this.middleWidget.addChild((Widget)lw);
            lw.setFont(Diagram.getFont());
            lw.setForeground(this.getTextColor());
            lw.setAlignment(LabelWidget.Alignment.CENTER);
            lw.setVerticalAlignment(LabelWidget.VerticalAlignment.CENTER);
            lw.setBorder(BorderFactory.createEmptyBorder());
        }
        this.middleWidget.setPreferredBounds(new Rectangle(0, 0, f.getWidth(), f.getHeight()));
        this.addChild(this.middleWidget);
        this.node = new AbstractNode(Children.LEAF){

            protected Sheet createSheet() {
                Sheet s = super.createSheet();
                PropertiesSheet.initializeSheet((Properties)f.getProperties(), (Sheet)s);
                return s;
            }
        };
        this.node.setDisplayName(this.getName());
    }

    protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
        super.notifyStateChanged(previousState, state);
        Font font = Diagram.getFont();
        if (state.isSelected()) {
            font = Diagram.getBoldFont();
        }
        Color borderColor = Color.BLACK;
        Color innerBorderColor = this.getFigure().getColor();
        Color[] ret = new Color[]{innerBorderColor};
        this.figure.getDiagram().render(() -> {
            if (state.isHighlighted()) {
                ret[0] = Color.BLUE;
            }
        });
        if (ret[0] != innerBorderColor) {
            innerBorderColor = borderColor = ret[0];
        }
        this.middleWidget.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(borderColor, 1), BorderFactory.createLineBorder(innerBorderColor, 1)));
        for (LabelWidget labelWidget : this.labelWidgets) {
            labelWidget.setFont(font);
        }
        this.repaint();
    }

    public String getName() {
        return this.getProperties().getString("name", null);
    }

    public Properties getProperties() {
        return this.figure.getProperties();
    }

    public Figure getFigure() {
        return this.figure;
    }

    private Color getTextColor() {
        Color bg = this.figure.getColor();
        double brightness = (double)bg.getRed() * 0.21 + (double)bg.getGreen() * 0.72 + (double)bg.getBlue() * 0.07;
        if (brightness < 150.0) {
            return Color.WHITE;
        }
        return Color.BLACK;
    }

    protected void paintChildren() {
        Composite oldComposite = null;
        if (this.boundary) {
            oldComposite = this.getScene().getGraphics().getComposite();
            float alpha = 0.4f;
            this.getScene().getGraphics().setComposite(AlphaComposite.getInstance(3, alpha));
        }
        if (this.diagramScene.getZoomFactor() < 0.3) {
            for (LabelWidget labelWidget : this.labelWidgets) {
                labelWidget.setVisible(false);
            }
            super.paintChildren();
            for (LabelWidget labelWidget : this.labelWidgets) {
                labelWidget.setVisible(true);
            }
        } else {
            Color oldColor = null;
            if (this.boundary) {
                for (LabelWidget labelWidget : this.labelWidgets) {
                    oldColor = labelWidget.getForeground();
                    labelWidget.setForeground(Color.BLACK);
                }
            }
            super.paintChildren();
            if (this.boundary) {
                for (LabelWidget labelWidget : this.labelWidgets) {
                    labelWidget.setForeground(oldColor);
                }
            }
        }
        if (this.boundary) {
            this.getScene().getGraphics().setComposite(oldComposite);
        }
    }

    public JPopupMenu getPopupMenu(Widget widget, Point point) {
        JPopupMenu menu = this.diagramScene.createPopupMenu();
        menu.addSeparator();
        FigureWidget.build(menu, this.getFigure(), this, false, this.diagramScene);
        menu.addSeparator();
        FigureWidget.build(menu, this.getFigure(), this, true, this.diagramScene);
        if (this.getFigure().getSubgraphs() != null) {
            menu.addSeparator();
            JMenu subgraphs = new JMenu("Subgraphs");
            menu.add(subgraphs);
            final GraphViewer viewer = (GraphViewer)Lookup.getDefault().lookup(GraphViewer.class);
            for (final InputGraph subgraph : this.getFigure().getSubgraphs()) {
                AbstractAction a = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        viewer.view(subgraph, true, new Object[0]);
                    }
                };
                a.setEnabled(true);
                a.putValue("Name", subgraph.getName());
                subgraphs.add(a);
            }
        }
        return menu;
    }

    public static void build(JPopupMenu menu, Figure figure, FigureWidget figureWidget, boolean successors, DiagramScene diagramScene) {
        Set set = figure.getPredecessorSet();
        if (successors) {
            set = figure.getSuccessorSet();
        }
        boolean first = true;
        for (Figure f : set) {
            if (f == figure) continue;
            if (first) {
                first = false;
            } else {
                menu.addSeparator();
            }
            Action go = diagramScene.createGotoAction(f);
            menu.add(go);
            JMenu preds = new JMenu("Nodes Above");
            FigureWidget figureWidget2 = figureWidget;
            Objects.requireNonNull(figureWidget2);
            preds.addMenuListener(figureWidget2.new NeighborMenuListener(preds, f, false));
            menu.add(preds);
            JMenu succs = new JMenu("Nodes Below");
            FigureWidget figureWidget3 = figureWidget;
            Objects.requireNonNull(figureWidget3);
            succs.addMenuListener(figureWidget3.new NeighborMenuListener(succs, f, true));
            menu.add(succs);
        }
        if (figure.getPredecessorSet().isEmpty() && figure.getSuccessorSet().isEmpty()) {
            menu.add("(none)");
        }
    }

    public void handleDoubleClick(Widget w, WidgetAction.WidgetMouseEvent e) {
        HashSet<Integer> hiddenIds;
        Set selectedIds = this.getFigure().getSource().getSourceNodeIds();
        if (this.diagramScene.isAllVisible()) {
            hiddenIds = new HashSet<Integer>(this.diagramScene.getModel().getContainer().getChildNodeIds());
            hiddenIds.removeAll(selectedIds);
        } else if (this.isBoundary()) {
            hiddenIds = new HashSet(this.diagramScene.getModel().getHiddenNodes());
            hiddenIds.removeAll(selectedIds);
        } else {
            hiddenIds = new HashSet(this.diagramScene.getModel().getHiddenNodes());
            hiddenIds.addAll(selectedIds);
            HashSet<Integer> ids = new HashSet<Integer>(this.diagramScene.getModel().getGraphToView().getNodeIds());
            ids.removeAll(hiddenIds);
            if (ids.isEmpty()) {
                this.diagramScene.getModel().showNot(ids);
                return;
            }
        }
        this.diagramScene.getModel().showNot(hiddenIds);
    }

    public class NeighborMenuListener
    implements MenuListener {
        private final JMenu menu;
        private final Figure figure;
        private final boolean successors;

        public NeighborMenuListener(JMenu menu, Figure figure, boolean successors) {
            this.menu = menu;
            this.figure = figure;
            this.successors = successors;
        }

        @Override
        public void menuSelected(MenuEvent e) {
            if (this.menu.getItemCount() > 0) {
                return;
            }
            FigureWidget.build(this.menu.getPopupMenu(), this.figure, FigureWidget.this, this.successors, FigureWidget.this.diagramScene);
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    }
}

