/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view.widgets;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.graalvm.visualizer.graph.OutputSlot;
import org.graalvm.visualizer.graph.Slot;
import org.graalvm.visualizer.view.DiagramScene;
import org.graalvm.visualizer.view.widgets.FigureWidget;
import org.graalvm.visualizer.view.widgets.SlotWidget;
import org.netbeans.api.visual.widget.Widget;

public final class OutputSlotWidget
extends SlotWidget {
    private final OutputSlot outputSlot;

    public OutputSlotWidget(OutputSlot slot, DiagramScene scene, Widget parent, FigureWidget fw) {
        super((Slot)slot, scene, parent, fw);
        this.outputSlot = slot;
        Point p = this.outputSlot.getRelativePosition();
        Rectangle r = this.calculateClientArea();
        p.x -= r.width / 2;
        p.y += fw.getFigure().getHeight() - r.height;
        this.setPreferredLocation(p);
    }

    public OutputSlot getOutputSlot() {
        return this.outputSlot;
    }

    @Override
    protected int calculateSlotWidth() {
        List slots = this.getSlot().getFigure().getOutputSlots();
        assert (slots.contains(this.getSlot()));
        return this.calculateWidth(slots.size());
    }
}

