/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view.widgets;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.graph.OutputSlot;
import org.graalvm.visualizer.graph.Slot;
import org.graalvm.visualizer.util.DoubleClickHandler;
import org.graalvm.visualizer.view.DiagramScene;
import org.graalvm.visualizer.view.DiagramViewModel;
import org.graalvm.visualizer.view.widgets.FigureWidget;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public abstract class SlotWidget
extends Widget
implements DoubleClickHandler {
    private static final double TEXT_ZOOM_FACTOR = 0.9;
    private static final double ZOOM_FACTOR = 0.6;
    private final Slot slot;
    private final FigureWidget figureWidget;
    private final DiagramViewModel model;

    public SlotWidget(Slot slot, DiagramScene scene, Widget parent, FigureWidget fw) {
        super((Scene)scene);
        this.model = scene.getModel();
        this.slot = slot;
        this.figureWidget = fw;
        this.setToolTipText("<HTML>" + slot.getToolTipText() + "</HTML>");
        this.setCheckClipping(true);
        parent.addChild((Widget)this);
    }

    protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
        super.notifyStateChanged(previousState, state);
        this.repaint();
    }

    public Slot getSlot() {
        return this.slot;
    }

    public FigureWidget getFigureWidget() {
        return this.figureWidget;
    }

    protected void paintWidget() {
        if (this.getScene().getZoomFactor() < 0.6) {
            return;
        }
        Rectangle b = this.getBounds();
        if (b == null) {
            return;
        }
        Graphics2D g = this.getGraphics();
        int w = b.width;
        int h = b.height;
        if (this.getSlot().getSource().getSourceNodes().size() > 0) {
            Rectangle2D r1;
            String shortName;
            g.setColor(this.getSlot().getColor());
            int FONT_OFFSET = 2;
            int rectW = h;
            Font font = Diagram.getSlotFont();
            if (this.getState().isSelected()) {
                font = font.deriveFont(1);
            }
            if ((shortName = this.getSlot().getShortName()) != null && shortName.length() > 0) {
                g.setFont(font);
                r1 = g.getFontMetrics().getStringBounds(shortName, g);
                rectW = (int)r1.getWidth() + FONT_OFFSET * 2;
            }
            g.fillRect(w / 2 - rectW / 2, 0, rectW - 1, h - 1);
            if (this.getState().isHighlighted()) {
                g.setColor(Color.BLUE);
            } else {
                g.setColor(Color.BLACK);
            }
            g.drawRect(w / 2 - rectW / 2, 0, rectW - 1, h - 1);
            if (shortName != null && shortName.length() > 0 && this.getScene().getZoomFactor() >= 0.9) {
                r1 = g.getFontMetrics().getStringBounds(shortName, g);
                g.drawString(shortName, (int)((double)w - r1.getWidth()) / 2, g.getFontMetrics().getAscent() - 1);
            }
        } else if (this.getSlot().getConnections().isEmpty()) {
            if (this.getState().isHighlighted()) {
                g.setColor(Color.BLUE);
            } else {
                g.setColor(Color.BLACK);
            }
            int r = 2;
            if (this.slot instanceof OutputSlot) {
                g.fillOval(w / 2 - r, Figure.SLOT_WIDTH - 4 - r, 2 * r, 2 * r);
            } else {
                g.fillOval(w / 2 - r, 4 - r, 2 * r, 2 * r);
            }
        }
    }

    protected Rectangle calculateClientArea() {
        return new Rectangle(0, 0, this.slot.getWidth(), Figure.SLOT_WIDTH);
    }

    protected abstract int calculateSlotWidth();

    protected int calculateWidth(int count) {
        return this.getFigureWidget().getFigure().getWidth() / count;
    }

    public void handleDoubleClick(Widget w, WidgetAction.WidgetMouseEvent e) {
        HashSet<Integer> hiddenNodes = this.model.getHiddenNodes().isEmpty() ? new HashSet(this.model.getContainer().getChildNodeIds()) : new HashSet<Integer>(this.model.getHiddenNodes());
        Set clickedIds = this.slot.getSource().getSourceNodeIds();
        Diagram d = this.slot.getFigure().getDiagram();
        Set slots = d.forSources((Collection)clickedIds, Slot.class);
        if (!slots.isEmpty()) {
            hiddenNodes.removeAll(slots.stream().map(s -> s.getFigure().getId()).collect(Collectors.toList()));
            this.model.showNot(hiddenNodes);
        }
    }
}

