/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view.widgets.actions;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.animator.SceneAnimator;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class BoundedZoomAction
extends WidgetAction.Adapter {
    private double minFactor = 0.0;
    private double maxFactor = Double.MAX_VALUE;
    private double zoomMultiplier;
    private boolean useAnimator;

    public BoundedZoomAction(double zoomMultiplier, boolean useAnimator) {
        assert (zoomMultiplier > 1.0);
        this.zoomMultiplier = zoomMultiplier;
        this.useAnimator = useAnimator;
    }

    public double getMinFactor() {
        return this.minFactor;
    }

    public void setMinFactor(double d) {
        this.minFactor = d;
    }

    public double getMaxFactor() {
        return this.maxFactor;
    }

    public void setMaxFactor(double d) {
        this.maxFactor = d;
    }

    private JScrollPane findScrollPane(JComponent component) {
        while (component != null) {
            if (component instanceof JScrollPane) {
                return (JScrollPane)component;
            }
            Container parent = component.getParent();
            if (!(parent instanceof JComponent)) {
                return null;
            }
            component = (JComponent)parent;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WidgetAction.State mouseWheelMoved(Widget widget, WidgetAction.WidgetMouseWheelEvent event) {
        Scene scene = widget.getScene();
        if (scene == null) {
            return WidgetAction.State.REJECTED;
        }
        int amount = event.getWheelRotation();
        JScrollPane scrollPane = this.findScrollPane(scene.getView());
        Point viewPosition = new Point(0, 0);
        Point mouseLocation = scene.convertSceneToView(event.getPoint());
        int xOffset = 0;
        int yOffset = 0;
        Rectangle bounds = scene.getBounds();
        if (bounds == null) {
            return WidgetAction.State.CONSUMED;
        }
        Dimension componentSize = new Dimension(scene.getView().getPreferredSize());
        if (scrollPane != null) {
            viewPosition = scrollPane.getViewport().getViewPosition();
            xOffset = mouseLocation.x - viewPosition.x;
            yOffset = mouseLocation.y - viewPosition.y;
            viewPosition.x += xOffset;
            viewPosition.y += yOffset;
        }
        if (this.useAnimator) {
            SceneAnimator sceneAnimator;
            SceneAnimator sceneAnimator2 = sceneAnimator = scene.getSceneAnimator();
            synchronized (sceneAnimator2) {
                double zoom;
                double d = zoom = sceneAnimator.isAnimatingZoomFactor() ? sceneAnimator.getTargetZoomFactor() : scene.getZoomFactor();
                while (amount > 0 && zoom / this.zoomMultiplier >= this.minFactor) {
                    zoom /= this.zoomMultiplier;
                    if (viewPosition != null) {
                        viewPosition.x = (int)((double)viewPosition.x / this.zoomMultiplier);
                        viewPosition.y = (int)((double)viewPosition.y / this.zoomMultiplier);
                        bounds.width = (int)((double)bounds.width / this.zoomMultiplier);
                        bounds.height = (int)((double)bounds.height / this.zoomMultiplier);
                        componentSize.width = (int)((double)componentSize.width / this.zoomMultiplier);
                        componentSize.height = (int)((double)componentSize.height / this.zoomMultiplier);
                    }
                    --amount;
                }
                while (amount < 0 && zoom * this.zoomMultiplier <= this.maxFactor) {
                    zoom *= this.zoomMultiplier;
                    if (viewPosition != null) {
                        viewPosition.x = (int)((double)viewPosition.x * this.zoomMultiplier);
                        viewPosition.y = (int)((double)viewPosition.y * this.zoomMultiplier);
                        bounds.width = (int)((double)bounds.width * this.zoomMultiplier);
                        bounds.height = (int)((double)bounds.height * this.zoomMultiplier);
                        componentSize.width = (int)((double)componentSize.width * this.zoomMultiplier);
                        componentSize.height = (int)((double)componentSize.height * this.zoomMultiplier);
                    }
                    ++amount;
                }
                sceneAnimator.animateZoomFactor(zoom);
            }
        } else {
            double zoom = scene.getZoomFactor();
            while (amount > 0 && zoom / this.zoomMultiplier >= this.minFactor) {
                zoom /= this.zoomMultiplier;
                viewPosition.x = (int)((double)viewPosition.x / this.zoomMultiplier);
                viewPosition.y = (int)((double)viewPosition.y / this.zoomMultiplier);
                bounds.width = (int)((double)bounds.width / this.zoomMultiplier);
                bounds.height = (int)((double)bounds.height / this.zoomMultiplier);
                componentSize.width = (int)((double)componentSize.width / this.zoomMultiplier);
                componentSize.height = (int)((double)componentSize.height / this.zoomMultiplier);
                --amount;
            }
            while (amount < 0 && zoom * this.zoomMultiplier <= this.maxFactor) {
                zoom *= this.zoomMultiplier;
                viewPosition.x = (int)((double)viewPosition.x * this.zoomMultiplier);
                viewPosition.y = (int)((double)viewPosition.y * this.zoomMultiplier);
                bounds.width = (int)((double)bounds.width * this.zoomMultiplier);
                bounds.height = (int)((double)bounds.height * this.zoomMultiplier);
                componentSize.width = (int)((double)componentSize.width * this.zoomMultiplier);
                componentSize.height = (int)((double)componentSize.height * this.zoomMultiplier);
                ++amount;
            }
            scene.setZoomFactor(zoom);
        }
        if (scrollPane != null) {
            viewPosition.x -= xOffset;
            viewPosition.y -= yOffset;
            scrollPane.getViewport().setViewPosition(viewPosition);
        }
        return WidgetAction.State.CONSUMED;
    }
}

