/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.difference.impl;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.openide.util.Exceptions;

public class DiffGraph
extends InputGraph
implements Group.LazyContent<Collection<InputNode>> {
    private CompletableFuture<Collection<InputNode>> f;
    private final InputGraph a;
    private final InputGraph b;
    private final DiffGraphCompletion completer;

    public DiffGraph(Object id, String format, Object[] args, InputGraph a, InputGraph b, DiffGraphCompletion completer) {
        super(id, -1, format, args);
        assert (completer != null);
        assert (a.getGraphType().equals(b.getGraphType()));
        this.setGraphType(a.getGraphType());
        this.a = a;
        this.b = b;
        this.completer = completer;
    }

    private InputGraph completeDiffGraph() {
        Object ta = DiffGraph.completeLazy(this.a);
        Object tb = DiffGraph.completeLazy(this.b);
        this.completer.complete(this.a, this.b, this);
        return this;
    }

    private static Object completeLazy(InputGraph g) {
        Group.LazyContent lg;
        if (g instanceof Group.LazyContent && !(lg = (Group.LazyContent)g).isComplete()) {
            try {
                return lg.completeContents(null).get();
            }
            catch (InterruptedException | ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    public boolean isComplete() {
        if (this.f == null) {
            return false;
        }
        return this.f.isDone();
    }

    public Future<Collection<InputNode>> completeContents(Group.Feedback feedback) {
        if (this.f == null) {
            this.f = CompletableFuture.supplyAsync(() -> this.completeDiffGraph().getNodes());
        }
        return this.f;
    }

    public Collection<InputNode> partialData() {
        return null;
    }

    public static interface DiffGraphCompletion {
        public DiffGraph complete(InputGraph var1, InputGraph var2, DiffGraph var3);
    }
}

