/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.modules.project.ui.groups.Bundle;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.modules.project.ui.groups.ManageGroupsPanel;
import org.netbeans.modules.project.ui.groups.NewGroupPanel;
import org.netbeans.modules.project.uiapi.BaseUtilities;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class GroupsMenu
extends AbstractAction {
    private static final RequestProcessor RP = new RequestProcessor(GroupsMenu.class.getName());
    private static final String HELPCTX = "org.netbeans.modules.project.ui.groups.GroupsMenu";

    public GroupsMenu() {
        super(Bundle.GroupsMenu_label());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GroupsMenu.manageGroups();
    }

    private static void newGroup() {
        NewGroupPanel panel = new NewGroupPanel();
        DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.GroupsMenu_new_title());
        panel.setNotificationLineSupport(dd.createNotificationLineSupport());
        dd.setOptionType(2);
        dd.setModal(true);
        dd.setHelpCtx(new HelpCtx(HELPCTX));
        JButton create = new JButton(Bundle.GroupsMenu_new_create());
        create.setDefaultCapable(true);
        create.setEnabled(panel.isReady());
        panel.addPropertyChangeListener(evt -> {
            if ("ready".equals(evt.getPropertyName())) {
                create.setEnabled(panel.isReady());
            }
        });
        JButton close = new JButton(Bundle.GroupsMenu_new_close());
        dd.setOptions(new Object[]{create, close});
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (result.equals(create)) {
            assert (panel.isReady());
            NewGroupPanel.Type type = panel.getSelectedType();
            boolean autoSync = panel.isAutoSyncField();
            boolean useOpen = panel.isUseOpenedField();
            String name = panel.getNameField();
            String masterProject = panel.getMasterProjectField();
            String directory = panel.getDirectoryField();
            RP.post(() -> {
                Group g = NewGroupPanel.create(type, name, autoSync, useOpen, masterProject, directory);
                Group.setActiveGroup(g, true);
                SwingUtilities.invokeLater(GroupsMenu::manageGroups);
            });
        } else {
            SwingUtilities.invokeLater(GroupsMenu::manageGroups);
        }
    }

    private static void manageGroups() {
        ManageGroupsPanel panel = new ManageGroupsPanel();
        DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.GroupsMenu_manage_title());
        dd.setOptionType(2);
        dd.setModal(true);
        dd.setHelpCtx(new HelpCtx(HELPCTX));
        JButton select = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)select, (String)Bundle.GroupsMenu_manage_select_group());
        select.setDefaultCapable(true);
        panel.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("selection")) {
                select.setEnabled(panel.isExactlyOneGroupSelected());
            }
        });
        select.addActionListener(e -> RP.post(() -> Group.setActiveGroup(panel.getSelectedGroups()[0], false)));
        JButton newGroup = new JButton();
        newGroup.setDefaultCapable(false);
        Mnemonics.setLocalizedText((AbstractButton)newGroup, (String)Bundle.GroupsMenu_manage_new_group());
        newGroup.addActionListener(e -> SwingUtilities.invokeLater(GroupsMenu::newGroup));
        JButton close = new JButton(Bundle.GroupsMenu_manage_close());
        close.setDefaultCapable(false);
        dd.setOptions(new Object[]{select, newGroup, close});
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
    }

    static void openProperties(Group g) {
        Lookup context = Lookups.fixed((Object[])new Object[]{g, BaseUtilities.ACCESSOR.createGroup(g.getName(), g.prefs())});
        Dialog dialog = ProjectCustomizer.createCustomizerDialog((String)"Projects/Groups/Customizer", (Lookup)context, (String)null, ae -> {}, ae -> {}, (HelpCtx)new HelpCtx(HELPCTX));
        dialog.setTitle(Bundle.GroupsMenu_properties_title());
        dialog.setModal(true);
        dialog.setVisible(true);
    }
}

