/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filterwindow;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.graalvm.visualizer.filterwindow.CheckNode;
import org.graalvm.visualizer.filterwindow.CheckNodeListModel;
import org.openide.explorer.view.NodeRenderer;

public class CheckRenderer
extends NodeRenderer {
    private final Wrap wrapComponent = new Wrap();

    Rectangle getCheckRect() {
        return this.wrapComponent.check.getBounds();
    }

    public CheckRenderer() {
        this.setShowIcons(true);
    }

    Dimension getPreferredSize() {
        return this.wrapComponent.getPreferredSize();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean sel, boolean cellHasFocus) {
        JComponent c = (JComponent)super.getListCellRendererComponent(list, value, index, sel, cellHasFocus);
        CheckNode node = ((CheckNodeListModel)((Object)list.getModel())).getCheckNodeAt(index);
        this.wrapComponent.setSelected(list.isEnabled(), node.isSelected());
        this.wrapComponent.setPainted(c);
        return this.wrapComponent;
    }

    private static class Wrap
    extends JComponent {
        private final JCheckBox check = new JCheckBox();
        JComponent toPaint;

        Wrap() {
            this.add((Component)this.check, null);
        }

        void setPainted(JComponent painted) {
            if (this.toPaint != painted) {
                if (this.toPaint != null) {
                    this.remove(this.toPaint);
                }
                this.toPaint = painted;
                this.add((Component)this.toPaint, null);
                this.check.setBackground(this.toPaint.getBackground());
            }
            this.doLayout();
        }

        @Override
        public void doLayout() {
            Dimension cDim = this.check.getPreferredSize();
            Dimension size = this.getPreferredSize();
            Dimension pDim = this.toPaint.getPreferredSize();
            Insets ins = this.getInsets();
            size.height -= ins.top + ins.bottom;
            int x = ins.left;
            int y = cDim.height >= size.height ? ins.top : ins.top + (size.height - cDim.height) / 2;
            this.check.setBounds(x, y, cDim.width, cDim.height);
            x += cDim.width;
            if (this.toPaint != null) {
                y = pDim.height >= size.height ? ins.top : ins.top + (size.height - pDim.height) / 2;
                this.toPaint.setBounds(x, y, pDim.width, pDim.height);
            }
        }

        @Override
        protected void paintChildren(Graphics g) {
        }

        @Override
        public void paintComponent(Graphics g) {
            Dimension dCheck = this.check.getSize();
            Dimension dLabel = this.toPaint.getPreferredSize();
            Insets insets = this.getInsets();
            int x = insets.left;
            int y = insets.top;
            this.check.setBounds(x, y, dCheck.width, dCheck.height);
            this.check.paint(g);
            int yLabel = y;
            if (dCheck.height >= dLabel.height) {
                yLabel = (dCheck.height - dLabel.height) / 2;
            }
            g.translate(x += dCheck.width, yLabel);
            this.toPaint.paint(g);
            g.translate(-x, -yLabel);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension cSize = this.check.getPreferredSize();
            Dimension pSize = this.toPaint == null ? new Dimension(0, 0) : this.toPaint.getPreferredSize();
            Insets ins = this.getInsets();
            return new Dimension(ins.left + ins.right + cSize.width + pSize.width, ins.top + ins.bottom + Math.max(cSize.height, pSize.height));
        }

        void setSelected(boolean enabled, boolean s) {
            this.check.setEnabled(enabled);
            this.check.setSelected(s);
        }
    }

    static class P
    extends JPanel {
        P() {
        }

        void doValidate() {
            super.validateTree();
        }
    }
}

