/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filterwindow.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.graalvm.visualizer.filter.profiles.FilterProfile;
import org.graalvm.visualizer.filter.profiles.Profiles;
import org.graalvm.visualizer.filter.profiles.mgmt.ProfileService;
import org.graalvm.visualizer.filter.profiles.mgmt.SimpleProfileSelector;
import org.graalvm.visualizer.filterwindow.actions.Bundle;
import org.graalvm.visualizer.filterwindow.actions.EditProfilePanel;
import org.graalvm.visualizer.util.swing.ActionUtils;
import org.graalvm.visualizer.util.swing.DropdownButton;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public class ManageProfileAction
extends AbstractAction
implements ActionListener,
Presenter.Toolbar,
ContextAwareAction,
LookupListener {
    public static final String ID_CATEGORY = "Filters";
    public static final String ID_ACTION = "org.graalvm.visualizer.filterwindow.actions.ManageProfileAction";
    private static final String ICON_MANAGE_PROFILE = "org/graalvm/visualizer/filterwindow/images/customizer.png";
    private static final String ICON_ADD_PROFILE = "org/graalvm/visualizer/filterwindow/images/add.png";
    private final Lookup context;
    private final ProfileService profiles;
    private final Lookup.Result<FilterProfile> contextResult;
    private FilterProfile target;
    private DropdownButton popButton;

    public ManageProfileAction() {
        this(null, Lookup.getDefault());
    }

    public ManageProfileAction(FilterProfile profile) {
        this(profile, Lookup.getDefault());
    }

    private ManageProfileAction(FilterProfile t, Lookup context) {
        this.context = context;
        this.profiles = (ProfileService)Lookup.getDefault().lookup(ProfileService.class);
        this.contextResult = context.lookupResult(FilterProfile.class);
        this.contextResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.contextResult));
        this.updateUI();
    }

    protected void updateUI() {
        this.target = (FilterProfile)this.context.lookup(FilterProfile.class);
        if (this.target == null || this.target == this.profiles.getDefaultProfile()) {
            this.putValue("Name", Bundle.ACTON_ManageProfile_Add());
        } else {
            this.putValue("Name", Bundle.ACTON_ManageProfile_Edit());
        }
        if (this.popButton == null) {
            return;
        }
        this.popButton.setEnabled(true);
        this.popButton.setToolTipText((String)this.getValue("Name"));
        this.popButton.setIcon((Icon)ImageUtilities.loadImageIcon((String)this.mainIconResource(), (boolean)false));
        this.popButton.setPopupEnabled(this.target != this.profiles.getDefaultProfile());
    }

    protected String mainIconResource() {
        boolean nonDefault = this.target != this.profiles.getDefaultProfile();
        return nonDefault ? ICON_MANAGE_PROFILE : ICON_ADD_PROFILE;
    }

    public Component getToolbarPresenter() {
        if (this.popButton != null) {
            return this.popButton;
        }
        boolean nonDefault = this.target != this.profiles.getDefaultProfile();
        DropdownButton button = new DropdownButton("", (Icon)ImageUtilities.loadImageIcon((String)this.mainIconResource(), (boolean)false), true, this::populateMenu, (ActionListener)this);
        if (nonDefault) {
            button.setPopupEnabled(true);
        }
        button.setEnabled(this.isEnabled());
        button.setToolTipText((String)this.getValue("Name"));
        this.popButton = button;
        return this.popButton;
    }

    private void populateMenu(JPopupMenu menu) {
        if (this.target == null || this.target == this.profiles.getDefaultProfile()) {
            return;
        }
        ActionUtils.populatePopupMenu((JPopupMenu)menu, null, (String)"IGV/ContextActions/ManageProfiles", (Lookup)this.context);
    }

    private Action action(String id) {
        Action a = Actions.forID((String)ID_CATEGORY, (String)id);
        if (a instanceof ContextAwareAction) {
            a = ((ContextAwareAction)a).createContextAwareInstance(this.context);
        }
        return a;
    }

    public Action createContextAwareInstance(Lookup lkp) {
        return new ManageProfileAction(null, lkp);
    }

    public void resultChanged(LookupEvent le) {
        SwingUtilities.invokeLater(this::updateUI);
    }

    @Override
    public final Object getValue(String name) {
        if ("iconBase".equals(name)) {
            return this.mainIconResource();
        }
        Object val = super.getValue(name);
        if (val == null && "SmallIcon".equals(name)) {
            val = ImageUtilities.loadImageIcon((String)this.mainIconResource(), (boolean)false);
        }
        return val;
    }

    static void manageProfile(ProfileService profiles, FilterProfile prof) {
        SimpleProfileSelector selector = Profiles.simpleSelector((FilterProfile)prof);
        JButton saveButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)saveButton, (String)Bundle.BUTTON_ProfileSave());
        EditProfilePanel panel = new EditProfilePanel(profiles);
        panel.setSelector(selector);
        Object[] opts = new Object[]{saveButton, DialogDescriptor.CANCEL_OPTION};
        DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.TITLE_EditProfile(), true, opts, DialogDescriptor.OK_OPTION, 0, null, null);
        dd.setClosingOptions(opts);
        NotificationLineSupport nls = dd.createNotificationLineSupport();
        panel.setNotifier(nls);
        panel.setProfile(prof);
        panel.addPropertyChangeListener(x -> {
            if (x.getPropertyName() == null || "inputValid".equals(x.getPropertyName())) {
                saveButton.setEnabled(panel.isInputValid());
            }
        });
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) != saveButton) {
            return;
        }
        String n = panel.getProfileName();
        try {
            if (!n.equals(prof.getName())) {
                profiles.renameProfile(prof, prof.getName());
            }
            if (panel.getSelector().isValid()) {
                panel.updateSelector();
                Profiles.saveSelector((SimpleProfileSelector)panel.getSelector());
            }
        }
        catch (IOException ex) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)Bundle.PROFILE_ErrorSavingProfile(ex.toString()));
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)msg);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FilterProfile prof = (FilterProfile)this.context.lookup(FilterProfile.class);
        if (prof == this.profiles.getDefaultProfile()) {
            Action a = ActionUtils.findAction((String)ID_CATEGORY, (String)"org.graalvm.visualizer.filterwindow.actions.NewProfileAction", (Lookup)this.context);
            if (a != null) {
                a.actionPerformed(e);
            }
            return;
        }
        ManageProfileAction.manageProfile(this.profiles, prof);
    }

    public static class ManageProfileMain
    extends AbstractAction {
        private final FilterProfile target;
        private final ProfileService profiles;

        public ManageProfileMain(FilterProfile profile) {
            this.target = profile;
            this.profiles = (ProfileService)Lookup.getDefault().lookup(ProfileService.class);
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && this.profiles.getDefaultProfile() != this.target;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ManageProfileAction.manageProfile(this.profiles, this.target);
        }
    }
}

