/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filterwindow.impl;

import java.util.HashMap;
import javax.swing.SwingUtilities;
import jdk.graal.compiler.graphio.parsing.model.ChangedEvent;
import jdk.graal.compiler.graphio.parsing.model.ChangedListener;
import org.graalvm.visualizer.filter.Filter;
import org.graalvm.visualizer.filter.FilterSequence;
import org.graalvm.visualizer.filter.profiles.FilterProfile;
import org.graalvm.visualizer.filter.profiles.mgmt.ProfileService;
import org.graalvm.visualizer.filterwindow.impl.FilterNode;
import org.graalvm.visualizer.util.ListenerSupport;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class FilterChildren
extends Children.Keys<Filter> {
    private final ProfileService service;
    private final FilterProfile profile;
    private final HashMap<Filter, Node> nodeHash = new HashMap();
    private ChangedListener<FilterSequence<?>> seqL;
    private ChangedListener<FilterSequence<?>> keep;

    protected Node[] createNodes(Filter filter) {
        if (this.nodeHash.containsKey(filter)) {
            return new Node[]{this.nodeHash.get(filter)};
        }
        FilterNode node = new FilterNode(filter, this.profile, this.service);
        this.nodeHash.put(filter, (Node)node);
        return new Node[]{node};
    }

    public FilterChildren(FilterProfile profile, ProfileService service) {
        this.profile = profile;
        this.service = service;
    }

    protected void addNotify() {
        this.keep = source -> this.makeRefresh();
        this.seqL = ListenerSupport.addWeakListener((ChangedListener)this.keep, (ChangedEvent)this.profile.getAllFilters().getChangedEvent());
        this.makeRefresh();
    }

    protected void removeNotify() {
        this.profile.getAllFilters().getChangedEvent().removeListener(this.seqL);
    }

    private void makeRefresh() {
        SwingUtilities.invokeLater(() -> this.setKeys(this.profile.getProfileFilters()));
    }
}

