/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filterwindow.impl;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collections;
import org.graalvm.visualizer.filter.profiles.FilterProfile;
import org.graalvm.visualizer.filter.profiles.mgmt.ProfileService;
import org.graalvm.visualizer.filter.profiles.mgmt.ProfileStorage;
import org.graalvm.visualizer.filterwindow.impl.FilterChildren;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.ImageDecorator;
import org.openide.filesystems.StatusDecorator;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class FilterProfileNode
extends AbstractNode {
    private final FilterProfile profile;
    private final ProfileService profileService;
    private final InstanceContent lookupContent;
    private volatile Image cachedIcon;

    public FilterProfileNode(FilterProfile profile, ProfileService profileService) {
        this(profile, profileService, new InstanceContent());
    }

    private FilterProfileNode(FilterProfile profile, ProfileService profileService, InstanceContent lkpContent) {
        super((Children)new FilterChildren(profile, profileService), (Lookup)new AbstractLookup((AbstractLookup.Content)lkpContent));
        this.profile = profile;
        this.profileService = profileService;
        this.lookupContent = lkpContent;
        lkpContent.add((Object)profile);
        this.setName(profile.getName());
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public Image getIcon(int type) {
        if (this.cachedIcon == null) {
            Image img = ImageUtilities.loadImage((String)"org/graalvm/visualizer/filterwindow/images/filter-profile.png");
            ProfileStorage storage = (ProfileStorage)this.profileService.getLookup().lookup(ProfileStorage.class);
            FileObject fld = storage.getProfileFolder(this.profile);
            try {
                StatusDecorator deco = fld.getFileSystem().getDecorator();
                if (deco instanceof ImageDecorator) {
                    img = ((ImageDecorator)deco).annotateIcon(img, type, Collections.singleton(fld));
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.cachedIcon = img;
        }
        return this.cachedIcon;
    }

    public static Node create(FilterProfile f) {
        return new FilterProfileNode(f, (ProfileService)Lookup.getDefault().lookup(ProfileService.class));
    }

    public static Node createProfileParent() {
        return new AbstractNode((Children)new Ch((ProfileService)Lookup.getDefault().lookup(ProfileService.class)));
    }

    static class Ch
    extends Children.Keys<FilterProfile>
    implements PropertyChangeListener {
        private final ProfileService profileService;

        public Ch(ProfileService profileService) {
            this.profileService = profileService;
        }

        protected void removeNotify() {
            this.profileService.removePropertyChangeListener((PropertyChangeListener)this);
            super.removeNotify();
        }

        protected void addNotify() {
            super.addNotify();
            this.profileService.addPropertyChangeListener((PropertyChangeListener)this);
            this.setKeys(this.profileService.getProfiles());
        }

        protected Node[] createNodes(FilterProfile t) {
            return new Node[]{new FilterProfileNode(t, this.profileService)};
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("profiles".equals(evt.getPropertyName())) {
                this.setKeys(this.profileService.getProfiles());
            }
        }
    }
}

